/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class hwloc_cache_attr_s
extends Struct<hwloc_cache_attr_s> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int DEPTH;
    public static final int LINESIZE;
    public static final int ASSOCIATIVITY;
    public static final int TYPE;

    protected hwloc_cache_attr_s(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected hwloc_cache_attr_s create(long address, @Nullable ByteBuffer container) {
        return new hwloc_cache_attr_s(address, container);
    }

    public hwloc_cache_attr_s(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), hwloc_cache_attr_s.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="hwloc_uint64_t")
    public long size() {
        return hwloc_cache_attr_s.nsize(this.address());
    }

    @NativeType(value="unsigned")
    public int depth() {
        return hwloc_cache_attr_s.ndepth(this.address());
    }

    @NativeType(value="unsigned")
    public int linesize() {
        return hwloc_cache_attr_s.nlinesize(this.address());
    }

    public int associativity() {
        return hwloc_cache_attr_s.nassociativity(this.address());
    }

    @NativeType(value="hwloc_obj_cache_type_t")
    public int type() {
        return hwloc_cache_attr_s.ntype(this.address());
    }

    public static hwloc_cache_attr_s create(long address) {
        return new hwloc_cache_attr_s(address, null);
    }

    @Nullable
    public static hwloc_cache_attr_s createSafe(long address) {
        return address == 0L ? null : new hwloc_cache_attr_s(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int ndepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTH);
    }

    public static int nlinesize(long struct) {
        return UNSAFE.getInt(null, struct + (long)LINESIZE);
    }

    public static int nassociativity(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASSOCIATIVITY);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    static {
        Struct.Layout layout = hwloc_cache_attr_s.__struct((Struct.Member[])new Struct.Member[]{hwloc_cache_attr_s.__member((int)8), hwloc_cache_attr_s.__member((int)4), hwloc_cache_attr_s.__member((int)4), hwloc_cache_attr_s.__member((int)4), hwloc_cache_attr_s.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        DEPTH = layout.offsetof(1);
        LINESIZE = layout.offsetof(2);
        ASSOCIATIVITY = layout.offsetof(3);
        TYPE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<hwloc_cache_attr_s, Buffer> {
        private static final hwloc_cache_attr_s ELEMENT_FACTORY = hwloc_cache_attr_s.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected hwloc_cache_attr_s getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="hwloc_uint64_t")
        public long size() {
            return hwloc_cache_attr_s.nsize(this.address());
        }

        @NativeType(value="unsigned")
        public int depth() {
            return hwloc_cache_attr_s.ndepth(this.address());
        }

        @NativeType(value="unsigned")
        public int linesize() {
            return hwloc_cache_attr_s.nlinesize(this.address());
        }

        public int associativity() {
            return hwloc_cache_attr_s.nassociativity(this.address());
        }

        @NativeType(value="hwloc_obj_cache_type_t")
        public int type() {
            return hwloc_cache_attr_s.ntype(this.address());
        }
    }
}

