/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.lwjgl.CLongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.util.hwloc.hwloc_bridge_attr_s;
import org.lwjgl.util.hwloc.hwloc_distances_s;
import org.lwjgl.util.hwloc.hwloc_info_s;
import org.lwjgl.util.hwloc.hwloc_infos_s;
import org.lwjgl.util.hwloc.hwloc_location;
import org.lwjgl.util.hwloc.hwloc_obj;
import org.lwjgl.util.hwloc.hwloc_obj_attr_u;
import org.lwjgl.util.hwloc.hwloc_pcidev_attr_s;
import org.lwjgl.util.hwloc.hwloc_topology_support;
import org.lwjgl.util.hwloc.topology_set_userdata_export_callbackI;
import org.lwjgl.util.hwloc.topology_set_userdata_import_callbackI;

public class HWLoc {
    private static final SharedLibrary HWLOC = Library.loadNative(HWLoc.class, (String)"org.lwjgl.hwloc", (String)((String)Configuration.HWLOC_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"hwloc"))), (boolean)true);
    public static final int HWLOC_API_VERSION = 196608;
    public static final int HWLOC_COMPONENT_ABI = 8;
    public static final int HWLOC_TYPE_UNORDERED = Integer.MAX_VALUE;
    public static final int HWLOC_UNKNOWN_INDEX = -1;
    public static final int HWLOC_OBJ_TYPE_MIN = 0;
    public static final int HWLOC_OBJ_MACHINE = 0;
    public static final int HWLOC_OBJ_PACKAGE = 1;
    public static final int HWLOC_OBJ_CORE = 2;
    public static final int HWLOC_OBJ_PU = 3;
    public static final int HWLOC_OBJ_L1CACHE = 4;
    public static final int HWLOC_OBJ_L2CACHE = 5;
    public static final int HWLOC_OBJ_L3CACHE = 6;
    public static final int HWLOC_OBJ_L4CACHE = 7;
    public static final int HWLOC_OBJ_L5CACHE = 8;
    public static final int HWLOC_OBJ_L1ICACHE = 9;
    public static final int HWLOC_OBJ_L2ICACHE = 10;
    public static final int HWLOC_OBJ_L3ICACHE = 11;
    public static final int HWLOC_OBJ_GROUP = 12;
    public static final int HWLOC_OBJ_NUMANODE = 13;
    public static final int HWLOC_OBJ_BRIDGE = 14;
    public static final int HWLOC_OBJ_PCI_DEVICE = 15;
    public static final int HWLOC_OBJ_OS_DEVICE = 16;
    public static final int HWLOC_OBJ_MISC = 17;
    public static final int HWLOC_OBJ_MEMCACHE = 18;
    public static final int HWLOC_OBJ_DIE = 19;
    public static final int HWLOC_OBJ_TYPE_MAX = 20;
    public static final int HWLOC_OBJ_CACHE_UNIFIED = 0;
    public static final int HWLOC_OBJ_CACHE_DATA = 1;
    public static final int HWLOC_OBJ_CACHE_INSTRUCTION = 2;
    public static final int HWLOC_OBJ_BRIDGE_HOST = 0;
    public static final int HWLOC_OBJ_BRIDGE_PCI = 1;
    public static final long HWLOC_OBJ_OSDEV_STORAGE = 1L;
    public static final long HWLOC_OBJ_OSDEV_MEMORY = 2L;
    public static final long HWLOC_OBJ_OSDEV_GPU = 4L;
    public static final long HWLOC_OBJ_OSDEV_COPROC = 8L;
    public static final long HWLOC_OBJ_OSDEV_NETWORK = 16L;
    public static final long HWLOC_OBJ_OSDEV_OPENFABRICS = 32L;
    public static final long HWLOC_OBJ_OSDEV_DMA = 64L;
    public static final int HWLOC_TYPE_DEPTH_UNKNOWN = -1;
    public static final int HWLOC_TYPE_DEPTH_MULTIPLE = -2;
    public static final int HWLOC_TYPE_DEPTH_NUMANODE = -3;
    public static final int HWLOC_TYPE_DEPTH_BRIDGE = -4;
    public static final int HWLOC_TYPE_DEPTH_PCI_DEVICE = -5;
    public static final int HWLOC_TYPE_DEPTH_OS_DEVICE = -6;
    public static final int HWLOC_TYPE_DEPTH_MISC = -7;
    public static final int HWLOC_TYPE_DEPTH_MEMCACHE = -8;
    public static final long HWLOC_OBJ_SNPRINTF_FLAG_LONG_NAMES = 2L;
    public static final long HWLOC_OBJ_SNPRINTF_FLAG_SHORT_NAMES = 4L;
    public static final long HWLOC_OBJ_SNPRINTF_FLAG_MORE_ATTRS = 8L;
    public static final long HWLOC_OBJ_SNPRINTF_FLAG_NO_UNITS = 16L;
    public static final long HWLOC_OBJ_SNPRINTF_FLAG_UNITS_1000 = 32L;
    public static final long HWLOC_OBJ_SNPRINTF_FLAG_OLD_VERBOSE = 1L;
    public static final int HWLOC_CPUBIND_PROCESS = 1;
    public static final int HWLOC_CPUBIND_THREAD = 2;
    public static final int HWLOC_CPUBIND_STRICT = 4;
    public static final int HWLOC_CPUBIND_NOMEMBIND = 8;
    public static final int HWLOC_MEMBIND_DEFAULT = 0;
    public static final int HWLOC_MEMBIND_FIRSTTOUCH = 1;
    public static final int HWLOC_MEMBIND_BIND = 2;
    public static final int HWLOC_MEMBIND_INTERLEAVE = 3;
    public static final int HWLOC_MEMBIND_WEIGHTED_INTERLEAVE = 5;
    public static final int HWLOC_MEMBIND_NEXTTOUCH = 4;
    public static final int HWLOC_MEMBIND_MIXED = -1;
    public static final int HWLOC_MEMBIND_PROCESS = 1;
    public static final int HWLOC_MEMBIND_THREAD = 2;
    public static final int HWLOC_MEMBIND_STRICT = 4;
    public static final int HWLOC_MEMBIND_MIGRATE = 8;
    public static final int HWLOC_MEMBIND_NOCPUBIND = 16;
    public static final int HWLOC_MEMBIND_BYNODESET = 32;
    public static final long HWLOC_TOPOLOGY_COMPONENTS_FLAG_BLACKLIST = 1L;
    public static final long HWLOC_TOPOLOGY_FLAG_INCLUDE_DISALLOWED = 1L;
    public static final long HWLOC_TOPOLOGY_FLAG_IS_THISSYSTEM = 2L;
    public static final long HWLOC_TOPOLOGY_FLAG_THISSYSTEM_ALLOWED_RESOURCES = 4L;
    public static final long HWLOC_TOPOLOGY_FLAG_IMPORT_SUPPORT = 8L;
    public static final long HWLOC_TOPOLOGY_FLAG_RESTRICT_TO_CPUBINDING = 16L;
    public static final long HWLOC_TOPOLOGY_FLAG_RESTRICT_TO_MEMBINDING = 32L;
    public static final long HWLOC_TOPOLOGY_FLAG_DONT_CHANGE_BINDING = 64L;
    public static final long HWLOC_TOPOLOGY_FLAG_NO_DISTANCES = 128L;
    public static final long HWLOC_TOPOLOGY_FLAG_NO_MEMATTRS = 256L;
    public static final long HWLOC_TOPOLOGY_FLAG_NO_CPUKINDS = 512L;
    public static final int HWLOC_TYPE_FILTER_KEEP_ALL = 0;
    public static final int HWLOC_TYPE_FILTER_KEEP_NONE = 1;
    public static final int HWLOC_TYPE_FILTER_KEEP_STRUCTURE = 2;
    public static final int HWLOC_TYPE_FILTER_KEEP_IMPORTANT = 3;
    public static final long HWLOC_RESTRICT_FLAG_REMOVE_CPULESS = 1L;
    public static final long HWLOC_RESTRICT_FLAG_BYNODESET = 8L;
    public static final long HWLOC_RESTRICT_FLAG_REMOVE_MEMLESS = 16L;
    public static final long HWLOC_RESTRICT_FLAG_ADAPT_MISC = 2L;
    public static final long HWLOC_RESTRICT_FLAG_ADAPT_IO = 4L;
    public static final long HWLOC_ALLOW_FLAG_ALL = 1L;
    public static final long HWLOC_ALLOW_FLAG_LOCAL_RESTRICTIONS = 2L;
    public static final long HWLOC_ALLOW_FLAG_CUSTOM = 4L;
    public static final long HWLOC_MODIFY_INFOS_OP_ADD = 1L;
    public static final long HWLOC_MODIFY_INFOS_OP_ADD_UNIQUE = 2L;
    public static final long HWLOC_MODIFY_INFOS_OP_REPLACE = 4L;
    public static final long HWLOC_MODIFY_INFOS_OP_REMOVE = 8L;
    public static final long HWLOC_DISTRIB_FLAG_REVERSE = 1L;
    public static final int HWLOC_MEMATTR_ID_CAPACITY = 0;
    public static final int HWLOC_MEMATTR_ID_LOCALITY = 1;
    public static final int HWLOC_MEMATTR_ID_BANDWIDTH = 2;
    public static final int HWLOC_MEMATTR_ID_READ_BANDWIDTH = 4;
    public static final int HWLOC_MEMATTR_ID_WRITE_BANDWIDTH = 5;
    public static final int HWLOC_MEMATTR_ID_LATENCY = 3;
    public static final int HWLOC_MEMATTR_ID_READ_LATENCY = 6;
    public static final int HWLOC_MEMATTR_ID_WRITE_LATENCY = 7;
    public static final int HWLOC_LOCATION_TYPE_CPUSET = 1;
    public static final int HWLOC_LOCATION_TYPE_OBJECT = 0;
    public static final long HWLOC_LOCAL_NUMANODE_FLAG_LARGER_LOCALITY = 1L;
    public static final long HWLOC_LOCAL_NUMANODE_FLAG_SMALLER_LOCALITY = 2L;
    public static final long HWLOC_LOCAL_NUMANODE_FLAG_ALL = 4L;
    public static final long HWLOC_MEMATTR_FLAG_HIGHER_FIRST = 1L;
    public static final long HWLOC_MEMATTR_FLAG_LOWER_FIRST = 2L;
    public static final long HWLOC_MEMATTR_FLAG_NEED_INITIATOR = 4L;
    public static final long HWLOC_TOPOLOGY_EXPORT_XML_FLAG_V2 = 2L;
    public static final long HWLOC_TOPOLOGY_EXPORT_SYNTHETIC_FLAG_NO_EXTENDED_TYPES = 1L;
    public static final long HWLOC_TOPOLOGY_EXPORT_SYNTHETIC_FLAG_NO_ATTRS = 2L;
    public static final long HWLOC_TOPOLOGY_EXPORT_SYNTHETIC_FLAG_V1 = 4L;
    public static final long HWLOC_TOPOLOGY_EXPORT_SYNTHETIC_FLAG_IGNORE_MEMORY = 8L;
    public static final long HWLOC_DISTANCES_KIND_FROM_OS = 1L;
    public static final long HWLOC_DISTANCES_KIND_FROM_USER = 2L;
    public static final long HWLOC_DISTANCES_KIND_VALUE_LATENCY = 4L;
    public static final long HWLOC_DISTANCES_KIND_VALUE_BANDWIDTH = 8L;
    public static final long HWLOC_DISTANCES_KIND_VALUE_HOPS = 32L;
    public static final long HWLOC_DISTANCES_KIND_HETEROGENEOUS_TYPES = 16L;
    public static final int HWLOC_DISTANCES_TRANSFORM_REMOVE_NULL = 0;
    public static final int HWLOC_DISTANCES_TRANSFORM_LINKS = 1;
    public static final int HWLOC_DISTANCES_TRANSFORM_MERGE_SWITCH_PORTS = 2;
    public static final int HWLOC_DISTANCES_TRANSFORM_TRANSITIVE_CLOSURE = 3;
    public static final long HWLOC_DISTANCES_ADD_FLAG_GROUP = 1L;
    public static final long HWLOC_DISTANCES_ADD_FLAG_GROUP_INACCURATE = 2L;
    public static final int HWLOC_TOPOLOGY_DIFF_OBJ_ATTR_SIZE = 0;
    public static final int HWLOC_TOPOLOGY_DIFF_OBJ_ATTR_NAME = 1;
    public static final int HWLOC_TOPOLOGY_DIFF_OBJ_ATTR_INFO = 2;
    public static final int HWLOC_TOPOLOGY_DIFF_OBJ_ATTR = 0;
    public static final int HWLOC_TOPOLOGY_DIFF_TOO_COMPLEX = 1;
    public static final long HWLOC_TOPOLOGY_DIFF_APPLY_REVERSE = 1L;
    private static final Pattern BUSID_PATTERN = Pattern.compile("^(?:(\\p{XDigit}+):)?(\\p{XDigit}+):(\\p{XDigit}+)\\.(\\p{XDigit}+)$");

    public static SharedLibrary getLibrary() {
        return HWLOC;
    }

    protected HWLoc() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="hwloc_bitmap_t")
    public static long hwloc_bitmap_alloc() {
        long __functionAddress = Functions.bitmap_alloc;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="hwloc_bitmap_t")
    public static long hwloc_bitmap_alloc_full() {
        long __functionAddress = Functions.bitmap_alloc_full;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void hwloc_bitmap_free(@NativeType(value="hwloc_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_free;
        JNI.invokePV((long)bitmap, (long)__functionAddress);
    }

    @NativeType(value="hwloc_bitmap_t")
    public static long hwloc_bitmap_dup(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_dup;
        return JNI.invokePP((long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_copy(@NativeType(value="hwloc_bitmap_t") long dst, @NativeType(value="hwloc_const_bitmap_t") long src) {
        long __functionAddress = Functions.bitmap_copy;
        if (Checks.CHECKS) {
            Checks.check((long)dst);
            Checks.check((long)src);
        }
        return JNI.invokePPI((long)dst, (long)src, (long)__functionAddress);
    }

    public static int nhwloc_bitmap_snprintf(long buf, long buflen, long bitmap) {
        long __functionAddress = Functions.bitmap_snprintf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPPI((long)buf, (long)buflen, (long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_snprintf(@Nullable @NativeType(value="char *") ByteBuffer buf, @NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        return HWLoc.nhwloc_bitmap_snprintf(MemoryUtil.memAddressSafe((ByteBuffer)buf), Checks.remainingSafe((Buffer)buf), bitmap);
    }

    public static int nhwloc_bitmap_asprintf(long strp, long bitmap) {
        long __functionAddress = Functions.bitmap_asprintf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)strp, (long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_asprintf(@NativeType(value="char **") PointerBuffer strp, @NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)strp, (int)1);
        }
        return HWLoc.nhwloc_bitmap_asprintf(MemoryUtil.memAddress((CustomBuffer)strp), bitmap);
    }

    public static int nhwloc_bitmap_sscanf(long bitmap, long string) {
        long __functionAddress = Functions.bitmap_sscanf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)bitmap, (long)string, (long)__functionAddress);
    }

    public static int hwloc_bitmap_sscanf(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="char const *") ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)string);
        }
        return HWLoc.nhwloc_bitmap_sscanf(bitmap, MemoryUtil.memAddress((ByteBuffer)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_bitmap_sscanf(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="char const *") CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(string, true);
            long stringEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_bitmap_sscanf(bitmap, stringEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_bitmap_list_snprintf(long buf, long buflen, long bitmap) {
        long __functionAddress = Functions.bitmap_list_snprintf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPPI((long)buf, (long)buflen, (long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_list_snprintf(@Nullable @NativeType(value="char *") ByteBuffer buf, @NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        return HWLoc.nhwloc_bitmap_list_snprintf(MemoryUtil.memAddressSafe((ByteBuffer)buf), Checks.remainingSafe((Buffer)buf), bitmap);
    }

    public static int nhwloc_bitmap_list_asprintf(long strp, long bitmap) {
        long __functionAddress = Functions.bitmap_list_asprintf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)strp, (long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_list_asprintf(@NativeType(value="char **") PointerBuffer strp, @NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)strp, (int)1);
        }
        return HWLoc.nhwloc_bitmap_list_asprintf(MemoryUtil.memAddress((CustomBuffer)strp), bitmap);
    }

    public static int nhwloc_bitmap_list_sscanf(long bitmap, long string) {
        long __functionAddress = Functions.bitmap_list_sscanf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)bitmap, (long)string, (long)__functionAddress);
    }

    public static int hwloc_bitmap_list_sscanf(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="char const *") ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)string);
        }
        return HWLoc.nhwloc_bitmap_list_sscanf(bitmap, MemoryUtil.memAddress((ByteBuffer)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_bitmap_list_sscanf(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="char const *") CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(string, true);
            long stringEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_bitmap_list_sscanf(bitmap, stringEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_bitmap_taskset_snprintf(long buf, long buflen, long bitmap) {
        long __functionAddress = Functions.bitmap_taskset_snprintf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPPI((long)buf, (long)buflen, (long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_taskset_snprintf(@Nullable @NativeType(value="char *") ByteBuffer buf, @NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        return HWLoc.nhwloc_bitmap_taskset_snprintf(MemoryUtil.memAddressSafe((ByteBuffer)buf), Checks.remainingSafe((Buffer)buf), bitmap);
    }

    public static int nhwloc_bitmap_taskset_asprintf(long strp, long bitmap) {
        long __functionAddress = Functions.bitmap_taskset_asprintf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)strp, (long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_taskset_asprintf(@NativeType(value="char **") PointerBuffer strp, @NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)strp, (int)1);
        }
        return HWLoc.nhwloc_bitmap_taskset_asprintf(MemoryUtil.memAddress((CustomBuffer)strp), bitmap);
    }

    public static int nhwloc_bitmap_taskset_sscanf(long bitmap, long string) {
        long __functionAddress = Functions.bitmap_taskset_sscanf;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)bitmap, (long)string, (long)__functionAddress);
    }

    public static int hwloc_bitmap_taskset_sscanf(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="char const *") ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)string);
        }
        return HWLoc.nhwloc_bitmap_taskset_sscanf(bitmap, MemoryUtil.memAddress((ByteBuffer)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_bitmap_taskset_sscanf(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="char const *") CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(string, true);
            long stringEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_bitmap_taskset_sscanf(bitmap, stringEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void hwloc_bitmap_zero(@NativeType(value="hwloc_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_zero;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        JNI.invokePV((long)bitmap, (long)__functionAddress);
    }

    public static void hwloc_bitmap_fill(@NativeType(value="hwloc_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_fill;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        JNI.invokePV((long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_only(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned int") int id) {
        long __functionAddress = Functions.bitmap_only;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)id, (long)__functionAddress);
    }

    public static int hwloc_bitmap_allbut(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned int") int id) {
        long __functionAddress = Functions.bitmap_allbut;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)id, (long)__functionAddress);
    }

    public static int hwloc_bitmap_from_ulong(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned long") long mask) {
        long __functionAddress = Functions.bitmap_from_ulong;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePNI((long)bitmap, (long)mask, (long)__functionAddress);
    }

    public static int hwloc_bitmap_from_ith_ulong(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned int") int i, @NativeType(value="unsigned long") long mask) {
        long __functionAddress = Functions.bitmap_from_ith_ulong;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePNI((long)bitmap, (int)i, (long)mask, (long)__functionAddress);
    }

    public static int nhwloc_bitmap_from_ulongs(long bitmap, int nr, long masks) {
        long __functionAddress = Functions.bitmap_from_ulongs;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)bitmap, (int)nr, (long)masks, (long)__functionAddress);
    }

    public static int hwloc_bitmap_from_ulongs(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned long const *") CLongBuffer masks) {
        return HWLoc.nhwloc_bitmap_from_ulongs(bitmap, masks.remaining(), MemoryUtil.memAddress((CustomBuffer)masks));
    }

    public static int hwloc_bitmap_set(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned int") int id) {
        long __functionAddress = Functions.bitmap_set;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)id, (long)__functionAddress);
    }

    public static int hwloc_bitmap_set_range(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned int") int begin, int end) {
        long __functionAddress = Functions.bitmap_set_range;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)begin, (int)end, (long)__functionAddress);
    }

    public static int hwloc_bitmap_set_ith_ulong(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned int") int i, @NativeType(value="unsigned long") long mask) {
        long __functionAddress = Functions.bitmap_set_ith_ulong;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePNI((long)bitmap, (int)i, (long)mask, (long)__functionAddress);
    }

    public static int hwloc_bitmap_clr(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned int") int id) {
        long __functionAddress = Functions.bitmap_clr;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)id, (long)__functionAddress);
    }

    public static int hwloc_bitmap_clr_range(@NativeType(value="hwloc_bitmap_t") long bitmap, @NativeType(value="unsigned int") int begin, int end) {
        long __functionAddress = Functions.bitmap_clr_range;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)begin, (int)end, (long)__functionAddress);
    }

    public static int hwloc_bitmap_singlify(@NativeType(value="hwloc_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_singlify;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress);
    }

    @NativeType(value="unsigned long")
    public static long hwloc_bitmap_to_ulong(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_to_ulong;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePN((long)bitmap, (long)__functionAddress);
    }

    @NativeType(value="unsigned long")
    public static long hwloc_bitmap_to_ith_ulong(@NativeType(value="hwloc_const_bitmap_t") long bitmap, @NativeType(value="unsigned int") int i) {
        long __functionAddress = Functions.bitmap_to_ith_ulong;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePN((long)bitmap, (int)i, (long)__functionAddress);
    }

    public static int nhwloc_bitmap_to_ulongs(long bitmap, int nr, long masks) {
        long __functionAddress = Functions.bitmap_to_ulongs;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)bitmap, (int)nr, (long)masks, (long)__functionAddress);
    }

    public static int hwloc_bitmap_to_ulongs(@NativeType(value="hwloc_const_bitmap_t") long bitmap, @NativeType(value="unsigned long *") CLongBuffer masks) {
        return HWLoc.nhwloc_bitmap_to_ulongs(bitmap, masks.remaining(), MemoryUtil.memAddress((CustomBuffer)masks));
    }

    public static int hwloc_bitmap_nr_ulongs(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_nr_ulongs;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean hwloc_bitmap_isset(@NativeType(value="hwloc_const_bitmap_t") long bitmap, @NativeType(value="unsigned int") int id) {
        long __functionAddress = Functions.bitmap_isset;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)id, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_bitmap_iszero(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_iszero;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_bitmap_isfull(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_isfull;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress) != 0;
    }

    public static int hwloc_bitmap_first(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_first;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_next(@NativeType(value="hwloc_const_bitmap_t") long bitmap, int prev) {
        long __functionAddress = Functions.bitmap_next;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)prev, (long)__functionAddress);
    }

    public static int hwloc_bitmap_last(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_last;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_weight(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_weight;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_first_unset(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_first_unset;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_next_unset(@NativeType(value="hwloc_const_bitmap_t") long bitmap, int prev) {
        long __functionAddress = Functions.bitmap_next_unset;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (int)prev, (long)__functionAddress);
    }

    public static int hwloc_bitmap_last_unset(@NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_last_unset;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap);
        }
        return JNI.invokePI((long)bitmap, (long)__functionAddress);
    }

    public static int hwloc_bitmap_or(@NativeType(value="hwloc_bitmap_t") long res, @NativeType(value="hwloc_const_bitmap_t") long bitmap1, @NativeType(value="hwloc_const_bitmap_t") long bitmap2) {
        long __functionAddress = Functions.bitmap_or;
        if (Checks.CHECKS) {
            Checks.check((long)res);
            Checks.check((long)bitmap1);
            Checks.check((long)bitmap2);
        }
        return JNI.invokePPPI((long)res, (long)bitmap1, (long)bitmap2, (long)__functionAddress);
    }

    public static int hwloc_bitmap_and(@NativeType(value="hwloc_bitmap_t") long res, @NativeType(value="hwloc_const_bitmap_t") long bitmap1, @NativeType(value="hwloc_const_bitmap_t") long bitmap2) {
        long __functionAddress = Functions.bitmap_and;
        if (Checks.CHECKS) {
            Checks.check((long)res);
            Checks.check((long)bitmap1);
            Checks.check((long)bitmap2);
        }
        return JNI.invokePPPI((long)res, (long)bitmap1, (long)bitmap2, (long)__functionAddress);
    }

    public static int hwloc_bitmap_andnot(@NativeType(value="hwloc_bitmap_t") long res, @NativeType(value="hwloc_const_bitmap_t") long bitmap1, @NativeType(value="hwloc_const_bitmap_t") long bitmap2) {
        long __functionAddress = Functions.bitmap_andnot;
        if (Checks.CHECKS) {
            Checks.check((long)res);
            Checks.check((long)bitmap1);
            Checks.check((long)bitmap2);
        }
        return JNI.invokePPPI((long)res, (long)bitmap1, (long)bitmap2, (long)__functionAddress);
    }

    public static int hwloc_bitmap_xor(@NativeType(value="hwloc_bitmap_t") long res, @NativeType(value="hwloc_const_bitmap_t") long bitmap1, @NativeType(value="hwloc_const_bitmap_t") long bitmap2) {
        long __functionAddress = Functions.bitmap_xor;
        if (Checks.CHECKS) {
            Checks.check((long)res);
            Checks.check((long)bitmap1);
            Checks.check((long)bitmap2);
        }
        return JNI.invokePPPI((long)res, (long)bitmap1, (long)bitmap2, (long)__functionAddress);
    }

    public static int hwloc_bitmap_not(@NativeType(value="hwloc_bitmap_t") long res, @NativeType(value="hwloc_const_bitmap_t") long bitmap) {
        long __functionAddress = Functions.bitmap_not;
        if (Checks.CHECKS) {
            Checks.check((long)res);
            Checks.check((long)bitmap);
        }
        return JNI.invokePPI((long)res, (long)bitmap, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean hwloc_bitmap_intersects(@NativeType(value="hwloc_const_bitmap_t") long bitmap1, @NativeType(value="hwloc_const_bitmap_t") long bitmap2) {
        long __functionAddress = Functions.bitmap_intersects;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap1);
            Checks.check((long)bitmap2);
        }
        return JNI.invokePPI((long)bitmap1, (long)bitmap2, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_bitmap_isincluded(@NativeType(value="hwloc_const_bitmap_t") long sub_bitmap, @NativeType(value="hwloc_const_bitmap_t") long super_bitmap) {
        long __functionAddress = Functions.bitmap_isincluded;
        if (Checks.CHECKS) {
            Checks.check((long)sub_bitmap);
            Checks.check((long)super_bitmap);
        }
        return JNI.invokePPI((long)sub_bitmap, (long)super_bitmap, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_bitmap_isequal(@NativeType(value="hwloc_const_bitmap_t") long bitmap1, @NativeType(value="hwloc_const_bitmap_t") long bitmap2) {
        long __functionAddress = Functions.bitmap_isequal;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap1);
            Checks.check((long)bitmap2);
        }
        return JNI.invokePPI((long)bitmap1, (long)bitmap2, (long)__functionAddress) != 0;
    }

    public static int hwloc_bitmap_compare_first(@NativeType(value="hwloc_const_bitmap_t") long bitmap1, @NativeType(value="hwloc_const_bitmap_t") long bitmap2) {
        long __functionAddress = Functions.bitmap_compare_first;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap1);
            Checks.check((long)bitmap2);
        }
        return JNI.invokePPI((long)bitmap1, (long)bitmap2, (long)__functionAddress);
    }

    public static int hwloc_bitmap_compare(@NativeType(value="hwloc_const_bitmap_t") long bitmap1, @NativeType(value="hwloc_const_bitmap_t") long bitmap2) {
        long __functionAddress = Functions.bitmap_compare;
        if (Checks.CHECKS) {
            Checks.check((long)bitmap1);
            Checks.check((long)bitmap2);
        }
        return JNI.invokePPI((long)bitmap1, (long)bitmap2, (long)__functionAddress);
    }

    @NativeType(value="unsigned")
    public static int hwloc_get_api_version() {
        long __functionAddress = Functions.get_api_version;
        return JNI.invokeI((long)__functionAddress);
    }

    public static int hwloc_compare_types(@NativeType(value="hwloc_obj_type_t") int type1, @NativeType(value="hwloc_obj_type_t") int type2) {
        long __functionAddress = Functions.compare_types;
        return JNI.invokeI((int)type1, (int)type2, (long)__functionAddress);
    }

    public static int nhwloc_topology_init(long topologyp) {
        long __functionAddress = Functions.topology_init;
        return JNI.invokePI((long)topologyp, (long)__functionAddress);
    }

    public static int hwloc_topology_init(@NativeType(value="hwloc_topology_t *") PointerBuffer topologyp) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)topologyp, (int)1);
        }
        return HWLoc.nhwloc_topology_init(MemoryUtil.memAddress((CustomBuffer)topologyp));
    }

    public static int hwloc_topology_load(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_load;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (long)__functionAddress);
    }

    public static void hwloc_topology_destroy(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        JNI.invokePV((long)topology, (long)__functionAddress);
    }

    public static int nhwloc_topology_dup(long newtopology, long oldtopology) {
        long __functionAddress = Functions.topology_dup;
        if (Checks.CHECKS) {
            Checks.check((long)oldtopology);
        }
        return JNI.invokePPI((long)newtopology, (long)oldtopology, (long)__functionAddress);
    }

    public static int hwloc_topology_dup(@NativeType(value="hwloc_topology_t *") PointerBuffer newtopology, @NativeType(value="hwloc_topology_t") long oldtopology) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)newtopology, (int)1);
        }
        return HWLoc.nhwloc_topology_dup(MemoryUtil.memAddress((CustomBuffer)newtopology), oldtopology);
    }

    public static int hwloc_topology_abi_check(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_abi_check;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (long)__functionAddress);
    }

    public static void hwloc_topology_check(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_check;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        JNI.invokePV((long)topology, (long)__functionAddress);
    }

    public static int hwloc_topology_get_depth(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_depth;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (long)__functionAddress);
    }

    public static int hwloc_get_type_depth(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type) {
        long __functionAddress = Functions.get_type_depth;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)type, (long)__functionAddress);
    }

    public static int nhwloc_get_type_depth_with_attr(long topology, int type, long attrp, long attrsize) {
        long __functionAddress = Functions.get_type_depth_with_attr;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPI((long)topology, (int)type, (long)attrp, (long)attrsize, (long)__functionAddress);
    }

    public static int hwloc_get_type_depth_with_attr(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type, @Nullable @NativeType(value="struct hwloc_obj_attr_u *") hwloc_obj_attr_u.Buffer attrp) {
        return HWLoc.nhwloc_get_type_depth_with_attr(topology, type, MemoryUtil.memAddressSafe((Pointer)attrp), Checks.remainingSafe((CustomBuffer)attrp));
    }

    public static int hwloc_get_memory_parents_depth(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.get_memory_parents_depth;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (long)__functionAddress);
    }

    @NativeType(value="hwloc_obj_type_t")
    public static int hwloc_get_depth_type(@NativeType(value="hwloc_topology_t") long topology, int depth) {
        long __functionAddress = Functions.get_depth_type;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)depth, (long)__functionAddress);
    }

    @NativeType(value="unsigned")
    public static int hwloc_get_nbobjs_by_depth(@NativeType(value="hwloc_topology_t") long topology, int depth) {
        long __functionAddress = Functions.get_nbobjs_by_depth;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)depth, (long)__functionAddress);
    }

    public static long nhwloc_get_obj_by_depth(long topology, int depth, int idx) {
        long __functionAddress = Functions.get_obj_by_depth;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (int)depth, (int)idx, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_by_depth(@NativeType(value="hwloc_topology_t") long topology, int depth, @NativeType(value="unsigned") int idx) {
        long __result = HWLoc.nhwloc_get_obj_by_depth(topology, depth, idx);
        return hwloc_obj.createSafe(__result);
    }

    public static long nhwloc_obj_type_string(int type) {
        long __functionAddress = Functions.obj_type_string;
        return JNI.invokeP((int)type, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String hwloc_obj_type_string(@NativeType(value="hwloc_obj_type_t") int type) {
        long __result = HWLoc.nhwloc_obj_type_string(type);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static int nhwloc_obj_type_snprintf(long string, long size, long obj, long flags) {
        long __functionAddress = Functions.obj_type_snprintf;
        return JNI.invokePPPNI((long)string, (long)size, (long)obj, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_obj_type_snprintf(@Nullable @NativeType(value="char *") ByteBuffer string, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="unsigned long") long flags) {
        return HWLoc.nhwloc_obj_type_snprintf(MemoryUtil.memAddressSafe((ByteBuffer)string), Checks.remainingSafe((Buffer)string), obj.address(), flags);
    }

    public static int nhwloc_obj_attr_snprintf(long string, long size, long obj, long separator, long flags) {
        long __functionAddress = Functions.obj_attr_snprintf;
        return JNI.invokePPPPNI((long)string, (long)size, (long)obj, (long)separator, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_obj_attr_snprintf(@NativeType(value="char *") ByteBuffer string, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="char const *") ByteBuffer separator, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)separator);
        }
        return HWLoc.nhwloc_obj_attr_snprintf(MemoryUtil.memAddress((ByteBuffer)string), string.remaining(), obj.address(), MemoryUtil.memAddress((ByteBuffer)separator), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_obj_attr_snprintf(@NativeType(value="char *") ByteBuffer string, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="char const *") CharSequence separator, @NativeType(value="unsigned long") long flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(separator, true);
            long separatorEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_obj_attr_snprintf(MemoryUtil.memAddress((ByteBuffer)string), string.remaining(), obj.address(), separatorEncoded, flags);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_type_sscanf(long string, long typep, long attrp, long attrsize) {
        long __functionAddress = Functions.type_sscanf;
        return JNI.invokePPPPI((long)string, (long)typep, (long)attrp, (long)attrsize, (long)__functionAddress);
    }

    public static int hwloc_type_sscanf(@NativeType(value="char const *") ByteBuffer string, @NativeType(value="hwloc_obj_type_t *") IntBuffer typep, @Nullable @NativeType(value="struct hwloc_obj_attr_u *") hwloc_obj_attr_u.Buffer attrp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)string);
            Checks.check((Buffer)typep, (int)1);
        }
        return HWLoc.nhwloc_type_sscanf(MemoryUtil.memAddress((ByteBuffer)string), MemoryUtil.memAddress((IntBuffer)typep), MemoryUtil.memAddressSafe((Pointer)attrp), Checks.remainingSafe((CustomBuffer)attrp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_type_sscanf(@NativeType(value="char const *") CharSequence string, @NativeType(value="hwloc_obj_type_t *") IntBuffer typep, @Nullable @NativeType(value="struct hwloc_obj_attr_u *") hwloc_obj_attr_u.Buffer attrp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)typep, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(string, true);
            long stringEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_type_sscanf(stringEncoded, MemoryUtil.memAddress((IntBuffer)typep), MemoryUtil.memAddressSafe((Pointer)attrp), Checks.remainingSafe((CustomBuffer)attrp));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_modify_infos(long infos, long operation, long name, long value) {
        long __functionAddress = Functions.modify_infos;
        return JNI.invokePNPPI((long)infos, (long)operation, (long)name, (long)value, (long)__functionAddress);
    }

    public static int hwloc_modify_infos(@NativeType(value="struct hwloc_infos_s *") hwloc_infos_s infos, @NativeType(value="unsigned long") long operation, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="char const *") ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.checkNT1((ByteBuffer)value);
        }
        return HWLoc.nhwloc_modify_infos(infos.address(), operation, MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddress((ByteBuffer)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_modify_infos(@NativeType(value="struct hwloc_infos_s *") hwloc_infos_s infos, @NativeType(value="unsigned long") long operation, @NativeType(value="char const *") CharSequence name, @NativeType(value="char const *") CharSequence value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            stack.nASCII(value, true);
            long valueEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_modify_infos(infos.address(), operation, nameEncoded, valueEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhwloc_topology_get_infos(long topology) {
        long __functionAddress = Functions.topology_get_infos;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    @NativeType(value="struct hwloc_infos_s *")
    public static hwloc_infos_s hwloc_topology_get_infos(@NativeType(value="hwloc_topology_t") long topology) {
        long __result = HWLoc.nhwloc_topology_get_infos(topology);
        return hwloc_infos_s.create(__result);
    }

    public static int nhwloc_obj_set_subtype(long topology, long obj, long subtype) {
        long __functionAddress = Functions.obj_set_subtype;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPI((long)topology, (long)obj, (long)subtype, (long)__functionAddress);
    }

    public static int hwloc_obj_set_subtype(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @Nullable @NativeType(value="char const *") ByteBuffer subtype) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)subtype);
        }
        return HWLoc.nhwloc_obj_set_subtype(topology, obj.address(), MemoryUtil.memAddressSafe((ByteBuffer)subtype));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_obj_set_subtype(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @Nullable @NativeType(value="char const *") CharSequence subtype) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCIISafe(subtype, true);
            long subtypeEncoded = subtype == null ? 0L : stack.getPointerAddress();
            int n = HWLoc.nhwloc_obj_set_subtype(topology, obj.address(), subtypeEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int hwloc_set_cpubind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.set_cpubind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_cpubind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.get_cpubind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_set_proc_cpubind_pid(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int pid, @NativeType(value="hwloc_const_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.set_proc_cpubind_pid;
        if (Platform.get() == Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (int)pid, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_set_proc_cpubind_handle(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="HANDLE") long pid, @NativeType(value="hwloc_const_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.set_proc_cpubind_handle;
        if (Platform.get() != Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)pid);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (long)pid, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_proc_cpubind_pid(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int pid, @NativeType(value="hwloc_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.get_proc_cpubind_pid;
        if (Platform.get() == Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (int)pid, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_proc_cpubind_handle(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="HANDLE") long pid, @NativeType(value="hwloc_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.get_proc_cpubind_handle;
        if (Platform.get() != Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)pid);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (long)pid, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_set_thread_cpubind_pthread(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pthread_t") long thread, @NativeType(value="hwloc_const_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.set_thread_cpubind_pthread;
        if (Platform.get() == Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePNPI((long)topology, (long)thread, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_set_thread_cpubind_handle(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="HANDLE") long thread, @NativeType(value="hwloc_const_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.set_thread_cpubind_handle;
        if (Platform.get() != Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)thread);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (long)thread, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_thread_cpubind_pthread(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pthread_t") long thread, @NativeType(value="hwloc_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.get_thread_cpubind_pthread;
        if (Platform.get() == Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePNPI((long)topology, (long)thread, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_thread_cpubind_handle(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="HANDLE") long thread, @NativeType(value="hwloc_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.get_thread_cpubind_handle;
        if (Platform.get() != Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)thread);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (long)thread, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_last_cpu_location(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.get_last_cpu_location;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_proc_last_cpu_location_pid(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int pid, @NativeType(value="hwloc_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.get_proc_last_cpu_location_pid;
        if (Platform.get() == Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (int)pid, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_proc_last_cpu_location_handle(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="HANDLE") long pid, @NativeType(value="hwloc_cpuset_t") long set, int flags) {
        long __functionAddress = Functions.get_proc_last_cpu_location_handle;
        if (Platform.get() != Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)pid);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (long)pid, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_set_membind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t") int policy, int flags) {
        long __functionAddress = Functions.set_membind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (long)set, (int)policy, (int)flags, (long)__functionAddress);
    }

    public static int nhwloc_get_membind(long topology, long set, long policy, int flags) {
        long __functionAddress = Functions.get_membind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (long)set, (long)policy, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_membind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t *") IntBuffer policy, int flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)policy, (int)1);
        }
        return HWLoc.nhwloc_get_membind(topology, set, MemoryUtil.memAddress((IntBuffer)policy), flags);
    }

    public static int hwloc_set_proc_membind_pid(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int pid, @NativeType(value="hwloc_const_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t") int policy, int flags) {
        long __functionAddress = Functions.set_proc_membind_pid;
        if (Platform.get() == Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (int)pid, (long)set, (int)policy, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_set_proc_membind_handle(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="HANDLE") long pid, @NativeType(value="hwloc_const_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t") int policy, int flags) {
        long __functionAddress = Functions.set_proc_membind_handle;
        if (Platform.get() != Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)pid);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (long)pid, (long)set, (int)policy, (int)flags, (long)__functionAddress);
    }

    public static int nhwloc_get_proc_membind_pid(long topology, int pid, long set, long policy, int flags) {
        long __functionAddress = Functions.get_proc_membind_pid;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (int)pid, (long)set, (long)policy, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_proc_membind_pid(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int pid, @NativeType(value="hwloc_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t *") IntBuffer policy, int flags) {
        if (Platform.get() == Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((Buffer)policy, (int)1);
        }
        return HWLoc.nhwloc_get_proc_membind_pid(topology, pid, set, MemoryUtil.memAddress((IntBuffer)policy), flags);
    }

    public static int nhwloc_get_proc_membind_handle(long topology, long pid, long set, long policy, int flags) {
        long __functionAddress = Functions.get_proc_membind_handle;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)pid);
            Checks.check((long)set);
        }
        return JNI.invokePPPPI((long)topology, (long)pid, (long)set, (long)policy, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_proc_membind_handle(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="HANDLE") long pid, @NativeType(value="hwloc_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t *") IntBuffer policy, int flags) {
        if (Platform.get() != Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((Buffer)policy, (int)1);
        }
        return HWLoc.nhwloc_get_proc_membind_handle(topology, pid, set, MemoryUtil.memAddress((IntBuffer)policy), flags);
    }

    public static int nhwloc_set_area_membind(long topology, long addr, long len, long set, int policy, int flags) {
        long __functionAddress = Functions.set_area_membind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPPPI((long)topology, (long)addr, (long)len, (long)set, (int)policy, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_set_area_membind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="void const *") ByteBuffer addr, @NativeType(value="hwloc_const_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t") int policy, int flags) {
        return HWLoc.nhwloc_set_area_membind(topology, MemoryUtil.memAddress((ByteBuffer)addr), addr.remaining(), set, policy, flags);
    }

    public static int nhwloc_get_area_membind(long topology, long addr, long len, long set, long policy, int flags) {
        long __functionAddress = Functions.get_area_membind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPPPPI((long)topology, (long)addr, (long)len, (long)set, (long)policy, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_area_membind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="void const *") ByteBuffer addr, @NativeType(value="hwloc_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t *") IntBuffer policy, int flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)policy, (int)1);
        }
        return HWLoc.nhwloc_get_area_membind(topology, MemoryUtil.memAddress((ByteBuffer)addr), addr.remaining(), set, MemoryUtil.memAddress((IntBuffer)policy), flags);
    }

    public static int nhwloc_get_area_memlocation(long topology, long addr, long len, long set, int flags) {
        long __functionAddress = Functions.get_area_memlocation;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPPPI((long)topology, (long)addr, (long)len, (long)set, (int)flags, (long)__functionAddress);
    }

    public static int hwloc_get_area_memlocation(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="void const *") ByteBuffer addr, @NativeType(value="hwloc_bitmap_t") long set, int flags) {
        return HWLoc.nhwloc_get_area_memlocation(topology, MemoryUtil.memAddress((ByteBuffer)addr), addr.remaining(), set, flags);
    }

    public static long nhwloc_alloc(long topology, long len) {
        long __functionAddress = Functions.alloc;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPP((long)topology, (long)len, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer hwloc_alloc(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="size_t") long len) {
        long __result = HWLoc.nhwloc_alloc(topology, len);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)len));
    }

    public static long nhwloc_alloc_membind(long topology, long len, long set, int policy, int flags) {
        long __functionAddress = Functions.alloc_membind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPPP((long)topology, (long)len, (long)set, (int)policy, (int)flags, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer hwloc_alloc_membind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="size_t") long len, @NativeType(value="hwloc_const_bitmap_t") long set, @NativeType(value="hwloc_membind_policy_t") int policy, int flags) {
        long __result = HWLoc.nhwloc_alloc_membind(topology, len, set, policy, flags);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)len));
    }

    public static int nhwloc_free(long topology, long addr, long len) {
        long __functionAddress = Functions.free;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPI((long)topology, (long)addr, (long)len, (long)__functionAddress);
    }

    public static int hwloc_free(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="void *") ByteBuffer addr) {
        return HWLoc.nhwloc_free(topology, MemoryUtil.memAddress((ByteBuffer)addr), addr.remaining());
    }

    public static int hwloc_topology_set_pid_pid(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int pid) {
        long __functionAddress = Functions.topology_set_pid_pid;
        if (Platform.get() == Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)pid, (long)__functionAddress);
    }

    public static int hwloc_topology_set_pid_handle(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="HANDLE") long pid) {
        long __functionAddress = Functions.topology_set_pid_handle;
        if (Platform.get() != Platform.WINDOWS) {
            throw new UnsupportedOperationException();
        }
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)pid);
        }
        return JNI.invokePPI((long)topology, (long)pid, (long)__functionAddress);
    }

    public static int nhwloc_topology_set_synthetic(long topology, long description) {
        long __functionAddress = Functions.topology_set_synthetic;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPI((long)topology, (long)description, (long)__functionAddress);
    }

    public static int hwloc_topology_set_synthetic(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") ByteBuffer description) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)description);
        }
        return HWLoc.nhwloc_topology_set_synthetic(topology, MemoryUtil.memAddress((ByteBuffer)description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_topology_set_synthetic(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") CharSequence description) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(description, true);
            long descriptionEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_topology_set_synthetic(topology, descriptionEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_topology_set_xml(long topology, long xmlpath) {
        long __functionAddress = Functions.topology_set_xml;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPI((long)topology, (long)xmlpath, (long)__functionAddress);
    }

    public static int hwloc_topology_set_xml(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") ByteBuffer xmlpath) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)xmlpath);
        }
        return HWLoc.nhwloc_topology_set_xml(topology, MemoryUtil.memAddress((ByteBuffer)xmlpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_topology_set_xml(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") CharSequence xmlpath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(xmlpath, true);
            long xmlpathEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_topology_set_xml(topology, xmlpathEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_topology_set_xmlbuffer(long topology, long buffer, int size) {
        long __functionAddress = Functions.topology_set_xmlbuffer;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPI((long)topology, (long)buffer, (int)size, (long)__functionAddress);
    }

    public static int hwloc_topology_set_xmlbuffer(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") ByteBuffer buffer) {
        return HWLoc.nhwloc_topology_set_xmlbuffer(topology, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_topology_set_xmlbuffer(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") CharSequence buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int bufferEncodedLength = stack.nASCII(buffer, false);
            long bufferEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_topology_set_xmlbuffer(topology, bufferEncoded, bufferEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_topology_set_components(long topology, long flags, long name) {
        long __functionAddress = Functions.topology_set_components;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePNPI((long)topology, (long)flags, (long)name, (long)__functionAddress);
    }

    public static int hwloc_topology_set_components(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned long") long flags, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return HWLoc.nhwloc_topology_set_components(topology, flags, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_topology_set_components(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned long") long flags, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_topology_set_components(topology, flags, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int hwloc_topology_set_flags(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned long") long flags) {
        long __functionAddress = Functions.topology_set_flags;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePNI((long)topology, (long)flags, (long)__functionAddress);
    }

    @NativeType(value="unsigned long")
    public static long hwloc_topology_get_flags(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_flags;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePN((long)topology, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean hwloc_topology_is_thissystem(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_is_thissystem;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (long)__functionAddress) != 0;
    }

    public static long nhwloc_topology_get_support(long topology) {
        long __functionAddress = Functions.topology_get_support;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="struct hwloc_topology_support const *")
    public static hwloc_topology_support hwloc_topology_get_support(@NativeType(value="hwloc_topology_t") long topology) {
        long __result = HWLoc.nhwloc_topology_get_support(topology);
        return hwloc_topology_support.createSafe(__result);
    }

    public static int hwloc_topology_set_type_filter(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type, @NativeType(value="enum hwloc_type_filter_e") int filter) {
        long __functionAddress = Functions.topology_set_type_filter;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)type, (int)filter, (long)__functionAddress);
    }

    public static int nhwloc_topology_get_type_filter(long topology, int type, long filter) {
        long __functionAddress = Functions.topology_get_type_filter;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPI((long)topology, (int)type, (long)filter, (long)__functionAddress);
    }

    public static int hwloc_topology_get_type_filter(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type, @NativeType(value="enum hwloc_type_filter_e *") IntBuffer filter) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)filter, (int)1);
        }
        return HWLoc.nhwloc_topology_get_type_filter(topology, type, MemoryUtil.memAddress((IntBuffer)filter));
    }

    public static int hwloc_topology_set_all_types_filter(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="enum hwloc_type_filter_e") int filter) {
        long __functionAddress = Functions.topology_set_all_types_filter;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)filter, (long)__functionAddress);
    }

    public static int hwloc_topology_set_cache_types_filter(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="enum hwloc_type_filter_e") int filter) {
        long __functionAddress = Functions.topology_set_cache_types_filter;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)filter, (long)__functionAddress);
    }

    public static int hwloc_topology_set_icache_types_filter(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="enum hwloc_type_filter_e") int filter) {
        long __functionAddress = Functions.topology_set_icache_types_filter;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)filter, (long)__functionAddress);
    }

    public static int hwloc_topology_set_io_types_filter(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="enum hwloc_type_filter_e") int filter) {
        long __functionAddress = Functions.topology_set_io_types_filter;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)filter, (long)__functionAddress);
    }

    public static void hwloc_topology_set_userdata(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="void const *") long userdata) {
        long __functionAddress = Functions.topology_set_userdata;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        JNI.invokePPV((long)topology, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long hwloc_topology_get_userdata(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_userdata;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    public static int hwloc_topology_restrict(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_bitmap_t") long set, @NativeType(value="unsigned long") long flags) {
        long __functionAddress = Functions.topology_restrict;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPNI((long)topology, (long)set, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_topology_allow(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long cpuset, @NativeType(value="hwloc_const_nodeset_t") long nodeset, @NativeType(value="unsigned long") long flags) {
        long __functionAddress = Functions.topology_allow;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)cpuset);
            Checks.check((long)nodeset);
        }
        return JNI.invokePPPNI((long)topology, (long)cpuset, (long)nodeset, (long)flags, (long)__functionAddress);
    }

    public static long nhwloc_topology_insert_misc_object(long topology, long parent, long name) {
        long __functionAddress = Functions.topology_insert_misc_object;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPP((long)topology, (long)parent, (long)name, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_topology_insert_misc_object(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj parent, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        long __result = HWLoc.nhwloc_topology_insert_misc_object(topology, parent.address(), MemoryUtil.memAddress((ByteBuffer)name));
        return hwloc_obj.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_topology_insert_misc_object(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj parent, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            long __result = HWLoc.nhwloc_topology_insert_misc_object(topology, parent.address(), nameEncoded);
            hwloc_obj hwloc_obj2 = hwloc_obj.createSafe(__result);
            return hwloc_obj2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhwloc_topology_alloc_group_object(long topology) {
        long __functionAddress = Functions.topology_alloc_group_object;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_topology_alloc_group_object(@NativeType(value="hwloc_topology_t") long topology) {
        long __result = HWLoc.nhwloc_topology_alloc_group_object(topology);
        return hwloc_obj.createSafe(__result);
    }

    public static int nhwloc_topology_free_group_object(long topology, long group) {
        long __functionAddress = Functions.topology_free_group_object;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPI((long)topology, (long)group, (long)__functionAddress);
    }

    public static int hwloc_topology_free_group_object(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj group) {
        return HWLoc.nhwloc_topology_free_group_object(topology, group.address());
    }

    public static long nhwloc_topology_insert_group_object(long topology, long group) {
        long __functionAddress = Functions.topology_insert_group_object;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPP((long)topology, (long)group, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_topology_insert_group_object(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj group) {
        long __result = HWLoc.nhwloc_topology_insert_group_object(topology, group.address());
        return hwloc_obj.createSafe(__result);
    }

    public static int nhwloc_obj_add_other_obj_sets(long dst, long src) {
        long __functionAddress = Functions.obj_add_other_obj_sets;
        return JNI.invokePPI((long)dst, (long)src, (long)__functionAddress);
    }

    public static int hwloc_obj_add_other_obj_sets(@NativeType(value="hwloc_obj_t") hwloc_obj dst, @NativeType(value="hwloc_obj_t") hwloc_obj src) {
        return HWLoc.nhwloc_obj_add_other_obj_sets(dst.address(), src.address());
    }

    public static int hwloc_topology_refresh(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_refresh;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean hwloc_obj_type_is_normal(@NativeType(value="hwloc_obj_type_t") int type) {
        long __functionAddress = Functions.obj_type_is_normal;
        return JNI.invokeI((int)type, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_obj_type_is_io(@NativeType(value="hwloc_obj_type_t") int type) {
        long __functionAddress = Functions.obj_type_is_io;
        return JNI.invokeI((int)type, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_obj_type_is_memory(@NativeType(value="hwloc_obj_type_t") int type) {
        long __functionAddress = Functions.obj_type_is_memory;
        return JNI.invokeI((int)type, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_obj_type_is_cache(@NativeType(value="hwloc_obj_type_t") int type) {
        long __functionAddress = Functions.obj_type_is_cache;
        return JNI.invokeI((int)type, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_obj_type_is_dcache(@NativeType(value="hwloc_obj_type_t") int type) {
        long __functionAddress = Functions.obj_type_is_dcache;
        return JNI.invokeI((int)type, (long)__functionAddress) != 0;
    }

    @NativeType(value="int")
    public static boolean hwloc_obj_type_is_icache(@NativeType(value="hwloc_obj_type_t") int type) {
        long __functionAddress = Functions.obj_type_is_icache;
        return JNI.invokeI((int)type, (long)__functionAddress) != 0;
    }

    public static int nhwloc_get_largest_objs_inside_cpuset(long topology, long set, long objs, int max) {
        long __functionAddress = Functions.get_largest_objs_inside_cpuset;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPPI((long)topology, (long)set, (long)objs, (int)max, (long)__functionAddress);
    }

    public static int hwloc_get_largest_objs_inside_cpuset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, @NativeType(value="hwloc_obj_t *") PointerBuffer objs) {
        return HWLoc.nhwloc_get_largest_objs_inside_cpuset(topology, set, MemoryUtil.memAddress((CustomBuffer)objs), objs.remaining());
    }

    public static int hwloc_bitmap_singlify_per_core(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_bitmap_t") long cpuset, @NativeType(value="unsigned") int which) {
        long __functionAddress = Functions.bitmap_singlify_per_core;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)cpuset);
        }
        return JNI.invokePPI((long)topology, (long)cpuset, (int)which, (long)__functionAddress);
    }

    public static int nhwloc_get_closest_objs(long topology, long src, long objs, int max) {
        long __functionAddress = Functions.get_closest_objs;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPI((long)topology, (long)src, (long)objs, (int)max, (long)__functionAddress);
    }

    @NativeType(value="unsigned")
    public static int hwloc_get_closest_objs(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj src, @NativeType(value="hwloc_obj_t *") PointerBuffer objs) {
        return HWLoc.nhwloc_get_closest_objs(topology, src.address(), MemoryUtil.memAddress((CustomBuffer)objs), objs.remaining());
    }

    public static long nhwloc_get_obj_with_same_locality(long topology, long src, int type, long subtype, long nameprefix, long flags) {
        long __functionAddress = Functions.get_obj_with_same_locality;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPPNP((long)topology, (long)src, (int)type, (long)subtype, (long)nameprefix, (long)flags, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_with_same_locality(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj src, @NativeType(value="hwloc_obj_type_t") int type, @Nullable @NativeType(value="char const *") ByteBuffer subtype, @Nullable @NativeType(value="char const *") ByteBuffer nameprefix, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)subtype);
            Checks.checkNT1Safe((ByteBuffer)nameprefix);
        }
        long __result = HWLoc.nhwloc_get_obj_with_same_locality(topology, src.address(), type, MemoryUtil.memAddressSafe((ByteBuffer)subtype), MemoryUtil.memAddressSafe((ByteBuffer)nameprefix), flags);
        return hwloc_obj.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_with_same_locality(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj src, @NativeType(value="hwloc_obj_type_t") int type, @Nullable @NativeType(value="char const *") CharSequence subtype, @Nullable @NativeType(value="char const *") CharSequence nameprefix, @NativeType(value="unsigned long") long flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCIISafe(subtype, true);
            long subtypeEncoded = subtype == null ? 0L : stack.getPointerAddress();
            stack.nASCIISafe(nameprefix, true);
            long nameprefixEncoded = nameprefix == null ? 0L : stack.getPointerAddress();
            long __result = HWLoc.nhwloc_get_obj_with_same_locality(topology, src.address(), type, subtypeEncoded, nameprefixEncoded, flags);
            hwloc_obj hwloc_obj2 = hwloc_obj.createSafe(__result);
            return hwloc_obj2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="hwloc_const_cpuset_t")
    public static long hwloc_topology_get_complete_cpuset(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_complete_cpuset;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    @NativeType(value="hwloc_const_cpuset_t")
    public static long hwloc_topology_get_topology_cpuset(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_topology_cpuset;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    @NativeType(value="hwloc_const_cpuset_t")
    public static long hwloc_topology_get_allowed_cpuset(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_allowed_cpuset;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    @NativeType(value="hwloc_const_nodeset_t")
    public static long hwloc_topology_get_complete_nodeset(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_complete_nodeset;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    @NativeType(value="hwloc_const_nodeset_t")
    public static long hwloc_topology_get_topology_nodeset(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_topology_nodeset;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    @NativeType(value="hwloc_const_nodeset_t")
    public static long hwloc_topology_get_allowed_nodeset(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.topology_get_allowed_nodeset;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePP((long)topology, (long)__functionAddress);
    }

    public static int nhwloc_memattr_get_by_name(long topology, long name, long id) {
        long __functionAddress = Functions.memattr_get_by_name;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPI((long)topology, (long)name, (long)id, (long)__functionAddress);
    }

    public static int hwloc_memattr_get_by_name(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="hwloc_memattr_id_t *") IntBuffer id) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.check((Buffer)id, (int)1);
        }
        return HWLoc.nhwloc_memattr_get_by_name(topology, MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddress((IntBuffer)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_memattr_get_by_name(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") CharSequence name, @NativeType(value="hwloc_memattr_id_t *") IntBuffer id) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)id, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_memattr_get_by_name(topology, nameEncoded, MemoryUtil.memAddress((IntBuffer)id));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_get_local_numanode_objs(long topology, long location, long nr, long nodes, long flags) {
        long __functionAddress = Functions.get_local_numanode_objs;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPPNI((long)topology, (long)location, (long)nr, (long)nodes, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_get_local_numanode_objs(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="struct hwloc_location *") hwloc_location location, @NativeType(value="unsigned int *") IntBuffer nr, @NativeType(value="hwloc_obj_t *") PointerBuffer nodes, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)nr, (int)1);
            Checks.check((CustomBuffer)nodes, (int)nr.get(nr.position()));
        }
        return HWLoc.nhwloc_get_local_numanode_objs(topology, location.address(), MemoryUtil.memAddress((IntBuffer)nr), MemoryUtil.memAddress((CustomBuffer)nodes), flags);
    }

    public static int nhwloc_memattr_get_value(long topology, int attribute, long target_node, long initiator, long flags, long value) {
        long __functionAddress = Functions.memattr_get_value;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPNPI((long)topology, (int)attribute, (long)target_node, (long)initiator, (long)flags, (long)value, (long)__functionAddress);
    }

    public static int hwloc_memattr_get_value(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_memattr_id_t") int attribute, @NativeType(value="hwloc_obj_t") hwloc_obj target_node, @Nullable @NativeType(value="struct hwloc_location *") hwloc_location initiator, @NativeType(value="unsigned long") long flags, @NativeType(value="hwloc_uint64_t *") LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        return HWLoc.nhwloc_memattr_get_value(topology, attribute, target_node.address(), MemoryUtil.memAddressSafe((Pointer)initiator), flags, MemoryUtil.memAddress((LongBuffer)value));
    }

    public static int nhwloc_memattr_get_best_target(long topology, int attribute, long initiator, long flags, long best_target, long value) {
        long __functionAddress = Functions.memattr_get_best_target;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPNPPI((long)topology, (int)attribute, (long)initiator, (long)flags, (long)best_target, (long)value, (long)__functionAddress);
    }

    public static int hwloc_memattr_get_best_target(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_memattr_id_t") int attribute, @Nullable @NativeType(value="struct hwloc_location *") hwloc_location initiator, @NativeType(value="unsigned long") long flags, @NativeType(value="hwloc_obj_t *") PointerBuffer best_target, @Nullable @NativeType(value="hwloc_uint64_t *") LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)best_target, (int)1);
            Checks.checkSafe((Buffer)value, (int)1);
        }
        return HWLoc.nhwloc_memattr_get_best_target(topology, attribute, MemoryUtil.memAddressSafe((Pointer)initiator), flags, MemoryUtil.memAddress((CustomBuffer)best_target), MemoryUtil.memAddressSafe((LongBuffer)value));
    }

    public static int nhwloc_memattr_get_best_initiator(long topology, int attribute, long target, long flags, long best_initiator, long value) {
        long __functionAddress = Functions.memattr_get_best_initiator;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPNPPI((long)topology, (int)attribute, (long)target, (long)flags, (long)best_initiator, (long)value, (long)__functionAddress);
    }

    public static int hwloc_memattr_get_best_initiator(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_memattr_id_t") int attribute, @NativeType(value="hwloc_obj_t") hwloc_obj target, @NativeType(value="unsigned long") long flags, @NativeType(value="struct hwloc_location *") hwloc_location.Buffer best_initiator, @Nullable @NativeType(value="hwloc_uint64_t *") LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)best_initiator, (int)1);
            Checks.checkSafe((Buffer)value, (int)1);
        }
        return HWLoc.nhwloc_memattr_get_best_initiator(topology, attribute, target.address(), flags, best_initiator.address(), MemoryUtil.memAddressSafe((LongBuffer)value));
    }

    public static int nhwloc_memattr_get_name(long topology, int attribute, long name) {
        long __functionAddress = Functions.memattr_get_name;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPI((long)topology, (int)attribute, (long)name, (long)__functionAddress);
    }

    public static int hwloc_memattr_get_name(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_memattr_id_t") int attribute, @NativeType(value="char const **") PointerBuffer name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)name, (int)1);
        }
        return HWLoc.nhwloc_memattr_get_name(topology, attribute, MemoryUtil.memAddress((CustomBuffer)name));
    }

    public static int nhwloc_memattr_get_flags(long topology, int attribute, long flags) {
        long __functionAddress = Functions.memattr_get_flags;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPI((long)topology, (int)attribute, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_memattr_get_flags(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_memattr_id_t") int attribute, @NativeType(value="unsigned long *") CLongBuffer flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)flags, (int)1);
        }
        return HWLoc.nhwloc_memattr_get_flags(topology, attribute, MemoryUtil.memAddress((CustomBuffer)flags));
    }

    public static int nhwloc_memattr_register(long topology, long name, long flags, long id) {
        long __functionAddress = Functions.memattr_register;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPNPI((long)topology, (long)name, (long)flags, (long)id, (long)__functionAddress);
    }

    public static int hwloc_memattr_register(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="unsigned long") long flags, @NativeType(value="hwloc_memattr_id_t *") IntBuffer id) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.check((Buffer)id, (int)1);
        }
        return HWLoc.nhwloc_memattr_register(topology, MemoryUtil.memAddress((ByteBuffer)name), flags, MemoryUtil.memAddress((IntBuffer)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_memattr_register(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") CharSequence name, @NativeType(value="unsigned long") long flags, @NativeType(value="hwloc_memattr_id_t *") IntBuffer id) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)id, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_memattr_register(topology, nameEncoded, flags, MemoryUtil.memAddress((IntBuffer)id));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_memattr_set_value(long topology, int attribute, long target_node, long initiator, long flags, long value) {
        long __functionAddress = Functions.memattr_set_value;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPNJI((long)topology, (int)attribute, (long)target_node, (long)initiator, (long)flags, (long)value, (long)__functionAddress);
    }

    public static int hwloc_memattr_set_value(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_memattr_id_t") int attribute, @NativeType(value="hwloc_obj_t") hwloc_obj target_node, @Nullable @NativeType(value="struct hwloc_location *") hwloc_location initiator, @NativeType(value="unsigned long") long flags, @NativeType(value="hwloc_uint64_t") long value) {
        return HWLoc.nhwloc_memattr_set_value(topology, attribute, target_node.address(), MemoryUtil.memAddressSafe((Pointer)initiator), flags, value);
    }

    public static int nhwloc_memattr_get_targets(long topology, int attribute, long initiator, long flags, long nr, long targets, long values) {
        long __functionAddress = Functions.memattr_get_targets;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPNPPPI((long)topology, (int)attribute, (long)initiator, (long)flags, (long)nr, (long)targets, (long)values, (long)__functionAddress);
    }

    public static int hwloc_memattr_get_targets(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_memattr_id_t") int attribute, @Nullable @NativeType(value="struct hwloc_location *") hwloc_location initiator, @NativeType(value="unsigned long") long flags, @NativeType(value="unsigned int *") IntBuffer nr, @NativeType(value="hwloc_obj_t *") PointerBuffer targets, @Nullable @NativeType(value="hwloc_uint64_t *") LongBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)nr, (int)1);
            Checks.check((CustomBuffer)targets, (int)nr.get(nr.position()));
            Checks.checkSafe((Buffer)values, (int)nr.get(nr.position()));
        }
        return HWLoc.nhwloc_memattr_get_targets(topology, attribute, MemoryUtil.memAddressSafe((Pointer)initiator), flags, MemoryUtil.memAddress((IntBuffer)nr), MemoryUtil.memAddress((CustomBuffer)targets), MemoryUtil.memAddressSafe((LongBuffer)values));
    }

    public static int nhwloc_memattr_get_initiators(long topology, int attribute, long target_node, long flags, long nr, long initiators, long values) {
        long __functionAddress = Functions.memattr_get_initiators;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPNPPPI((long)topology, (int)attribute, (long)target_node, (long)flags, (long)nr, (long)initiators, (long)values, (long)__functionAddress);
    }

    public static int hwloc_memattr_get_initiators(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_memattr_id_t") int attribute, @NativeType(value="hwloc_obj_t") hwloc_obj target_node, @NativeType(value="unsigned long") long flags, @NativeType(value="unsigned int *") IntBuffer nr, @NativeType(value="struct hwloc_location *") hwloc_location.Buffer initiators, @Nullable @NativeType(value="hwloc_uint64_t *") LongBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)nr, (int)1);
            Checks.check((CustomBuffer)initiators, (int)nr.get(nr.position()));
            Checks.checkSafe((Buffer)values, (int)nr.get(nr.position()));
        }
        return HWLoc.nhwloc_memattr_get_initiators(topology, attribute, target_node.address(), flags, MemoryUtil.memAddress((IntBuffer)nr), initiators.address(), MemoryUtil.memAddressSafe((LongBuffer)values));
    }

    public static int hwloc_cpukinds_get_nr(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned long") long flags) {
        long __functionAddress = Functions.cpukinds_get_nr;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePNI((long)topology, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_cpukinds_get_by_cpuset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_bitmap_t") long cpuset, @NativeType(value="unsigned long") long flags) {
        long __functionAddress = Functions.cpukinds_get_by_cpuset;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)cpuset);
        }
        return JNI.invokePPNI((long)topology, (long)cpuset, (long)flags, (long)__functionAddress);
    }

    public static int nhwloc_cpukinds_get_info(long topology, int kind_index, long cpuset, long efficiency, long infosp, long flags) {
        long __functionAddress = Functions.cpukinds_get_info;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPPNI((long)topology, (int)kind_index, (long)cpuset, (long)efficiency, (long)infosp, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_cpukinds_get_info(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned int") int kind_index, @NativeType(value="hwloc_bitmap_t") long cpuset, @Nullable @NativeType(value="int *") IntBuffer efficiency, @NativeType(value="struct hwloc_infos_s **") PointerBuffer infosp, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)efficiency, (int)1);
            Checks.check((CustomBuffer)infosp, (int)1);
        }
        return HWLoc.nhwloc_cpukinds_get_info(topology, kind_index, cpuset, MemoryUtil.memAddressSafe((IntBuffer)efficiency), MemoryUtil.memAddress((CustomBuffer)infosp), flags);
    }

    public static int nhwloc_cpukinds_register(long topology, long cpuset, int forced_efficiency, long infos, long flags) {
        long __functionAddress = Functions.cpukinds_register;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)cpuset);
        }
        return JNI.invokePPPNI((long)topology, (long)cpuset, (int)forced_efficiency, (long)infos, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_cpukinds_register(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_bitmap_t") long cpuset, int forced_efficiency, @Nullable @NativeType(value="struct hwloc_infos_s *") hwloc_infos_s infos, @NativeType(value="unsigned long") long flags) {
        return HWLoc.nhwloc_cpukinds_register(topology, cpuset, forced_efficiency, MemoryUtil.memAddressSafe((Pointer)infos), flags);
    }

    public static int nhwloc_topology_export_xml(long topology, long xmlpath, long flags) {
        long __functionAddress = Functions.topology_export_xml;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPNI((long)topology, (long)xmlpath, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_topology_export_xml(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") ByteBuffer xmlpath, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)xmlpath);
        }
        return HWLoc.nhwloc_topology_export_xml(topology, MemoryUtil.memAddress((ByteBuffer)xmlpath), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_topology_export_xml(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") CharSequence xmlpath, @NativeType(value="unsigned long") long flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(xmlpath, true);
            long xmlpathEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_topology_export_xml(topology, xmlpathEncoded, flags);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_topology_export_xmlbuffer(long topology, long xmlbuffer, long buflen, long flags) {
        long __functionAddress = Functions.topology_export_xmlbuffer;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPNI((long)topology, (long)xmlbuffer, (long)buflen, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_topology_export_xmlbuffer(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char **") PointerBuffer xmlbuffer, @NativeType(value="int *") IntBuffer buflen, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)xmlbuffer, (int)1);
            Checks.check((Buffer)buflen, (int)1);
        }
        return HWLoc.nhwloc_topology_export_xmlbuffer(topology, MemoryUtil.memAddress((CustomBuffer)xmlbuffer), MemoryUtil.memAddress((IntBuffer)buflen), flags);
    }

    public static void nhwloc_free_xmlbuffer(long topology, long xmlbuffer) {
        long __functionAddress = Functions.free_xmlbuffer;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        JNI.invokePPV((long)topology, (long)xmlbuffer, (long)__functionAddress);
    }

    public static void hwloc_free_xmlbuffer(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char *") ByteBuffer xmlbuffer) {
        HWLoc.nhwloc_free_xmlbuffer(topology, MemoryUtil.memAddress((ByteBuffer)xmlbuffer));
    }

    public static void nhwloc_topology_set_userdata_export_callback(long topology, long export_cb) {
        long __functionAddress = Functions.topology_set_userdata_export_callback;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        JNI.invokePPV((long)topology, (long)export_cb, (long)__functionAddress);
    }

    public static void hwloc_topology_set_userdata_export_callback(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="void (*) (void *, hwloc_topology_t, hwloc_obj_t)") topology_set_userdata_export_callbackI export_cb) {
        HWLoc.nhwloc_topology_set_userdata_export_callback(topology, export_cb.address());
    }

    public static int nhwloc_export_obj_userdata(long reserved, long topology, long obj, long name, long buffer, long length) {
        long __functionAddress = Functions.export_obj_userdata;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPPPPI((long)reserved, (long)topology, (long)obj, (long)name, (long)buffer, (long)length, (long)__functionAddress);
    }

    public static int hwloc_export_obj_userdata(@NativeType(value="void *") long reserved, @NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="void const *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return HWLoc.nhwloc_export_obj_userdata(reserved, topology, obj.address(), MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_export_obj_userdata(@NativeType(value="void *") long reserved, @NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="char const *") CharSequence name, @NativeType(value="void const *") ByteBuffer buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_export_obj_userdata(reserved, topology, obj.address(), nameEncoded, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_export_obj_userdata_base64(long reserved, long topology, long obj, long name, long buffer, long length) {
        long __functionAddress = Functions.export_obj_userdata_base64;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPPPPI((long)reserved, (long)topology, (long)obj, (long)name, (long)buffer, (long)length, (long)__functionAddress);
    }

    public static int hwloc_export_obj_userdata_base64(@NativeType(value="void *") long reserved, @NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="void const *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return HWLoc.nhwloc_export_obj_userdata_base64(reserved, topology, obj.address(), MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_export_obj_userdata_base64(@NativeType(value="void *") long reserved, @NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="char const *") CharSequence name, @NativeType(value="void const *") ByteBuffer buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_export_obj_userdata_base64(reserved, topology, obj.address(), nameEncoded, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nhwloc_topology_set_userdata_import_callback(long topology, long import_cb) {
        long __functionAddress = Functions.topology_set_userdata_import_callback;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        JNI.invokePPV((long)topology, (long)import_cb, (long)__functionAddress);
    }

    public static void hwloc_topology_set_userdata_import_callback(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="void (*) (hwloc_topology_t, hwloc_obj_t, char const *, void const *, size_t)") topology_set_userdata_import_callbackI import_cb) {
        HWLoc.nhwloc_topology_set_userdata_import_callback(topology, import_cb.address());
    }

    public static int nhwloc_topology_export_synthetic(long topology, long buffer, long buflen, long flags) {
        long __functionAddress = Functions.topology_export_synthetic;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPNI((long)topology, (long)buffer, (long)buflen, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_topology_export_synthetic(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char *") ByteBuffer buffer, @NativeType(value="unsigned long") long flags) {
        return HWLoc.nhwloc_topology_export_synthetic(topology, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), flags);
    }

    public static int nhwloc_distances_get(long topology, long nr, long distances, long kind, long flags) {
        long __functionAddress = Functions.distances_get;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPNNI((long)topology, (long)nr, (long)distances, (long)kind, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_distances_get(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned int *") IntBuffer nr, @NativeType(value="struct hwloc_distances_s **") PointerBuffer distances, @NativeType(value="unsigned long") long kind, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)nr, (int)1);
            Checks.check((CustomBuffer)distances, (int)nr.get(nr.position()));
        }
        return HWLoc.nhwloc_distances_get(topology, MemoryUtil.memAddress((IntBuffer)nr), MemoryUtil.memAddress((CustomBuffer)distances), kind, flags);
    }

    public static int nhwloc_distances_get_by_depth(long topology, int depth, long nr, long distances, long kind, long flags) {
        long __functionAddress = Functions.distances_get_by_depth;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPNNI((long)topology, (int)depth, (long)nr, (long)distances, (long)kind, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_distances_get_by_depth(@NativeType(value="hwloc_topology_t") long topology, int depth, @NativeType(value="unsigned int *") IntBuffer nr, @NativeType(value="struct hwloc_distances_s **") PointerBuffer distances, @NativeType(value="unsigned long") long kind, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)nr, (int)1);
            Checks.check((CustomBuffer)distances, (int)nr.get(nr.position()));
        }
        return HWLoc.nhwloc_distances_get_by_depth(topology, depth, MemoryUtil.memAddress((IntBuffer)nr), MemoryUtil.memAddress((CustomBuffer)distances), kind, flags);
    }

    public static int nhwloc_distances_get_by_type(long topology, int type, long nr, long distances, long kind, long flags) {
        long __functionAddress = Functions.distances_get_by_type;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPNNI((long)topology, (int)type, (long)nr, (long)distances, (long)kind, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_distances_get_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type, @NativeType(value="unsigned int *") IntBuffer nr, @NativeType(value="struct hwloc_distances_s **") PointerBuffer distances, @NativeType(value="unsigned long") long kind, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)nr, (int)1);
            Checks.check((CustomBuffer)distances, (int)nr.get(nr.position()));
        }
        return HWLoc.nhwloc_distances_get_by_type(topology, type, MemoryUtil.memAddress((IntBuffer)nr), MemoryUtil.memAddress((CustomBuffer)distances), kind, flags);
    }

    public static int nhwloc_distances_get_by_name(long topology, long name, long nr, long distances, long flags) {
        long __functionAddress = Functions.distances_get_by_name;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPPNI((long)topology, (long)name, (long)nr, (long)distances, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_distances_get_by_name(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="unsigned int *") IntBuffer nr, @NativeType(value="struct hwloc_distances_s **") PointerBuffer distances, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.check((Buffer)nr, (int)1);
            Checks.check((CustomBuffer)distances, (int)nr.get(nr.position()));
        }
        return HWLoc.nhwloc_distances_get_by_name(topology, MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddress((IntBuffer)nr), MemoryUtil.memAddress((CustomBuffer)distances), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_distances_get_by_name(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") CharSequence name, @NativeType(value="unsigned int *") IntBuffer nr, @NativeType(value="struct hwloc_distances_s **") PointerBuffer distances, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)nr, (int)1);
            Checks.check((CustomBuffer)distances, (int)nr.get(nr.position()));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_distances_get_by_name(topology, nameEncoded, MemoryUtil.memAddress((IntBuffer)nr), MemoryUtil.memAddress((CustomBuffer)distances), flags);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nhwloc_distances_get_name(long topology, long distances) {
        long __functionAddress = Functions.distances_get_name;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPP((long)topology, (long)distances, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String hwloc_distances_get_name(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="struct hwloc_distances_s *") hwloc_distances_s distances) {
        long __result = HWLoc.nhwloc_distances_get_name(topology, distances.address());
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static void nhwloc_distances_release(long topology, long distances) {
        long __functionAddress = Functions.distances_release;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        JNI.invokePPV((long)topology, (long)distances, (long)__functionAddress);
    }

    public static void hwloc_distances_release(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="struct hwloc_distances_s *") hwloc_distances_s distances) {
        HWLoc.nhwloc_distances_release(topology, distances.address());
    }

    public static int nhwloc_distances_transform(long topology, long distances, int transform, long transform_attr, long flags) {
        long __functionAddress = Functions.distances_transform;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPPNI((long)topology, (long)distances, (int)transform, (long)transform_attr, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_distances_transform(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="struct hwloc_distances_s *") hwloc_distances_s distances, @NativeType(value="enum hwloc_distances_transform_e") int transform, @NativeType(value="void *") long transform_attr, @NativeType(value="unsigned long") long flags) {
        return HWLoc.nhwloc_distances_transform(topology, distances.address(), transform, transform_attr, flags);
    }

    public static long nhwloc_distances_add_create(long topology, long name, long kind, long flags) {
        long __functionAddress = Functions.distances_add_create;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPNNP((long)topology, (long)name, (long)kind, (long)flags, (long)__functionAddress);
    }

    @NativeType(value="hwloc_distances_add_handle_t")
    public static long hwloc_distances_add_create(@NativeType(value="hwloc_topology_t") long topology, @Nullable @NativeType(value="char const *") ByteBuffer name, @NativeType(value="unsigned long") long kind, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)name);
        }
        return HWLoc.nhwloc_distances_add_create(topology, MemoryUtil.memAddressSafe((ByteBuffer)name), kind, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="hwloc_distances_add_handle_t")
    public static long hwloc_distances_add_create(@NativeType(value="hwloc_topology_t") long topology, @Nullable @NativeType(value="char const *") CharSequence name, @NativeType(value="unsigned long") long kind, @NativeType(value="unsigned long") long flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCIISafe(name, true);
            long nameEncoded = name == null ? 0L : stack.getPointerAddress();
            long l = HWLoc.nhwloc_distances_add_create(topology, nameEncoded, kind, flags);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_distances_add_values(long topology, long handle, int nbobjs, long objs, long values, long flags) {
        long __functionAddress = Functions.distances_add_values;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)handle);
        }
        return JNI.invokePPPPNI((long)topology, (long)handle, (int)nbobjs, (long)objs, (long)values, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_distances_add_values(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_distances_add_handle_t") long handle, @NativeType(value="unsigned int") int nbobjs, @NativeType(value="hwloc_obj_t *") PointerBuffer objs, @NativeType(value="hwloc_uint64_t *") LongBuffer values, @NativeType(value="unsigned long") long flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)objs, (int)nbobjs);
            Checks.check((Buffer)values, (int)(nbobjs * nbobjs));
        }
        return HWLoc.nhwloc_distances_add_values(topology, handle, nbobjs, MemoryUtil.memAddress((CustomBuffer)objs), MemoryUtil.memAddress((LongBuffer)values), flags);
    }

    public static int hwloc_distances_add_commit(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_distances_add_handle_t") long handle, @NativeType(value="unsigned long") long flags) {
        long __functionAddress = Functions.distances_add_commit;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)handle);
        }
        return JNI.invokePPNI((long)topology, (long)handle, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_distances_remove(@NativeType(value="hwloc_topology_t") long topology) {
        long __functionAddress = Functions.distances_remove;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (long)__functionAddress);
    }

    public static int hwloc_distances_remove_by_depth(@NativeType(value="hwloc_topology_t") long topology, int depth) {
        long __functionAddress = Functions.distances_remove_by_depth;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePI((long)topology, (int)depth, (long)__functionAddress);
    }

    public static int nhwloc_distances_release_remove(long topology, long distances) {
        long __functionAddress = Functions.distances_release_remove;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
        }
        return JNI.invokePPI((long)topology, (long)distances, (long)__functionAddress);
    }

    public static int hwloc_distances_release_remove(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="struct hwloc_distances_s *") hwloc_distances_s distances) {
        return HWLoc.nhwloc_distances_release_remove(topology, distances.address());
    }

    public static int nhwloc_topology_diff_build(long topology, long newtopology, long flags, long diff) {
        long __functionAddress = Functions.topology_diff_build;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)newtopology);
        }
        return JNI.invokePPNPI((long)topology, (long)newtopology, (long)flags, (long)diff, (long)__functionAddress);
    }

    public static int hwloc_topology_diff_build(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_topology_t") long newtopology, @NativeType(value="unsigned long") long flags, @NativeType(value="hwloc_topology_diff_t *") PointerBuffer diff) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)diff, (int)1);
        }
        return HWLoc.nhwloc_topology_diff_build(topology, newtopology, flags, MemoryUtil.memAddress((CustomBuffer)diff));
    }

    public static int hwloc_topology_diff_apply(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_topology_diff_t") long diff, @NativeType(value="unsigned long") long flags) {
        long __functionAddress = Functions.topology_diff_apply;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)diff);
        }
        return JNI.invokePPNI((long)topology, (long)diff, (long)flags, (long)__functionAddress);
    }

    public static int hwloc_topology_diff_destroy(@NativeType(value="hwloc_topology_diff_t") long diff) {
        long __functionAddress = Functions.topology_diff_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)diff);
        }
        return JNI.invokePI((long)diff, (long)__functionAddress);
    }

    public static int nhwloc_topology_diff_load_xml(long xmlpath, long diff, long refname) {
        long __functionAddress = Functions.topology_diff_load_xml;
        return JNI.invokePPPI((long)xmlpath, (long)diff, (long)refname, (long)__functionAddress);
    }

    public static int hwloc_topology_diff_load_xml(@NativeType(value="char const *") ByteBuffer xmlpath, @NativeType(value="hwloc_topology_diff_t *") PointerBuffer diff, @NativeType(value="char **") PointerBuffer refname) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)xmlpath);
            Checks.check((CustomBuffer)diff, (int)1);
            Checks.check((CustomBuffer)refname, (int)1);
        }
        return HWLoc.nhwloc_topology_diff_load_xml(MemoryUtil.memAddress((ByteBuffer)xmlpath), MemoryUtil.memAddress((CustomBuffer)diff), MemoryUtil.memAddress((CustomBuffer)refname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_topology_diff_load_xml(@NativeType(value="char const *") CharSequence xmlpath, @NativeType(value="hwloc_topology_diff_t *") PointerBuffer diff, @NativeType(value="char **") PointerBuffer refname) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)diff, (int)1);
            Checks.check((CustomBuffer)refname, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(xmlpath, true);
            long xmlpathEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_topology_diff_load_xml(xmlpathEncoded, MemoryUtil.memAddress((CustomBuffer)diff), MemoryUtil.memAddress((CustomBuffer)refname));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_topology_diff_export_xml(long diff, long refname, long xmlpath) {
        long __functionAddress = Functions.topology_diff_export_xml;
        if (Checks.CHECKS) {
            Checks.check((long)diff);
        }
        return JNI.invokePPPI((long)diff, (long)refname, (long)xmlpath, (long)__functionAddress);
    }

    public static int hwloc_topology_diff_export_xml(@NativeType(value="hwloc_topology_diff_t") long diff, @NativeType(value="char const *") ByteBuffer refname, @NativeType(value="char const *") ByteBuffer xmlpath) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)refname);
            Checks.checkNT1((ByteBuffer)xmlpath);
        }
        return HWLoc.nhwloc_topology_diff_export_xml(diff, MemoryUtil.memAddress((ByteBuffer)refname), MemoryUtil.memAddress((ByteBuffer)xmlpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_topology_diff_export_xml(@NativeType(value="hwloc_topology_diff_t") long diff, @NativeType(value="char const *") CharSequence refname, @NativeType(value="char const *") CharSequence xmlpath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(refname, true);
            long refnameEncoded = stack.getPointerAddress();
            stack.nUTF8(xmlpath, true);
            long xmlpathEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_topology_diff_export_xml(diff, refnameEncoded, xmlpathEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nhwloc_topology_diff_load_xmlbuffer(long xmlbuffer, int buflen, long diff, long refname) {
        long __functionAddress = Functions.topology_diff_load_xmlbuffer;
        return JNI.invokePPPI((long)xmlbuffer, (int)buflen, (long)diff, (long)refname, (long)__functionAddress);
    }

    public static int hwloc_topology_diff_load_xmlbuffer(@NativeType(value="char const *") ByteBuffer xmlbuffer, @NativeType(value="hwloc_topology_diff_t *") PointerBuffer diff, @NativeType(value="char **") PointerBuffer refname) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)diff, (int)1);
            Checks.check((CustomBuffer)refname, (int)1);
        }
        return HWLoc.nhwloc_topology_diff_load_xmlbuffer(MemoryUtil.memAddress((ByteBuffer)xmlbuffer), xmlbuffer.remaining(), MemoryUtil.memAddress((CustomBuffer)diff), MemoryUtil.memAddress((CustomBuffer)refname));
    }

    public static int nhwloc_topology_diff_export_xmlbuffer(long diff, long refname, long xmlbuffer, long buflen) {
        long __functionAddress = Functions.topology_diff_export_xmlbuffer;
        if (Checks.CHECKS) {
            Checks.check((long)diff);
        }
        return JNI.invokePPPPI((long)diff, (long)refname, (long)xmlbuffer, (long)buflen, (long)__functionAddress);
    }

    public static int hwloc_topology_diff_export_xmlbuffer(@NativeType(value="hwloc_topology_diff_t") long diff, @NativeType(value="char const *") ByteBuffer refname, @NativeType(value="char **") PointerBuffer xmlbuffer, @NativeType(value="int *") IntBuffer buflen) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)refname);
            Checks.check((CustomBuffer)xmlbuffer, (int)1);
            Checks.check((Buffer)buflen, (int)1);
        }
        return HWLoc.nhwloc_topology_diff_export_xmlbuffer(diff, MemoryUtil.memAddress((ByteBuffer)refname), MemoryUtil.memAddress((CustomBuffer)xmlbuffer), MemoryUtil.memAddress((IntBuffer)buflen));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_topology_diff_export_xmlbuffer(@NativeType(value="hwloc_topology_diff_t") long diff, @NativeType(value="char const *") CharSequence refname, @NativeType(value="char **") PointerBuffer xmlbuffer, @NativeType(value="int *") IntBuffer buflen) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)xmlbuffer, (int)1);
            Checks.check((Buffer)buflen, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(refname, true);
            long refnameEncoded = stack.getPointerAddress();
            int n = HWLoc.nhwloc_topology_diff_export_xmlbuffer(diff, refnameEncoded, MemoryUtil.memAddress((CustomBuffer)xmlbuffer), MemoryUtil.memAddress((IntBuffer)buflen));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int hwloc_get_type_or_below_depth(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth != -1) {
            return depth;
        }
        depth = 0;
        while (HWLoc.hwloc_compare_types(HWLoc.hwloc_get_depth_type(topology, depth), type) <= 0) {
            ++depth;
        }
        return depth - 1;
    }

    public static int hwloc_get_type_or_above_depth(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth != -1) {
            return depth;
        }
        depth = 0;
        while (HWLoc.hwloc_compare_types(HWLoc.hwloc_get_depth_type(topology, depth), type) <= 0) {
            ++depth;
        }
        return depth - 1;
    }

    public static int hwloc_get_nbobjs_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth == -1) {
            return 0;
        }
        if (depth == -2) {
            return -1;
        }
        return HWLoc.hwloc_get_nbobjs_by_depth(topology, depth);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_root_obj(@NativeType(value="hwloc_topology_t") long topology) {
        return HWLoc.hwloc_get_obj_by_depth(topology, 0, 0);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type, @NativeType(value="unsigned") int idx) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth == -1) {
            return null;
        }
        if (depth == -2) {
            return null;
        }
        return HWLoc.hwloc_get_obj_by_depth(topology, depth, idx);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_obj_by_depth(@NativeType(value="hwloc_topology_t") long topology, int depth, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        if (prev == null) {
            return HWLoc.hwloc_get_obj_by_depth(topology, depth, 0);
        }
        if (prev.depth() != depth) {
            return null;
        }
        return prev.next_cousin();
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_obj_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth == -1 || depth == -2) {
            return null;
        }
        return HWLoc.hwloc_get_next_obj_by_depth(topology, depth, prev);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String hwloc_obj_get_info_by_name(@NativeType(value="hwloc_obj_t") hwloc_obj obj, String name) {
        return HWLoc.hwloc_get_info_by_name(obj.infos(), name);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String hwloc_get_info_by_name(@NativeType(value="struct hwloc_infos_s") hwloc_infos_s infos, String name) {
        if (infos.count() == 0) {
            return null;
        }
        hwloc_info_s.Buffer array = Objects.requireNonNull(infos.array());
        Iterator iterator = array.iterator();
        while (iterator.hasNext()) {
            hwloc_info_s info = (hwloc_info_s)((Object)iterator.next());
            if (!info.nameString().equals(name)) continue;
            return info.valueString();
        }
        return null;
    }

    public static int hwloc_obj_add_info(@NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="char const *") ByteBuffer value) {
        return HWLoc.hwloc_modify_infos(obj.infos(), 1L, name, value);
    }

    public static int hwloc_obj_add_info(@NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="char const *") CharSequence name, @NativeType(value="char const *") CharSequence value) {
        return HWLoc.hwloc_modify_infos(obj.infos(), 1L, name, value);
    }

    @Nullable
    public static ByteBuffer hwloc_alloc_membind_policy(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="size_t") long len, @NativeType(value="hwloc_const_cpuset_t") long set, @NativeType(value="hwloc_membind_policy_t") int policy, int flags) {
        ByteBuffer p = HWLoc.hwloc_alloc_membind(topology, len, set, policy, flags);
        if (p != null) {
            return p;
        }
        if (HWLoc.hwloc_set_membind(topology, set, policy, flags) < 0) {
            return null;
        }
        p = HWLoc.hwloc_alloc(topology, len);
        if (p != null && policy != 1) {
            MemoryUtil.memSet((ByteBuffer)p, (int)0);
        }
        return p;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_first_largest_obj_inside_cpuset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set) {
        hwloc_obj obj = Objects.requireNonNull(HWLoc.hwloc_get_root_obj(topology));
        if (!HWLoc.hwloc_bitmap_intersects(obj.cpuset(), set)) {
            return null;
        }
        while (!HWLoc.hwloc_bitmap_isincluded(obj.cpuset(), set)) {
            hwloc_obj child;
            for (child = obj.first_child(); child != null && !HWLoc.hwloc_bitmap_intersects(child.cpuset(), set); child = child.next_sibling()) {
            }
            if (child == null) {
                return obj;
            }
            obj = child;
        }
        return obj;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_obj_inside_cpuset_by_depth(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, int depth, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        hwloc_obj next;
        for (next = HWLoc.hwloc_get_next_obj_by_depth(topology, depth, prev); next != null && (HWLoc.hwloc_bitmap_iszero(next.cpuset()) || !HWLoc.hwloc_bitmap_isincluded(next.cpuset(), set)); next = next.next_cousin()) {
        }
        return next;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_obj_inside_cpuset_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, @NativeType(value="hwloc_obj_type_t") int type, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth == -1 || depth == -2) {
            return null;
        }
        return HWLoc.hwloc_get_next_obj_inside_cpuset_by_depth(topology, set, depth, prev);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_inside_cpuset_by_depth(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, int depth, @NativeType(value="unsigned") int idx) {
        int count = 0;
        for (hwloc_obj obj = HWLoc.hwloc_get_obj_by_depth(topology, depth, 0); obj != null; obj = obj.next_cousin()) {
            if (HWLoc.hwloc_bitmap_iszero(obj.cpuset()) || !HWLoc.hwloc_bitmap_isincluded(obj.cpuset(), set)) continue;
            if (count == idx) {
                return obj;
            }
            ++count;
        }
        return null;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_inside_cpuset_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, @NativeType(value="hwloc_obj_type_t") int type, @NativeType(value="unsigned") int idx) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth == -1 || depth == -2) {
            return null;
        }
        return HWLoc.hwloc_get_obj_inside_cpuset_by_depth(topology, set, depth, idx);
    }

    @NativeType(value="unsigned")
    public static int hwloc_get_nbobjs_inside_cpuset_by_depth(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, int depth) {
        int count = 0;
        for (hwloc_obj obj = HWLoc.hwloc_get_obj_by_depth(topology, depth, 0); obj != null; obj = obj.next_cousin()) {
            if (HWLoc.hwloc_bitmap_iszero(obj.cpuset()) || !HWLoc.hwloc_bitmap_isincluded(obj.cpuset(), set)) continue;
            ++count;
        }
        return count;
    }

    public static int hwloc_get_nbobjs_inside_cpuset_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, @NativeType(value="hwloc_obj_type_t") int type) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth == -1) {
            return 0;
        }
        if (depth == -2) {
            return -1;
        }
        return HWLoc.hwloc_get_nbobjs_inside_cpuset_by_depth(topology, set, depth);
    }

    public static int hwloc_get_obj_index_inside_cpuset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, @NativeType(value="hwloc_obj_t") hwloc_obj obj) {
        if (!HWLoc.hwloc_bitmap_isincluded(obj.cpuset(), set)) {
            return -1;
        }
        int idx = 0;
        while ((obj = obj.prev_cousin()) != null) {
            if (HWLoc.hwloc_bitmap_iszero(obj.cpuset()) || !HWLoc.hwloc_bitmap_isincluded(obj.cpuset(), set)) continue;
            ++idx;
        }
        return idx;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_child_covering_cpuset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, @NativeType(value="hwloc_obj_t") hwloc_obj parent) {
        if (HWLoc.hwloc_bitmap_iszero(set)) {
            return null;
        }
        for (hwloc_obj child = parent.first_child(); child != null; child = child.next_sibling()) {
            if (child.cpuset() == 0L || !HWLoc.hwloc_bitmap_isincluded(set, child.cpuset())) continue;
            return child;
        }
        return null;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_covering_cpuset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set) {
        if (HWLoc.hwloc_bitmap_iszero(set)) {
            return null;
        }
        hwloc_obj current = Objects.requireNonNull(HWLoc.hwloc_get_root_obj(topology));
        if (!HWLoc.hwloc_bitmap_isincluded(set, current.cpuset())) {
            return null;
        }
        hwloc_obj child;
        while ((child = HWLoc.hwloc_get_child_covering_cpuset(topology, set, current)) != null) {
            current = child;
        }
        return current;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_obj_covering_cpuset_by_depth(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, int depth, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        hwloc_obj next;
        for (next = HWLoc.hwloc_get_next_obj_by_depth(topology, depth, prev); next != null && !HWLoc.hwloc_bitmap_intersects(set, next.cpuset()); next = next.next_cousin()) {
        }
        return next;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_obj_covering_cpuset_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set, @NativeType(value="hwloc_obj_type_t") int type, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth == -1 || depth == -2) {
            return null;
        }
        return HWLoc.hwloc_get_next_obj_covering_cpuset_by_depth(topology, set, depth, prev);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_ancestor_obj_by_depth(@NativeType(value="hwloc_topology_t") long topology, int depth, @NativeType(value="hwloc_obj_t") hwloc_obj obj) {
        hwloc_obj ancestor;
        if (obj.depth() < depth) {
            return null;
        }
        for (ancestor = obj; ancestor != null && ancestor.depth() > depth; ancestor = ancestor.parent()) {
        }
        return ancestor;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_ancestor_obj_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type, @NativeType(value="hwloc_obj_t") hwloc_obj obj) {
        hwloc_obj ancestor;
        for (ancestor = obj.parent(); ancestor != null && ancestor.type() != type; ancestor = ancestor.parent()) {
        }
        return ancestor;
    }

    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_common_ancestor_obj(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj1, @NativeType(value="hwloc_obj_t") hwloc_obj obj2) {
        while (obj1.address() != obj2.address()) {
            while (obj1.depth() > obj2.depth()) {
                obj1 = Objects.requireNonNull(obj1.parent());
            }
            while (obj2.depth() > obj1.depth()) {
                obj2 = Objects.requireNonNull(obj2.parent());
            }
            if (obj1.address() == obj2.address() || obj1.depth() != obj2.depth()) continue;
            obj1 = Objects.requireNonNull(obj1.parent());
            obj2 = Objects.requireNonNull(obj2.parent());
        }
        return obj1;
    }

    @NativeType(value="int")
    public static boolean hwloc_obj_is_in_subtree(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj, @NativeType(value="hwloc_obj_t") hwloc_obj subtree_root) {
        long sub_bitmap = obj.cpuset();
        long super_bitmap = subtree_root.cpuset();
        return sub_bitmap != 0L && super_bitmap != 0L && HWLoc.hwloc_bitmap_isincluded(sub_bitmap, super_bitmap);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_child(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj parent, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        hwloc_obj obj;
        int state = 0;
        if (prev != null) {
            int type = prev.type();
            if (type == 17) {
                state = 3;
            } else if (HWLoc.hwloc_obj_type_is_io(type)) {
                state = 2;
            } else if (HWLoc.hwloc_obj_type_is_memory(type)) {
                state = 1;
            }
            obj = prev.next_sibling();
        } else {
            obj = parent.first_child();
        }
        if (obj == null && state == 0) {
            obj = parent.memory_first_child();
            state = 1;
        }
        if (obj == null && state == 1) {
            obj = parent.io_first_child();
            state = 2;
        }
        if (obj == null && state == 2) {
            obj = parent.misc_first_child();
        }
        return obj;
    }

    public static int hwloc_get_cache_type_depth(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned") int cachelevel, @NativeType(value="hwloc_obj_cache_type_t") int cachetype) {
        hwloc_obj obj;
        int found = -1;
        int depth = 0;
        while ((obj = HWLoc.hwloc_get_obj_by_depth(topology, depth, 0)) != null) {
            if (HWLoc.hwloc_obj_type_is_dcache(obj.type()) && obj.attr().cache().depth() == cachelevel) {
                if (cachetype == -1) {
                    if (found != -1) {
                        return -2;
                    }
                    found = depth;
                } else if (obj.attr().cache().type() == cachetype || obj.attr().cache().type() == 0) {
                    return depth;
                }
            }
            ++depth;
        }
        return found;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_cache_covering_cpuset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long set) {
        for (hwloc_obj current = HWLoc.hwloc_get_obj_covering_cpuset(topology, set); current != null; current = current.parent()) {
            if (!HWLoc.hwloc_obj_type_is_dcache(current.type())) continue;
            return current;
        }
        return null;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_shared_cache_covering_obj(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj obj) {
        if (obj.cpuset() == 0L) {
            return null;
        }
        for (hwloc_obj current = obj.parent(); current != null; current = current.parent()) {
            if (HWLoc.hwloc_bitmap_isequal(current.cpuset(), obj.cpuset()) || !HWLoc.hwloc_obj_type_is_dcache(current.type())) continue;
            return current;
        }
        return null;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_pu_obj_by_os_index(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned") int os_index) {
        hwloc_obj obj = null;
        while ((obj = HWLoc.hwloc_get_next_obj_by_type(topology, 3, obj)) != null) {
            if (obj.os_index() != os_index) continue;
            return obj;
        }
        return null;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_numanode_obj_by_os_index(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned") int os_index) {
        hwloc_obj obj = null;
        while ((obj = HWLoc.hwloc_get_next_obj_by_type(topology, 13, obj)) != null) {
            if (obj.os_index() != os_index) continue;
            return obj;
        }
        return null;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_below_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type1, @NativeType(value="unsigned") int idx1, @NativeType(value="hwloc_obj_type_t") int type2, @NativeType(value="unsigned") int idx2) {
        hwloc_obj obj = HWLoc.hwloc_get_obj_by_type(topology, type1, idx1);
        if (obj == null) {
            return null;
        }
        return HWLoc.hwloc_get_obj_inside_cpuset_by_type(topology, obj.cpuset(), type2, idx2);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_obj_below_array_by_type(@NativeType(value="hwloc_topology_t") long topology, int nr, @NativeType(value="hwloc_obj_type_t *") IntBuffer typev, @NativeType(value="unsigned *") IntBuffer idxv) {
        hwloc_obj obj = HWLoc.hwloc_get_root_obj(topology);
        for (int i = 0; i < nr; ++i) {
            if (obj == null) {
                return null;
            }
            obj = HWLoc.hwloc_get_obj_inside_cpuset_by_type(topology, obj.cpuset(), typev.get(typev.position() + i), idxv.get(idxv.position() + i));
        }
        return obj;
    }

    public static int hwloc_distrib(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t *") PointerBuffer roots, @NativeType(value="unsigned") int n_roots, @NativeType(value="hwloc_cpuset_t *") PointerBuffer set, @NativeType(value="unsigned") int n, int until, @NativeType(value="unsigned long") long flags) {
        if ((flags & 0xFFFFFFFFFFFFFFFEL) != 0L) {
            return -1;
        }
        int tot_weight = 0;
        for (int i = 0; i < n_roots; ++i) {
            tot_weight += HWLoc.hwloc_bitmap_weight(hwloc_obj.create(roots.get(roots.position() + i)).cpuset());
        }
        PointerBuffer cpusetp = (PointerBuffer)set.slice();
        int given = 0;
        int givenweight = 0;
        for (int i = 0; i < n_roots; ++i) {
            hwloc_obj root = hwloc_obj.create(roots.get(roots.position() + ((flags & 1L) != 0L ? n_roots - 1 - i : i)));
            long cpuset = root.cpuset();
            while (!HWLoc.hwloc_obj_type_is_normal(root.type())) {
                root = Objects.requireNonNull(root.parent());
            }
            int weight = HWLoc.hwloc_bitmap_weight(cpuset);
            if (weight == 0) continue;
            int chunk = ((givenweight + weight) * n + tot_weight - 1) / tot_weight - (givenweight * n + tot_weight - 1) / tot_weight;
            if (root.arity() == 0 || chunk <= 1 || root.depth() >= until) {
                if (chunk != 0) {
                    for (int j = 0; j < chunk; ++j) {
                        cpusetp.put(cpusetp.position() + j, HWLoc.hwloc_bitmap_dup(cpuset));
                    }
                } else {
                    HWLoc.hwloc_bitmap_or(cpusetp.get(cpusetp.position() - 1), cpusetp.get(cpusetp.position() - 1), cpuset);
                }
            } else {
                HWLoc.hwloc_distrib(topology, root.children(), root.arity(), cpusetp, chunk, until, flags);
            }
            cpusetp.position(cpusetp.position() + chunk);
            given += chunk;
            givenweight += weight;
        }
        return 0;
    }

    public static int hwloc_cpuset_to_nodeset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long _cpuset, @NativeType(value="hwloc_nodeset_t") long nodeset) {
        int depth = HWLoc.hwloc_get_type_depth(topology, 13);
        HWLoc.hwloc_bitmap_zero(nodeset);
        hwloc_obj obj = null;
        while ((obj = HWLoc.hwloc_get_next_obj_covering_cpuset_by_depth(topology, _cpuset, depth, obj)) != null) {
            if (HWLoc.hwloc_bitmap_set(nodeset, obj.os_index()) >= 0) continue;
            return -1;
        }
        return 0;
    }

    public static int hwloc_cpuset_from_nodeset(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_const_cpuset_t") long _cpuset, @NativeType(value="hwloc_nodeset_t") long nodeset) {
        int depth = HWLoc.hwloc_get_type_depth(topology, 13);
        HWLoc.hwloc_bitmap_zero(_cpuset);
        hwloc_obj obj = null;
        while ((obj = HWLoc.hwloc_get_next_obj_by_depth(topology, depth, obj)) != null) {
            if (!HWLoc.hwloc_bitmap_isset(nodeset, obj.os_index()) || HWLoc.hwloc_bitmap_or(_cpuset, _cpuset, obj.cpuset()) >= 0) continue;
            return -1;
        }
        return 0;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_non_io_ancestor_obj(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_t") hwloc_obj ioobj) {
        hwloc_obj obj;
        for (obj = ioobj; obj != null && obj.cpuset() == 0L; obj = obj.parent()) {
        }
        return obj;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_pcidev(@NativeType(value="hwloc_topology_t") long topology, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        return HWLoc.hwloc_get_next_obj_by_type(topology, 15, prev);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_pcidev_by_busid(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="unsigned") int domain, @NativeType(value="unsigned") int bus, @NativeType(value="unsigned") int dev, @NativeType(value="unsigned") int func) {
        hwloc_obj obj = null;
        while ((obj = HWLoc.hwloc_get_next_pcidev(topology, obj)) != null) {
            hwloc_pcidev_attr_s pcidev = obj.attr().pcidev();
            if (pcidev.domain() != domain || pcidev.bus() != bus || pcidev.dev() != dev || pcidev.func() != func) continue;
            return obj;
        }
        return null;
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_pcidev_by_busidstring(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="char const *") CharSequence busid) {
        Matcher m = BUSID_PATTERN.matcher(busid);
        if (!m.find()) {
            return null;
        }
        String domainGroup = m.group(1);
        int domain = domainGroup == null ? 0 : Integer.parseInt(domainGroup, 16);
        int bus = Integer.parseInt(m.group(2), 16);
        int dev = Integer.parseInt(m.group(3), 16);
        int func = Integer.parseInt(m.group(4), 16);
        return HWLoc.hwloc_get_pcidev_by_busid(topology, domain, bus, dev, func);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_osdev(@NativeType(value="hwloc_topology_t") long topology, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        return HWLoc.hwloc_get_next_obj_by_type(topology, 16, prev);
    }

    @Nullable
    @NativeType(value="hwloc_obj_t")
    public static hwloc_obj hwloc_get_next_bridge(@NativeType(value="hwloc_topology_t") long topology, @Nullable @NativeType(value="hwloc_obj_t") hwloc_obj prev) {
        return HWLoc.hwloc_get_next_obj_by_type(topology, 14, prev);
    }

    @NativeType(value="int")
    public static boolean hwloc_bridge_covers_pcibus(@NativeType(value="hwloc_obj_t") hwloc_obj bridge, @NativeType(value="unsigned") int domain, @NativeType(value="unsigned") int bus) {
        if (bridge.type() != 14) {
            return false;
        }
        hwloc_bridge_attr_s attr = bridge.attr().bridge();
        return attr.downstream_type() == 1 && attr.downstream_pci_domain() == domain && attr.downstream_pci_secondary_bus() <= bus && attr.downstream_pci_secondary_bus() >= bus;
    }

    public static int hwloc_distances_obj_index(@NativeType(value="struct hwloc_distances_s *") hwloc_distances_s distances, @NativeType(value="hwloc_obj_t") hwloc_obj obj) {
        PointerBuffer objs = distances.objs();
        for (int i = 0; i < objs.remaining(); ++i) {
            if (objs.get(i) != obj.address()) continue;
            return i;
        }
        return -1;
    }

    public static int hwloc_distances_obj_pair_values(@NativeType(value="struct hwloc_distances_s *") hwloc_distances_s distances, @NativeType(value="hwloc_obj_t") hwloc_obj obj1, @NativeType(value="hwloc_obj_t") hwloc_obj obj2, LongBuffer value1to2, LongBuffer value2to1) {
        int i1 = HWLoc.hwloc_distances_obj_index(distances, obj1);
        int i2 = HWLoc.hwloc_distances_obj_index(distances, obj2);
        if (i1 < 0 || i2 < 0) {
            return -1;
        }
        LongBuffer values = distances.values();
        value1to2.put(value1to2.position(), values.get(i1 * distances.nbobjs() + i2));
        value2to1.put(value2to1.position(), values.get(i2 * distances.nbobjs() + i1));
        return 0;
    }

    public static int hwloc_distances_remove_by_type(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="hwloc_obj_type_t") int type) {
        int depth = HWLoc.hwloc_get_type_depth(topology, type);
        if (depth == -1 || depth == -2) {
            return 0;
        }
        return HWLoc.hwloc_distances_remove_by_depth(topology, depth);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return HWLOC;
    }

    public static final class Functions {
        public static final long bitmap_alloc = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_alloc");
        public static final long bitmap_alloc_full = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_alloc_full");
        public static final long bitmap_free = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_free");
        public static final long bitmap_dup = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_dup");
        public static final long bitmap_copy = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_copy");
        public static final long bitmap_snprintf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_snprintf");
        public static final long bitmap_asprintf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_asprintf");
        public static final long bitmap_sscanf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_sscanf");
        public static final long bitmap_list_snprintf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_list_snprintf");
        public static final long bitmap_list_asprintf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_list_asprintf");
        public static final long bitmap_list_sscanf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_list_sscanf");
        public static final long bitmap_taskset_snprintf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_taskset_snprintf");
        public static final long bitmap_taskset_asprintf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_taskset_asprintf");
        public static final long bitmap_taskset_sscanf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_taskset_sscanf");
        public static final long bitmap_zero = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_zero");
        public static final long bitmap_fill = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_fill");
        public static final long bitmap_only = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_only");
        public static final long bitmap_allbut = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_allbut");
        public static final long bitmap_from_ulong = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_from_ulong");
        public static final long bitmap_from_ith_ulong = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_from_ith_ulong");
        public static final long bitmap_from_ulongs = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_from_ulongs");
        public static final long bitmap_set = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_set");
        public static final long bitmap_set_range = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_set_range");
        public static final long bitmap_set_ith_ulong = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_set_ith_ulong");
        public static final long bitmap_clr = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_clr");
        public static final long bitmap_clr_range = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_clr_range");
        public static final long bitmap_singlify = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_singlify");
        public static final long bitmap_to_ulong = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_to_ulong");
        public static final long bitmap_to_ith_ulong = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_to_ith_ulong");
        public static final long bitmap_to_ulongs = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_to_ulongs");
        public static final long bitmap_nr_ulongs = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_nr_ulongs");
        public static final long bitmap_isset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_isset");
        public static final long bitmap_iszero = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_iszero");
        public static final long bitmap_isfull = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_isfull");
        public static final long bitmap_first = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_first");
        public static final long bitmap_next = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_next");
        public static final long bitmap_last = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_last");
        public static final long bitmap_weight = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_weight");
        public static final long bitmap_first_unset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_first_unset");
        public static final long bitmap_next_unset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_next_unset");
        public static final long bitmap_last_unset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_last_unset");
        public static final long bitmap_or = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_or");
        public static final long bitmap_and = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_and");
        public static final long bitmap_andnot = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_andnot");
        public static final long bitmap_xor = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_xor");
        public static final long bitmap_not = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_not");
        public static final long bitmap_intersects = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_intersects");
        public static final long bitmap_isincluded = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_isincluded");
        public static final long bitmap_isequal = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_isequal");
        public static final long bitmap_compare_first = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_compare_first");
        public static final long bitmap_compare = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_compare");
        public static final long get_api_version = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_api_version");
        public static final long compare_types = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_compare_types");
        public static final long topology_init = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_init");
        public static final long topology_load = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_load");
        public static final long topology_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_destroy");
        public static final long topology_dup = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_dup");
        public static final long topology_abi_check = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_abi_check");
        public static final long topology_check = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_check");
        public static final long topology_get_depth = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_depth");
        public static final long get_type_depth = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_type_depth");
        public static final long get_type_depth_with_attr = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_type_depth_with_attr");
        public static final long get_memory_parents_depth = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_memory_parents_depth");
        public static final long get_depth_type = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_depth_type");
        public static final long get_nbobjs_by_depth = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_nbobjs_by_depth");
        public static final long get_obj_by_depth = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_obj_by_depth");
        public static final long obj_type_string = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_type_string");
        public static final long obj_type_snprintf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_type_snprintf");
        public static final long obj_attr_snprintf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_attr_snprintf");
        public static final long type_sscanf = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_type_sscanf");
        public static final long modify_infos = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_modify_infos");
        public static final long topology_get_infos = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_infos");
        public static final long obj_set_subtype = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_set_subtype");
        public static final long set_cpubind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_cpubind");
        public static final long get_cpubind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_cpubind");
        public static final long set_proc_cpubind_pid = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_proc_cpubind");
        public static final long set_proc_cpubind_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_proc_cpubind");
        public static final long get_proc_cpubind_pid = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_proc_cpubind");
        public static final long get_proc_cpubind_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_proc_cpubind");
        public static final long set_thread_cpubind_pthread = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_thread_cpubind");
        public static final long set_thread_cpubind_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_thread_cpubind");
        public static final long get_thread_cpubind_pthread = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_thread_cpubind");
        public static final long get_thread_cpubind_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_thread_cpubind");
        public static final long get_last_cpu_location = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_last_cpu_location");
        public static final long get_proc_last_cpu_location_pid = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_proc_last_cpu_location");
        public static final long get_proc_last_cpu_location_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_proc_last_cpu_location");
        public static final long set_membind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_membind");
        public static final long get_membind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_membind");
        public static final long set_proc_membind_pid = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_proc_membind");
        public static final long set_proc_membind_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_proc_membind");
        public static final long get_proc_membind_pid = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_proc_membind");
        public static final long get_proc_membind_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_proc_membind");
        public static final long set_area_membind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_set_area_membind");
        public static final long get_area_membind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_area_membind");
        public static final long get_area_memlocation = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_area_memlocation");
        public static final long alloc = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_alloc");
        public static final long alloc_membind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_alloc_membind");
        public static final long free = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_free");
        public static final long topology_set_pid_pid = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_pid");
        public static final long topology_set_pid_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_pid");
        public static final long topology_set_synthetic = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_synthetic");
        public static final long topology_set_xml = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_xml");
        public static final long topology_set_xmlbuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_xmlbuffer");
        public static final long topology_set_components = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_components");
        public static final long topology_set_flags = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_flags");
        public static final long topology_get_flags = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_flags");
        public static final long topology_is_thissystem = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_is_thissystem");
        public static final long topology_get_support = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_support");
        public static final long topology_set_type_filter = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_type_filter");
        public static final long topology_get_type_filter = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_type_filter");
        public static final long topology_set_all_types_filter = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_all_types_filter");
        public static final long topology_set_cache_types_filter = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_cache_types_filter");
        public static final long topology_set_icache_types_filter = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_icache_types_filter");
        public static final long topology_set_io_types_filter = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_io_types_filter");
        public static final long topology_set_userdata = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_userdata");
        public static final long topology_get_userdata = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_userdata");
        public static final long topology_restrict = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_restrict");
        public static final long topology_allow = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_allow");
        public static final long topology_insert_misc_object = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_insert_misc_object");
        public static final long topology_alloc_group_object = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_alloc_group_object");
        public static final long topology_free_group_object = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_free_group_object");
        public static final long topology_insert_group_object = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_insert_group_object");
        public static final long obj_add_other_obj_sets = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_add_other_obj_sets");
        public static final long topology_refresh = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_refresh");
        public static final long obj_type_is_normal = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_type_is_normal");
        public static final long obj_type_is_io = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_type_is_io");
        public static final long obj_type_is_memory = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_type_is_memory");
        public static final long obj_type_is_cache = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_type_is_cache");
        public static final long obj_type_is_dcache = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_type_is_dcache");
        public static final long obj_type_is_icache = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_obj_type_is_icache");
        public static final long get_largest_objs_inside_cpuset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_largest_objs_inside_cpuset");
        public static final long bitmap_singlify_per_core = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_bitmap_singlify_per_core");
        public static final long get_closest_objs = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_closest_objs");
        public static final long get_obj_with_same_locality = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_obj_with_same_locality");
        public static final long topology_get_complete_cpuset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_complete_cpuset");
        public static final long topology_get_topology_cpuset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_topology_cpuset");
        public static final long topology_get_allowed_cpuset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_allowed_cpuset");
        public static final long topology_get_complete_nodeset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_complete_nodeset");
        public static final long topology_get_topology_nodeset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_topology_nodeset");
        public static final long topology_get_allowed_nodeset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_get_allowed_nodeset");
        public static final long memattr_get_by_name = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_get_by_name");
        public static final long get_local_numanode_objs = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_get_local_numanode_objs");
        public static final long memattr_get_value = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_get_value");
        public static final long memattr_get_best_target = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_get_best_target");
        public static final long memattr_get_best_initiator = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_get_best_initiator");
        public static final long memattr_get_name = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_get_name");
        public static final long memattr_get_flags = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_get_flags");
        public static final long memattr_register = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_register");
        public static final long memattr_set_value = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_set_value");
        public static final long memattr_get_targets = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_get_targets");
        public static final long memattr_get_initiators = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_memattr_get_initiators");
        public static final long cpukinds_get_nr = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_cpukinds_get_nr");
        public static final long cpukinds_get_by_cpuset = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_cpukinds_get_by_cpuset");
        public static final long cpukinds_get_info = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_cpukinds_get_info");
        public static final long cpukinds_register = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_cpukinds_register");
        public static final long topology_export_xml = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_export_xml");
        public static final long topology_export_xmlbuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_export_xmlbuffer");
        public static final long free_xmlbuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_free_xmlbuffer");
        public static final long topology_set_userdata_export_callback = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_userdata_export_callback");
        public static final long export_obj_userdata = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_export_obj_userdata");
        public static final long export_obj_userdata_base64 = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_export_obj_userdata_base64");
        public static final long topology_set_userdata_import_callback = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_set_userdata_import_callback");
        public static final long topology_export_synthetic = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_export_synthetic");
        public static final long distances_get = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_get");
        public static final long distances_get_by_depth = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_get_by_depth");
        public static final long distances_get_by_type = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_get_by_type");
        public static final long distances_get_by_name = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_get_by_name");
        public static final long distances_get_name = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_get_name");
        public static final long distances_release = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_release");
        public static final long distances_transform = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_transform");
        public static final long distances_add_create = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_add_create");
        public static final long distances_add_values = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_add_values");
        public static final long distances_add_commit = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_add_commit");
        public static final long distances_remove = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_remove");
        public static final long distances_remove_by_depth = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_remove_by_depth");
        public static final long distances_release_remove = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_distances_release_remove");
        public static final long topology_diff_build = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_diff_build");
        public static final long topology_diff_apply = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_diff_apply");
        public static final long topology_diff_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_diff_destroy");
        public static final long topology_diff_load_xml = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_diff_load_xml");
        public static final long topology_diff_export_xml = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_diff_export_xml");
        public static final long topology_diff_load_xmlbuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_diff_load_xmlbuffer");
        public static final long topology_diff_export_xmlbuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.access$000(), (String)"hwloc_topology_diff_export_xmlbuffer");

        private Functions() {
        }
    }
}

