/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class GLFWVulkan {
    protected GLFWVulkan() {
        throw new UnsupportedOperationException();
    }

    public static boolean glfwVulkanSupported() {
        long __functionAddress = Functions.VulkanSupported;
        return JNI.invokeI((long)__functionAddress) != 0;
    }

    public static long nglfwGetRequiredInstanceExtensions(long count) {
        long __functionAddress = Functions.GetRequiredInstanceExtensions;
        return JNI.invokePP((long)__functionAddress, (long)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer glfwGetRequiredInstanceExtensions() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = GLFWVulkan.nglfwGetRequiredInstanceExtensions(MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nglfwGetInstanceProcAddress(long instance, long procname) {
        long __functionAddress = Functions.GetInstanceProcAddress;
        return JNI.invokePPP((long)__functionAddress, (long)instance, (long)procname);
    }

    public static long glfwGetInstanceProcAddress(VkInstance instance, ByteBuffer procname) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)procname);
        }
        return GLFWVulkan.nglfwGetInstanceProcAddress(MemoryUtil.memAddressSafe((Pointer)instance), MemoryUtil.memAddress((ByteBuffer)procname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glfwGetInstanceProcAddress(VkInstance instance, CharSequence procname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer procnameEncoded = stack.ASCII(procname);
            long l = GLFWVulkan.nglfwGetInstanceProcAddress(MemoryUtil.memAddressSafe((Pointer)instance), MemoryUtil.memAddress((ByteBuffer)procnameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glfwGetPhysicalDevicePresentationSupport(VkInstance instance, VkPhysicalDevice device, int queuefamily) {
        long __functionAddress = Functions.GetPhysicalDevicePresentationSupport;
        return JNI.invokePPI((long)__functionAddress, (long)instance.address(), (long)device.address(), (int)queuefamily) != 0;
    }

    public static int nglfwCreateWindowSurface(long instance, long window, long allocator, long surface) {
        long __functionAddress = Functions.CreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)window);
            if (allocator != 0L) {
                VkAllocationCallbacks.validate((long)allocator);
            }
        }
        return JNI.invokePPPPI((long)__functionAddress, (long)instance, (long)window, (long)allocator, (long)surface);
    }

    public static int glfwCreateWindowSurface(VkInstance instance, long window, VkAllocationCallbacks allocator, LongBuffer surface) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)surface, (int)1);
        }
        return GLFWVulkan.nglfwCreateWindowSurface(instance.address(), window, MemoryUtil.memAddressSafe((Pointer)allocator), MemoryUtil.memAddress((LongBuffer)surface));
    }

    public static int glfwCreateWindowSurface(VkInstance instance, long window, VkAllocationCallbacks allocator, long[] surface) {
        long __functionAddress = Functions.CreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)window);
            Checks.checkBuffer((long[])surface, (int)1);
            if (allocator != null) {
                VkAllocationCallbacks.validate((long)allocator.address());
            }
        }
        return JNI.invokePPPPI((long)__functionAddress, (long)instance.address(), (long)window, (long)MemoryUtil.memAddressSafe((Pointer)allocator), (long[])surface);
    }

    public static final class Functions {
        public static final long VulkanSupported = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwVulkanSupported");
        public static final long GetRequiredInstanceExtensions = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetRequiredInstanceExtensions");
        public static final long GetInstanceProcAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetInstanceProcAddress");
        public static final long GetPhysicalDevicePresentationSupport = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetPhysicalDevicePresentationSupport");
        public static final long CreateWindowSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwCreateWindowSurface");

        private Functions() {
        }
    }
}

