/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class GLFWImage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int PIXELS;

    GLFWImage(long address, ByteBuffer container) {
        super(address, container);
    }

    public GLFWImage(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), GLFWImage.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int width() {
        return GLFWImage.nwidth(this.address());
    }

    public int height() {
        return GLFWImage.nheight(this.address());
    }

    public ByteBuffer pixels(int capacity) {
        return GLFWImage.npixels(this.address(), capacity);
    }

    public GLFWImage width(int value) {
        GLFWImage.nwidth(this.address(), value);
        return this;
    }

    public GLFWImage height(int value) {
        GLFWImage.nheight(this.address(), value);
        return this;
    }

    public GLFWImage pixels(ByteBuffer value) {
        GLFWImage.npixels(this.address(), value);
        return this;
    }

    public GLFWImage set(int width, int height, ByteBuffer pixels) {
        this.width(width);
        this.height(height);
        this.pixels(pixels);
        return this;
    }

    public GLFWImage nset(long struct) {
        MemoryUtil.memCopy((long)struct, (long)this.address(), (int)SIZEOF);
        return this;
    }

    public GLFWImage set(GLFWImage src) {
        return this.nset(src.address());
    }

    public static GLFWImage malloc() {
        return GLFWImage.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static GLFWImage calloc() {
        return GLFWImage.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static GLFWImage create() {
        return new GLFWImage(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static GLFWImage create(long address) {
        return address == 0L ? null : new GLFWImage(address, null);
    }

    public static Buffer malloc(int capacity) {
        return GLFWImage.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return GLFWImage.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static GLFWImage mallocStack() {
        return GLFWImage.mallocStack(MemoryStack.stackGet());
    }

    public static GLFWImage callocStack() {
        return GLFWImage.callocStack(MemoryStack.stackGet());
    }

    public static GLFWImage mallocStack(MemoryStack stack) {
        return GLFWImage.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static GLFWImage callocStack(MemoryStack stack) {
        return GLFWImage.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return GLFWImage.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return GLFWImage.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return GLFWImage.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return GLFWImage.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WIDTH));
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEIGHT));
    }

    public static ByteBuffer npixels(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)), (int)capacity);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WIDTH), (int)value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HEIGHT), (int)value);
    }

    public static void npixels(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIXELS), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.checkPointer((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            GLFWImage.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = GLFWImage.__struct((Struct.Member[])new Struct.Member[]{GLFWImage.__member((int)4), GLFWImage.__member((int)4), GLFWImage.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        PIXELS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<GLFWImage, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected GLFWImage newInstance(long address) {
            return new GLFWImage(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }

        public int width() {
            return GLFWImage.nwidth(this.address());
        }

        public int height() {
            return GLFWImage.nheight(this.address());
        }

        public ByteBuffer pixels(int capacity) {
            return GLFWImage.npixels(this.address(), capacity);
        }

        public Buffer width(int value) {
            GLFWImage.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            GLFWImage.nheight(this.address(), value);
            return this;
        }

        public Buffer pixels(ByteBuffer value) {
            GLFWImage.npixels(this.address(), value);
            return this;
        }
    }
}

