/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class GLFWGammaRamp
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int SIZE;

    GLFWGammaRamp(long address, ByteBuffer container) {
        super(address, container);
    }

    public GLFWGammaRamp(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), GLFWGammaRamp.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public ShortBuffer red() {
        return GLFWGammaRamp.nred(this.address());
    }

    public ShortBuffer green() {
        return GLFWGammaRamp.ngreen(this.address());
    }

    public ShortBuffer blue() {
        return GLFWGammaRamp.nblue(this.address());
    }

    public int size() {
        return GLFWGammaRamp.nsize(this.address());
    }

    public GLFWGammaRamp red(ShortBuffer value) {
        GLFWGammaRamp.nred(this.address(), value);
        return this;
    }

    public GLFWGammaRamp green(ShortBuffer value) {
        GLFWGammaRamp.ngreen(this.address(), value);
        return this;
    }

    public GLFWGammaRamp blue(ShortBuffer value) {
        GLFWGammaRamp.nblue(this.address(), value);
        return this;
    }

    public GLFWGammaRamp size(int value) {
        GLFWGammaRamp.nsize(this.address(), value);
        return this;
    }

    public GLFWGammaRamp set(ShortBuffer red, ShortBuffer green, ShortBuffer blue, int size) {
        this.red(red);
        this.green(green);
        this.blue(blue);
        this.size(size);
        return this;
    }

    public GLFWGammaRamp nset(long struct) {
        MemoryUtil.memCopy((long)struct, (long)this.address(), (int)SIZEOF);
        return this;
    }

    public GLFWGammaRamp set(GLFWGammaRamp src) {
        return this.nset(src.address());
    }

    public static GLFWGammaRamp malloc() {
        return GLFWGammaRamp.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static GLFWGammaRamp calloc() {
        return GLFWGammaRamp.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static GLFWGammaRamp create() {
        return new GLFWGammaRamp(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static GLFWGammaRamp create(long address) {
        return address == 0L ? null : new GLFWGammaRamp(address, null);
    }

    public static Buffer malloc(int capacity) {
        return GLFWGammaRamp.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return GLFWGammaRamp.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static GLFWGammaRamp mallocStack() {
        return GLFWGammaRamp.mallocStack(MemoryStack.stackGet());
    }

    public static GLFWGammaRamp callocStack() {
        return GLFWGammaRamp.callocStack(MemoryStack.stackGet());
    }

    public static GLFWGammaRamp mallocStack(MemoryStack stack) {
        return GLFWGammaRamp.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static GLFWGammaRamp callocStack(MemoryStack stack) {
        return GLFWGammaRamp.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return GLFWGammaRamp.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return GLFWGammaRamp.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return GLFWGammaRamp.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return GLFWGammaRamp.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ShortBuffer nred(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)RED)), (int)GLFWGammaRamp.nsize(struct));
    }

    public static ShortBuffer ngreen(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)GREEN)), (int)GLFWGammaRamp.nsize(struct));
    }

    public static ShortBuffer nblue(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BLUE)), (int)GLFWGammaRamp.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static void nred(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RED), (long)MemoryUtil.memAddress((ShortBuffer)value));
    }

    public static void ngreen(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)GREEN), (long)MemoryUtil.memAddress((ShortBuffer)value));
    }

    public static void nblue(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BLUE), (long)MemoryUtil.memAddress((ShortBuffer)value));
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void validate(long struct) {
        Checks.checkPointer((long)MemoryUtil.memGetAddress((long)(struct + (long)RED)));
        Checks.checkPointer((long)MemoryUtil.memGetAddress((long)(struct + (long)GREEN)));
        Checks.checkPointer((long)MemoryUtil.memGetAddress((long)(struct + (long)BLUE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            GLFWGammaRamp.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = GLFWGammaRamp.__struct((Struct.Member[])new Struct.Member[]{GLFWGammaRamp.__member((int)POINTER_SIZE), GLFWGammaRamp.__member((int)POINTER_SIZE), GLFWGammaRamp.__member((int)POINTER_SIZE), GLFWGammaRamp.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RED = layout.offsetof(0);
        GREEN = layout.offsetof(1);
        BLUE = layout.offsetof(2);
        SIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<GLFWGammaRamp, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected GLFWGammaRamp newInstance(long address) {
            return new GLFWGammaRamp(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }

        public ShortBuffer red() {
            return GLFWGammaRamp.nred(this.address());
        }

        public ShortBuffer green() {
            return GLFWGammaRamp.ngreen(this.address());
        }

        public ShortBuffer blue() {
            return GLFWGammaRamp.nblue(this.address());
        }

        public int size() {
            return GLFWGammaRamp.nsize(this.address());
        }

        public Buffer red(ShortBuffer value) {
            GLFWGammaRamp.nred(this.address(), value);
            return this;
        }

        public Buffer green(ShortBuffer value) {
            GLFWGammaRamp.ngreen(this.address(), value);
            return this;
        }

        public Buffer blue(ShortBuffer value) {
            GLFWGammaRamp.nblue(this.address(), value);
            return this;
        }

        public Buffer size(int value) {
            GLFWGammaRamp.nsize(this.address(), value);
            return this;
        }
    }
}

