/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.fmod.FMOD;
import org.lwjgl.fmod.FSBANK_MEMORY_ALLOC_CALLBACKI;
import org.lwjgl.fmod.FSBANK_MEMORY_FREE_CALLBACKI;
import org.lwjgl.fmod.FSBANK_MEMORY_REALLOC_CALLBACKI;
import org.lwjgl.fmod.FSBANK_PROGRESSITEM;
import org.lwjgl.fmod.FSBANK_SUBSOUND;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class FSBank {
    private static final SharedLibrary FSBANK;
    public static final int FSBANK_INIT_NORMAL = 0;
    public static final int FSBANK_INIT_IGNOREERRORS = 1;
    public static final int FSBANK_INIT_WARNINGSASERRORS = 2;
    public static final int FSBANK_INIT_CREATEINCLUDEHEADER = 4;
    public static final int FSBANK_INIT_DONTLOADCACHEFILES = 8;
    public static final int FSBANK_INIT_GENERATEPROGRESSITEMS = 16;
    public static final int FSBANK_BUILD_DEFAULT = 0;
    public static final int FSBANK_BUILD_DISABLESYNCPOINTS = 1;
    public static final int FSBANK_BUILD_DONTLOOP = 2;
    public static final int FSBANK_BUILD_FILTERHIGHFREQ = 4;
    public static final int FSBANK_BUILD_DISABLESEEKING = 8;
    public static final int FSBANK_BUILD_OPTIMIZESAMPLERATE = 16;
    public static final int FSBANK_BUILD_FSB5_DONTWRITENAMES = 128;
    public static final int FSBANK_BUILD_NOGUID = 256;
    public static final int FSBANK_BUILD_WRITEPEAKVOLUME = 512;
    public static final int FSBANK_BUILD_ALIGN4K = 1024;
    public static final int FSBANK_BUILD_OVERRIDE_MASK = 543;
    public static final int FSBANK_BUILD_CACHE_VALIDATION_MASK = 22;
    public static final int FSBANK_OK = 0;
    public static final int FSBANK_ERR_CACHE_CHUNKNOTFOUND = 1;
    public static final int FSBANK_ERR_CANCELLED = 2;
    public static final int FSBANK_ERR_CANNOT_CONTINUE = 3;
    public static final int FSBANK_ERR_ENCODER = 4;
    public static final int FSBANK_ERR_ENCODER_INIT = 5;
    public static final int FSBANK_ERR_ENCODER_NOTSUPPORTED = 6;
    public static final int FSBANK_ERR_FILE_OS = 7;
    public static final int FSBANK_ERR_FILE_NOTFOUND = 8;
    public static final int FSBANK_ERR_FMOD = 9;
    public static final int FSBANK_ERR_INITIALIZED = 10;
    public static final int FSBANK_ERR_INVALID_FORMAT = 11;
    public static final int FSBANK_ERR_INVALID_PARAM = 12;
    public static final int FSBANK_ERR_MEMORY = 13;
    public static final int FSBANK_ERR_UNINITIALIZED = 14;
    public static final int FSBANK_ERR_WRITER_FORMAT = 15;
    public static final int FSBANK_WARN_CANNOTLOOP = 16;
    public static final int FSBANK_WARN_IGNORED_FILTERHIGHFREQ = 17;
    public static final int FSBANK_WARN_IGNORED_DISABLESEEKING = 18;
    public static final int FSBANK_WARN_FORCED_DONTWRITENAMES = 19;
    public static final int FSBANK_ERR_ENCODER_FILE_NOTFOUND = 20;
    public static final int FSBANK_ERR_ENCODER_FILE_BAD = 21;
    public static final int FSBANK_WARN_IGNORED_ALIGN4K = 22;
    public static final int FSBANK_FORMAT_PCM = 0;
    public static final int FSBANK_FORMAT_XMA = 1;
    public static final int FSBANK_FORMAT_AT9 = 2;
    public static final int FSBANK_FORMAT_VORBIS = 3;
    public static final int FSBANK_FORMAT_FADPCM = 4;
    public static final int FSBANK_FORMAT_OPUS = 5;
    public static final int FSBANK_FORMAT_MAX = 6;
    public static final int FSBANK_FSBVERSION_FSB5 = 0;
    public static final int FSBANK_FSBVERSION_MAX = 1;
    public static final int FSBANK_STATE_DECODING = 0;
    public static final int FSBANK_STATE_ANALYSING = 1;
    public static final int FSBANK_STATE_PREPROCESSING = 2;
    public static final int FSBANK_STATE_ENCODING = 3;
    public static final int FSBANK_STATE_WRITING = 4;
    public static final int FSBANK_STATE_FINISHED = 5;
    public static final int FSBANK_STATE_FAILED = 6;
    public static final int FSBANK_STATE_WARNING = 7;

    public static SharedLibrary getLibrary() {
        return FSBANK;
    }

    protected FSBank() {
        throw new UnsupportedOperationException();
    }

    public static int nFSBank_MemoryInit(long userAlloc, long userRealloc, long userFree) {
        long __functionAddress = Functions.MemoryInit;
        return JNI.callPPPI((long)userAlloc, (long)userRealloc, (long)userFree, (long)__functionAddress);
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_MemoryInit(@Nullable @NativeType(value="FSBANK_MEMORY_ALLOC_CALLBACK") FSBANK_MEMORY_ALLOC_CALLBACKI userAlloc, @Nullable @NativeType(value="FSBANK_MEMORY_REALLOC_CALLBACK") FSBANK_MEMORY_REALLOC_CALLBACKI userRealloc, @Nullable @NativeType(value="FSBANK_MEMORY_FREE_CALLBACK") FSBANK_MEMORY_FREE_CALLBACKI userFree) {
        return FSBank.nFSBank_MemoryInit(MemoryUtil.memAddressSafe((Pointer)userAlloc), MemoryUtil.memAddressSafe((Pointer)userRealloc), MemoryUtil.memAddressSafe((Pointer)userFree));
    }

    public static int nFSBank_Init(int version, int flags, int numSimultaneousJobs, long cacheDirectory) {
        long __functionAddress = Functions.Init;
        return JNI.callPI((int)version, (int)flags, (int)numSimultaneousJobs, (long)cacheDirectory, (long)__functionAddress);
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_Init(@NativeType(value="FSBANK_FSBVERSION") int version, @NativeType(value="FSBANK_INITFLAGS") int flags, @NativeType(value="unsigned int") int numSimultaneousJobs, @Nullable @NativeType(value="char const *") ByteBuffer cacheDirectory) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)cacheDirectory);
        }
        return FSBank.nFSBank_Init(version, flags, numSimultaneousJobs, MemoryUtil.memAddressSafe((ByteBuffer)cacheDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_Init(@NativeType(value="FSBANK_FSBVERSION") int version, @NativeType(value="FSBANK_INITFLAGS") int flags, @NativeType(value="unsigned int") int numSimultaneousJobs, @Nullable @NativeType(value="char const *") CharSequence cacheDirectory) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(cacheDirectory, true);
            long cacheDirectoryEncoded = cacheDirectory == null ? 0L : stack.getPointerAddress();
            int n = FSBank.nFSBank_Init(version, flags, numSimultaneousJobs, cacheDirectoryEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_Release() {
        long __functionAddress = Functions.Release;
        return JNI.callI((long)__functionAddress);
    }

    public static int nFSBank_Build(long subSounds, int numSubSounds, int encodeFormat, int buildFlags, int quality, long encryptKey, long outputFileName) {
        long __functionAddress = Functions.Build;
        if (Checks.CHECKS) {
            FSBANK_SUBSOUND.validate(subSounds);
        }
        return JNI.callPPPI((long)subSounds, (int)numSubSounds, (int)encodeFormat, (int)buildFlags, (int)quality, (long)encryptKey, (long)outputFileName, (long)__functionAddress);
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_Build(@NativeType(value="FSBANK_SUBSOUND const *") FSBANK_SUBSOUND subSounds, @NativeType(value="unsigned int") int numSubSounds, @NativeType(value="FSBANK_FORMAT") int encodeFormat, @NativeType(value="FSBANK_BUILDFLAGS") int buildFlags, @NativeType(value="unsigned int") int quality, @Nullable @NativeType(value="char const *") ByteBuffer encryptKey, @Nullable @NativeType(value="char const *") ByteBuffer outputFileName) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)encryptKey);
            Checks.checkNT1Safe((ByteBuffer)outputFileName);
        }
        return FSBank.nFSBank_Build(subSounds.address(), numSubSounds, encodeFormat, buildFlags, quality, MemoryUtil.memAddressSafe((ByteBuffer)encryptKey), MemoryUtil.memAddressSafe((ByteBuffer)outputFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_Build(@NativeType(value="FSBANK_SUBSOUND const *") FSBANK_SUBSOUND subSounds, @NativeType(value="unsigned int") int numSubSounds, @NativeType(value="FSBANK_FORMAT") int encodeFormat, @NativeType(value="FSBANK_BUILDFLAGS") int buildFlags, @NativeType(value="unsigned int") int quality, @Nullable @NativeType(value="char const *") CharSequence encryptKey, @Nullable @NativeType(value="char const *") CharSequence outputFileName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(encryptKey, true);
            long encryptKeyEncoded = encryptKey == null ? 0L : stack.getPointerAddress();
            stack.nUTF8Safe(outputFileName, true);
            long outputFileNameEncoded = outputFileName == null ? 0L : stack.getPointerAddress();
            int n = FSBank.nFSBank_Build(subSounds.address(), numSubSounds, encodeFormat, buildFlags, quality, encryptKeyEncoded, outputFileNameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nFSBank_FetchFSBMemory(long data, long length) {
        long __functionAddress = Functions.FetchFSBMemory;
        return JNI.callPPI((long)data, (long)length, (long)__functionAddress);
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_FetchFSBMemory(@NativeType(value="void const **") PointerBuffer data, @NativeType(value="unsigned int *") IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)data, (int)1);
            Checks.check((Buffer)length, (int)1);
        }
        return FSBank.nFSBank_FetchFSBMemory(MemoryUtil.memAddress((CustomBuffer)data), MemoryUtil.memAddress((IntBuffer)length));
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_BuildCancel() {
        long __functionAddress = Functions.BuildCancel;
        return JNI.callI((long)__functionAddress);
    }

    public static int nFSBank_FetchNextProgressItem(long progressItem) {
        long __functionAddress = Functions.FetchNextProgressItem;
        return JNI.callPI((long)progressItem, (long)__functionAddress);
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_FetchNextProgressItem(@NativeType(value="FSBANK_PROGRESSITEM const **") PointerBuffer progressItem) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)progressItem, (int)1);
        }
        return FSBank.nFSBank_FetchNextProgressItem(MemoryUtil.memAddress((CustomBuffer)progressItem));
    }

    public static int nFSBank_ReleaseProgressItem(long progressItem) {
        long __functionAddress = Functions.ReleaseProgressItem;
        return JNI.callPI((long)progressItem, (long)__functionAddress);
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_ReleaseProgressItem(@NativeType(value="FSBANK_PROGRESSITEM const *") FSBANK_PROGRESSITEM progressItem) {
        return FSBank.nFSBank_ReleaseProgressItem(progressItem.address());
    }

    public static int nFSBank_MemoryGetStats(long currentAllocated, long maximumAllocated) {
        long __functionAddress = Functions.MemoryGetStats;
        return JNI.callPPI((long)currentAllocated, (long)maximumAllocated, (long)__functionAddress);
    }

    @NativeType(value="FSBANK_RESULT")
    public static int FSBank_MemoryGetStats(@Nullable @NativeType(value="unsigned int *") IntBuffer currentAllocated, @Nullable @NativeType(value="unsigned int *") IntBuffer maximumAllocated) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)currentAllocated, (int)1);
            Checks.checkSafe((Buffer)maximumAllocated, (int)1);
        }
        return FSBank.nFSBank_MemoryGetStats(MemoryUtil.memAddressSafe((IntBuffer)currentAllocated), MemoryUtil.memAddressSafe((IntBuffer)maximumAllocated));
    }

    public static String FSBank_ErrorString(@NativeType(value="FSBANK_RESULT") int result) {
        switch (result) {
            case 0: {
                return "No errors.";
            }
            case 1: {
                return "An expected chunk is missing from the cache, perhaps try deleting cache files.";
            }
            case 2: {
                return "The build process was cancelled during compilation by the user.";
            }
            case 3: {
                return "The build process cannot continue due to previously ignored errors.";
            }
            case 4: {
                return "Encoder for chosen format has encountered an unexpected error.";
            }
            case 5: {
                return "Encoder initialization failed.";
            }
            case 6: {
                return "Encoder for chosen format is not supported on this platform.";
            }
            case 7: {
                return "An operating system based file error was encountered.";
            }
            case 8: {
                return "A specified file could not be found.";
            }
            case 9: {
                return "Internal error from FMOD sub-system.";
            }
            case 10: {
                return "Already initialized.";
            }
            case 11: {
                return "The format of the source file is invalid.";
            }
            case 12: {
                return "An invalid parameter has been passed to this function.";
            }
            case 13: {
                return "Run out of memory.";
            }
            case 14: {
                return "Not initialized yet.";
            }
            case 15: {
                return "Chosen encode format is not supported by this FSB version.";
            }
            case 16: {
                return "Source file is too short for seamless looping. Looping disabled.";
            }
            case 17: {
                return "FSBANK_BUILD_FILTERHIGHFREQ flag ignored: feature only supported by XMA format.";
            }
            case 18: {
                return "FSBANK_BUILD_DISABLESEEKING flag ignored: feature only supported by XMA format.";
            }
            case 19: {
                return "FSBANK_BUILD_FSB5_DONTWRITENAMES flag forced: cannot write names when source is from memory.";
            }
            case 20: {
                return "External encoder dynamic library not found.";
            }
            case 21: {
                return "External encoder dynamic library could not be loaded, possibly incorrect binary format, incorrect architecture, or file corruption.";
            }
            case 22: {
                return "FSBANK_BUILD_ALIGN4K flag ignored: feature only supported by Opus, Vorbis, and FADPCM formats.";
            }
        }
        return "Unknown error.";
    }

    static /* synthetic */ SharedLibrary access$000() {
        return FSBANK;
    }

    static {
        FMOD.getLibrary();
        FSBANK = Library.loadNative(FSBank.class, (String)"org.lwjgl.fmod", (Configuration)Configuration.FMOD_FSBANK_LIBRARY_NAME, (String[])new String[]{"fsbank"});
    }

    public static final class Functions {
        public static final long MemoryInit = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_MemoryInit");
        public static final long Init = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_Init");
        public static final long Release = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_Release");
        public static final long Build = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_Build");
        public static final long FetchFSBMemory = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_FetchFSBMemory");
        public static final long BuildCancel = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_BuildCancel");
        public static final long FetchNextProgressItem = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_FetchNextProgressItem");
        public static final long ReleaseProgressItem = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_ReleaseProgressItem");
        public static final long MemoryGetStats = APIUtil.apiGetFunctionAddress((FunctionProvider)FSBank.access$000(), (String)"FSBank_MemoryGetStats");

        private Functions() {
        }
    }
}

