/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUtensorMap
extends Struct<CUtensorMap>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPAQUE;

    protected CUtensorMap(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUtensorMap create(long address, @Nullable ByteBuffer container) {
        return new CUtensorMap(address, container);
    }

    public CUtensorMap(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUtensorMap.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cuuint64_t[CU_TENSOR_MAP_NUM_QWORDS]")
    public LongBuffer opaque() {
        return CUtensorMap.nopaque(this.address());
    }

    @NativeType(value="cuuint64_t")
    public long opaque(int index) {
        return CUtensorMap.nopaque(this.address(), index);
    }

    public CUtensorMap opaque(@NativeType(value="cuuint64_t[CU_TENSOR_MAP_NUM_QWORDS]") LongBuffer value) {
        CUtensorMap.nopaque(this.address(), value);
        return this;
    }

    public CUtensorMap opaque(int index, @NativeType(value="cuuint64_t") long value) {
        CUtensorMap.nopaque(this.address(), index, value);
        return this;
    }

    public CUtensorMap set(CUtensorMap src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUtensorMap malloc() {
        return new CUtensorMap(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUtensorMap calloc() {
        return new CUtensorMap(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUtensorMap create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUtensorMap(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUtensorMap create(long address) {
        return new CUtensorMap(address, null);
    }

    public static @Nullable CUtensorMap createSafe(long address) {
        return address == 0L ? null : new CUtensorMap(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUtensorMap.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUtensorMap.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUtensorMap malloc(MemoryStack stack) {
        return new CUtensorMap(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUtensorMap calloc(MemoryStack stack) {
        return new CUtensorMap(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LongBuffer nopaque(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)OPAQUE), (int)16);
    }

    public static long nopaque(long struct, int index) {
        return MemoryUtil.memGetLong((long)(struct + (long)OPAQUE + Checks.check((int)index, (int)16) * 8L));
    }

    public static void nopaque(long struct, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((LongBuffer)value), (long)(struct + (long)OPAQUE), (long)(value.remaining() * 8));
    }

    public static void nopaque(long struct, int index, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)OPAQUE + Checks.check((int)index, (int)16) * 8L), (long)value);
    }

    static {
        Struct.Layout layout = CUtensorMap.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)64, (Struct.Member[])new Struct.Member[]{CUtensorMap.__array((int)8, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OPAQUE = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUtensorMap, Buffer>
    implements NativeResource {
        private static final CUtensorMap ELEMENT_FACTORY = CUtensorMap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUtensorMap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cuuint64_t[CU_TENSOR_MAP_NUM_QWORDS]")
        public LongBuffer opaque() {
            return CUtensorMap.nopaque(this.address());
        }

        @NativeType(value="cuuint64_t")
        public long opaque(int index) {
            return CUtensorMap.nopaque(this.address(), index);
        }

        public Buffer opaque(@NativeType(value="cuuint64_t[CU_TENSOR_MAP_NUM_QWORDS]") LongBuffer value) {
            CUtensorMap.nopaque(this.address(), value);
            return this;
        }

        public Buffer opaque(int index, @NativeType(value="cuuint64_t") long value) {
            CUtensorMap.nopaque(this.address(), index, value);
            return this;
        }
    }
}

