/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUaccessPolicyWindow;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUstreamAttrValue
extends Struct<CUstreamAttrValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACCESSPOLICYWINDOW;
    public static final int SYNCPOLICY;

    protected CUstreamAttrValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUstreamAttrValue create(long address, @Nullable ByteBuffer container) {
        return new CUstreamAttrValue(address, container);
    }

    public CUstreamAttrValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUstreamAttrValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public CUaccessPolicyWindow accessPolicyWindow() {
        return CUstreamAttrValue.naccessPolicyWindow(this.address());
    }

    @NativeType(value="CUsynchronizationPolicy")
    public int syncPolicy() {
        return CUstreamAttrValue.nsyncPolicy(this.address());
    }

    public CUstreamAttrValue accessPolicyWindow(CUaccessPolicyWindow value) {
        CUstreamAttrValue.naccessPolicyWindow(this.address(), value);
        return this;
    }

    public CUstreamAttrValue accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
        consumer.accept(this.accessPolicyWindow());
        return this;
    }

    public CUstreamAttrValue syncPolicy(@NativeType(value="CUsynchronizationPolicy") int value) {
        CUstreamAttrValue.nsyncPolicy(this.address(), value);
        return this;
    }

    public CUstreamAttrValue set(CUstreamAttrValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUstreamAttrValue malloc() {
        return new CUstreamAttrValue(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUstreamAttrValue calloc() {
        return new CUstreamAttrValue(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUstreamAttrValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUstreamAttrValue(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUstreamAttrValue create(long address) {
        return new CUstreamAttrValue(address, null);
    }

    public static @Nullable CUstreamAttrValue createSafe(long address) {
        return address == 0L ? null : new CUstreamAttrValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUstreamAttrValue.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUstreamAttrValue.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUstreamAttrValue malloc(MemoryStack stack) {
        return new CUstreamAttrValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUstreamAttrValue calloc(MemoryStack stack) {
        return new CUstreamAttrValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CUaccessPolicyWindow naccessPolicyWindow(long struct) {
        return CUaccessPolicyWindow.create(struct + (long)ACCESSPOLICYWINDOW);
    }

    public static int nsyncPolicy(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SYNCPOLICY));
    }

    public static void naccessPolicyWindow(long struct, CUaccessPolicyWindow value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACCESSPOLICYWINDOW), (long)CUaccessPolicyWindow.SIZEOF);
    }

    public static void nsyncPolicy(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SYNCPOLICY), (int)value);
    }

    static {
        Struct.Layout layout = CUstreamAttrValue.__union((Struct.Member[])new Struct.Member[]{CUstreamAttrValue.__member((int)CUaccessPolicyWindow.SIZEOF, (int)CUaccessPolicyWindow.ALIGNOF), CUstreamAttrValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACCESSPOLICYWINDOW = layout.offsetof(0);
        SYNCPOLICY = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUstreamAttrValue, Buffer>
    implements NativeResource {
        private static final CUstreamAttrValue ELEMENT_FACTORY = CUstreamAttrValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUstreamAttrValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CUaccessPolicyWindow accessPolicyWindow() {
            return CUstreamAttrValue.naccessPolicyWindow(this.address());
        }

        @NativeType(value="CUsynchronizationPolicy")
        public int syncPolicy() {
            return CUstreamAttrValue.nsyncPolicy(this.address());
        }

        public Buffer accessPolicyWindow(CUaccessPolicyWindow value) {
            CUstreamAttrValue.naccessPolicyWindow(this.address(), value);
            return this;
        }

        public Buffer accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
            consumer.accept(this.accessPolicyWindow());
            return this;
        }

        public Buffer syncPolicy(@NativeType(value="CUsynchronizationPolicy") int value) {
            CUstreamAttrValue.nsyncPolicy(this.address(), value);
            return this;
        }
    }
}

