/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUmemLocation;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemPoolProps
extends Struct<CUmemPoolProps>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCTYPE;
    public static final int HANDLETYPES;
    public static final int LOCATION;
    public static final int WIN32SECURITYATTRIBUTES;
    public static final int RESERVED;

    protected CUmemPoolProps(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUmemPoolProps create(long address, @Nullable ByteBuffer container) {
        return new CUmemPoolProps(address, container);
    }

    public CUmemPoolProps(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUmemPoolProps.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUmemAllocationType")
    public int allocType() {
        return CUmemPoolProps.nallocType(this.address());
    }

    @NativeType(value="CUmemAllocationHandleType")
    public int handleTypes() {
        return CUmemPoolProps.nhandleTypes(this.address());
    }

    public CUmemLocation location() {
        return CUmemPoolProps.nlocation(this.address());
    }

    @NativeType(value="void *")
    public long win32SecurityAttributes() {
        return CUmemPoolProps.nwin32SecurityAttributes(this.address());
    }

    @NativeType(value="unsigned char[64]")
    public ByteBuffer reserved() {
        return CUmemPoolProps.nreserved(this.address());
    }

    @NativeType(value="unsigned char")
    public byte reserved(int index) {
        return CUmemPoolProps.nreserved(this.address(), index);
    }

    public CUmemPoolProps allocType(@NativeType(value="CUmemAllocationType") int value) {
        CUmemPoolProps.nallocType(this.address(), value);
        return this;
    }

    public CUmemPoolProps handleTypes(@NativeType(value="CUmemAllocationHandleType") int value) {
        CUmemPoolProps.nhandleTypes(this.address(), value);
        return this;
    }

    public CUmemPoolProps location(CUmemLocation value) {
        CUmemPoolProps.nlocation(this.address(), value);
        return this;
    }

    public CUmemPoolProps location(Consumer<CUmemLocation> consumer) {
        consumer.accept(this.location());
        return this;
    }

    public CUmemPoolProps win32SecurityAttributes(@NativeType(value="void *") long value) {
        CUmemPoolProps.nwin32SecurityAttributes(this.address(), value);
        return this;
    }

    public CUmemPoolProps reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
        CUmemPoolProps.nreserved(this.address(), value);
        return this;
    }

    public CUmemPoolProps reserved(int index, @NativeType(value="unsigned char") byte value) {
        CUmemPoolProps.nreserved(this.address(), index, value);
        return this;
    }

    public CUmemPoolProps set(int allocType, int handleTypes, CUmemLocation location, long win32SecurityAttributes, ByteBuffer reserved) {
        this.allocType(allocType);
        this.handleTypes(handleTypes);
        this.location(location);
        this.win32SecurityAttributes(win32SecurityAttributes);
        this.reserved(reserved);
        return this;
    }

    public CUmemPoolProps set(CUmemPoolProps src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUmemPoolProps malloc() {
        return new CUmemPoolProps(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUmemPoolProps calloc() {
        return new CUmemPoolProps(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUmemPoolProps create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUmemPoolProps(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUmemPoolProps create(long address) {
        return new CUmemPoolProps(address, null);
    }

    public static @Nullable CUmemPoolProps createSafe(long address) {
        return address == 0L ? null : new CUmemPoolProps(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUmemPoolProps.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemPoolProps.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUmemPoolProps malloc(MemoryStack stack) {
        return new CUmemPoolProps(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUmemPoolProps calloc(MemoryStack stack) {
        return new CUmemPoolProps(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nallocType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ALLOCTYPE));
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HANDLETYPES));
    }

    public static CUmemLocation nlocation(long struct) {
        return CUmemLocation.create(struct + (long)LOCATION);
    }

    public static long nwin32SecurityAttributes(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WIN32SECURITYATTRIBUTES));
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED), (int)64);
    }

    public static byte nreserved(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED + Checks.check((int)index, (int)64) * 1L));
    }

    public static void nallocType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ALLOCTYPE), (int)value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HANDLETYPES), (int)value);
    }

    public static void nlocation(long struct, CUmemLocation value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LOCATION), (long)CUmemLocation.SIZEOF);
    }

    public static void nwin32SecurityAttributes(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WIN32SECURITYATTRIBUTES), (long)value);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 1));
    }

    public static void nreserved(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED + Checks.check((int)index, (int)64) * 1L), (byte)value);
    }

    static {
        Struct.Layout layout = CUmemPoolProps.__struct((Struct.Member[])new Struct.Member[]{CUmemPoolProps.__member((int)4), CUmemPoolProps.__member((int)4), CUmemPoolProps.__member((int)CUmemLocation.SIZEOF, (int)CUmemLocation.ALIGNOF), CUmemPoolProps.__member((int)POINTER_SIZE), CUmemPoolProps.__array((int)1, (int)64)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCTYPE = layout.offsetof(0);
        HANDLETYPES = layout.offsetof(1);
        LOCATION = layout.offsetof(2);
        WIN32SECURITYATTRIBUTES = layout.offsetof(3);
        RESERVED = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<CUmemPoolProps, Buffer>
    implements NativeResource {
        private static final CUmemPoolProps ELEMENT_FACTORY = CUmemPoolProps.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUmemPoolProps getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUmemAllocationType")
        public int allocType() {
            return CUmemPoolProps.nallocType(this.address());
        }

        @NativeType(value="CUmemAllocationHandleType")
        public int handleTypes() {
            return CUmemPoolProps.nhandleTypes(this.address());
        }

        public CUmemLocation location() {
            return CUmemPoolProps.nlocation(this.address());
        }

        @NativeType(value="void *")
        public long win32SecurityAttributes() {
            return CUmemPoolProps.nwin32SecurityAttributes(this.address());
        }

        @NativeType(value="unsigned char[64]")
        public ByteBuffer reserved() {
            return CUmemPoolProps.nreserved(this.address());
        }

        @NativeType(value="unsigned char")
        public byte reserved(int index) {
            return CUmemPoolProps.nreserved(this.address(), index);
        }

        public Buffer allocType(@NativeType(value="CUmemAllocationType") int value) {
            CUmemPoolProps.nallocType(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="CUmemAllocationHandleType") int value) {
            CUmemPoolProps.nhandleTypes(this.address(), value);
            return this;
        }

        public Buffer location(CUmemLocation value) {
            CUmemPoolProps.nlocation(this.address(), value);
            return this;
        }

        public Buffer location(Consumer<CUmemLocation> consumer) {
            consumer.accept(this.location());
            return this;
        }

        public Buffer win32SecurityAttributes(@NativeType(value="void *") long value) {
            CUmemPoolProps.nwin32SecurityAttributes(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
            CUmemPoolProps.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned char") byte value) {
            CUmemPoolProps.nreserved(this.address(), index, value);
            return this;
        }
    }
}

