/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUmemLocation;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemAllocationProp
extends Struct<CUmemAllocationProp>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int REQUESTEDHANDLETYPES;
    public static final int LOCATION;
    public static final int WIN32HANDLEMETADATA;
    public static final int ALLOCFLAGS;
    public static final int ALLOCFLAGS_COMPRESSIONTYPE;
    public static final int ALLOCFLAGS_GPUDIRECTRDMACAPABLE;
    public static final int ALLOCFLAGS_USAGE;
    public static final int ALLOCFLAGS_RESERVED;

    protected CUmemAllocationProp(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUmemAllocationProp create(long address, @Nullable ByteBuffer container) {
        return new CUmemAllocationProp(address, container);
    }

    public CUmemAllocationProp(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUmemAllocationProp.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUmemAllocationType")
    public int type() {
        return CUmemAllocationProp.ntype(this.address());
    }

    @NativeType(value="CUmemAllocationHandleType")
    public int requestedHandleTypes() {
        return CUmemAllocationProp.nrequestedHandleTypes(this.address());
    }

    public CUmemLocation location() {
        return CUmemAllocationProp.nlocation(this.address());
    }

    @NativeType(value="void *")
    public long win32HandleMetaData() {
        return CUmemAllocationProp.nwin32HandleMetaData(this.address());
    }

    @NativeType(value="unsigned char")
    public byte allocFlags_compressionType() {
        return CUmemAllocationProp.nallocFlags_compressionType(this.address());
    }

    @NativeType(value="unsigned char")
    public byte allocFlags_gpuDirectRDMACapable() {
        return CUmemAllocationProp.nallocFlags_gpuDirectRDMACapable(this.address());
    }

    @NativeType(value="unsigned short")
    public short allocFlags_usage() {
        return CUmemAllocationProp.nallocFlags_usage(this.address());
    }

    @NativeType(value="unsigned char[4]")
    public ByteBuffer allocFlags_reserved() {
        return CUmemAllocationProp.nallocFlags_reserved(this.address());
    }

    @NativeType(value="unsigned char")
    public byte allocFlags_reserved(int index) {
        return CUmemAllocationProp.nallocFlags_reserved(this.address(), index);
    }

    public CUmemAllocationProp type(@NativeType(value="CUmemAllocationType") int value) {
        CUmemAllocationProp.ntype(this.address(), value);
        return this;
    }

    public CUmemAllocationProp requestedHandleTypes(@NativeType(value="CUmemAllocationHandleType") int value) {
        CUmemAllocationProp.nrequestedHandleTypes(this.address(), value);
        return this;
    }

    public CUmemAllocationProp location(CUmemLocation value) {
        CUmemAllocationProp.nlocation(this.address(), value);
        return this;
    }

    public CUmemAllocationProp location(Consumer<CUmemLocation> consumer) {
        consumer.accept(this.location());
        return this;
    }

    public CUmemAllocationProp win32HandleMetaData(@NativeType(value="void *") long value) {
        CUmemAllocationProp.nwin32HandleMetaData(this.address(), value);
        return this;
    }

    public CUmemAllocationProp allocFlags_compressionType(@NativeType(value="unsigned char") byte value) {
        CUmemAllocationProp.nallocFlags_compressionType(this.address(), value);
        return this;
    }

    public CUmemAllocationProp allocFlags_gpuDirectRDMACapable(@NativeType(value="unsigned char") byte value) {
        CUmemAllocationProp.nallocFlags_gpuDirectRDMACapable(this.address(), value);
        return this;
    }

    public CUmemAllocationProp allocFlags_usage(@NativeType(value="unsigned short") short value) {
        CUmemAllocationProp.nallocFlags_usage(this.address(), value);
        return this;
    }

    public CUmemAllocationProp allocFlags_reserved(@NativeType(value="unsigned char[4]") ByteBuffer value) {
        CUmemAllocationProp.nallocFlags_reserved(this.address(), value);
        return this;
    }

    public CUmemAllocationProp allocFlags_reserved(int index, @NativeType(value="unsigned char") byte value) {
        CUmemAllocationProp.nallocFlags_reserved(this.address(), index, value);
        return this;
    }

    public CUmemAllocationProp set(int type, int requestedHandleTypes, CUmemLocation location, long win32HandleMetaData, byte allocFlags_compressionType, byte allocFlags_gpuDirectRDMACapable, short allocFlags_usage, ByteBuffer allocFlags_reserved) {
        this.type(type);
        this.requestedHandleTypes(requestedHandleTypes);
        this.location(location);
        this.win32HandleMetaData(win32HandleMetaData);
        this.allocFlags_compressionType(allocFlags_compressionType);
        this.allocFlags_gpuDirectRDMACapable(allocFlags_gpuDirectRDMACapable);
        this.allocFlags_usage(allocFlags_usage);
        this.allocFlags_reserved(allocFlags_reserved);
        return this;
    }

    public CUmemAllocationProp set(CUmemAllocationProp src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUmemAllocationProp malloc() {
        return new CUmemAllocationProp(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUmemAllocationProp calloc() {
        return new CUmemAllocationProp(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUmemAllocationProp create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUmemAllocationProp(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUmemAllocationProp create(long address) {
        return new CUmemAllocationProp(address, null);
    }

    public static @Nullable CUmemAllocationProp createSafe(long address) {
        return address == 0L ? null : new CUmemAllocationProp(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUmemAllocationProp.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemAllocationProp.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUmemAllocationProp malloc(MemoryStack stack) {
        return new CUmemAllocationProp(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUmemAllocationProp calloc(MemoryStack stack) {
        return new CUmemAllocationProp(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nrequestedHandleTypes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REQUESTEDHANDLETYPES));
    }

    public static CUmemLocation nlocation(long struct) {
        return CUmemLocation.create(struct + (long)LOCATION);
    }

    public static long nwin32HandleMetaData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WIN32HANDLEMETADATA));
    }

    public static byte nallocFlags_compressionType(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ALLOCFLAGS_COMPRESSIONTYPE));
    }

    public static byte nallocFlags_gpuDirectRDMACapable(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ALLOCFLAGS_GPUDIRECTRDMACAPABLE));
    }

    public static short nallocFlags_usage(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)ALLOCFLAGS_USAGE));
    }

    public static ByteBuffer nallocFlags_reserved(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)ALLOCFLAGS_RESERVED), (int)4);
    }

    public static byte nallocFlags_reserved(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)ALLOCFLAGS_RESERVED + Checks.check((int)index, (int)4) * 1L));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nrequestedHandleTypes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REQUESTEDHANDLETYPES), (int)value);
    }

    public static void nlocation(long struct, CUmemLocation value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LOCATION), (long)CUmemLocation.SIZEOF);
    }

    public static void nwin32HandleMetaData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WIN32HANDLEMETADATA), (long)value);
    }

    public static void nallocFlags_compressionType(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)ALLOCFLAGS_COMPRESSIONTYPE), (byte)value);
    }

    public static void nallocFlags_gpuDirectRDMACapable(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)ALLOCFLAGS_GPUDIRECTRDMACAPABLE), (byte)value);
    }

    public static void nallocFlags_usage(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)ALLOCFLAGS_USAGE), (short)value);
    }

    public static void nallocFlags_reserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)ALLOCFLAGS_RESERVED), (long)(value.remaining() * 1));
    }

    public static void nallocFlags_reserved(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)ALLOCFLAGS_RESERVED + Checks.check((int)index, (int)4) * 1L), (byte)value);
    }

    static {
        Struct.Layout layout = CUmemAllocationProp.__struct((Struct.Member[])new Struct.Member[]{CUmemAllocationProp.__member((int)4), CUmemAllocationProp.__member((int)4), CUmemAllocationProp.__member((int)CUmemLocation.SIZEOF, (int)CUmemLocation.ALIGNOF), CUmemAllocationProp.__member((int)POINTER_SIZE), CUmemAllocationProp.__struct((Struct.Member[])new Struct.Member[]{CUmemAllocationProp.__member((int)1), CUmemAllocationProp.__member((int)1), CUmemAllocationProp.__member((int)2), CUmemAllocationProp.__array((int)1, (int)4)})});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        REQUESTEDHANDLETYPES = layout.offsetof(1);
        LOCATION = layout.offsetof(2);
        WIN32HANDLEMETADATA = layout.offsetof(3);
        ALLOCFLAGS = layout.offsetof(4);
        ALLOCFLAGS_COMPRESSIONTYPE = layout.offsetof(5);
        ALLOCFLAGS_GPUDIRECTRDMACAPABLE = layout.offsetof(6);
        ALLOCFLAGS_USAGE = layout.offsetof(7);
        ALLOCFLAGS_RESERVED = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<CUmemAllocationProp, Buffer>
    implements NativeResource {
        private static final CUmemAllocationProp ELEMENT_FACTORY = CUmemAllocationProp.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUmemAllocationProp getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUmemAllocationType")
        public int type() {
            return CUmemAllocationProp.ntype(this.address());
        }

        @NativeType(value="CUmemAllocationHandleType")
        public int requestedHandleTypes() {
            return CUmemAllocationProp.nrequestedHandleTypes(this.address());
        }

        public CUmemLocation location() {
            return CUmemAllocationProp.nlocation(this.address());
        }

        @NativeType(value="void *")
        public long win32HandleMetaData() {
            return CUmemAllocationProp.nwin32HandleMetaData(this.address());
        }

        @NativeType(value="unsigned char")
        public byte allocFlags_compressionType() {
            return CUmemAllocationProp.nallocFlags_compressionType(this.address());
        }

        @NativeType(value="unsigned char")
        public byte allocFlags_gpuDirectRDMACapable() {
            return CUmemAllocationProp.nallocFlags_gpuDirectRDMACapable(this.address());
        }

        @NativeType(value="unsigned short")
        public short allocFlags_usage() {
            return CUmemAllocationProp.nallocFlags_usage(this.address());
        }

        @NativeType(value="unsigned char[4]")
        public ByteBuffer allocFlags_reserved() {
            return CUmemAllocationProp.nallocFlags_reserved(this.address());
        }

        @NativeType(value="unsigned char")
        public byte allocFlags_reserved(int index) {
            return CUmemAllocationProp.nallocFlags_reserved(this.address(), index);
        }

        public Buffer type(@NativeType(value="CUmemAllocationType") int value) {
            CUmemAllocationProp.ntype(this.address(), value);
            return this;
        }

        public Buffer requestedHandleTypes(@NativeType(value="CUmemAllocationHandleType") int value) {
            CUmemAllocationProp.nrequestedHandleTypes(this.address(), value);
            return this;
        }

        public Buffer location(CUmemLocation value) {
            CUmemAllocationProp.nlocation(this.address(), value);
            return this;
        }

        public Buffer location(Consumer<CUmemLocation> consumer) {
            consumer.accept(this.location());
            return this;
        }

        public Buffer win32HandleMetaData(@NativeType(value="void *") long value) {
            CUmemAllocationProp.nwin32HandleMetaData(this.address(), value);
            return this;
        }

        public Buffer allocFlags_compressionType(@NativeType(value="unsigned char") byte value) {
            CUmemAllocationProp.nallocFlags_compressionType(this.address(), value);
            return this;
        }

        public Buffer allocFlags_gpuDirectRDMACapable(@NativeType(value="unsigned char") byte value) {
            CUmemAllocationProp.nallocFlags_gpuDirectRDMACapable(this.address(), value);
            return this;
        }

        public Buffer allocFlags_usage(@NativeType(value="unsigned short") short value) {
            CUmemAllocationProp.nallocFlags_usage(this.address(), value);
            return this;
        }

        public Buffer allocFlags_reserved(@NativeType(value="unsigned char[4]") ByteBuffer value) {
            CUmemAllocationProp.nallocFlags_reserved(this.address(), value);
            return this;
        }

        public Buffer allocFlags_reserved(int index, @NativeType(value="unsigned char") byte value) {
            CUmemAllocationProp.nallocFlags_reserved(this.address(), index, value);
            return this;
        }
    }
}

