/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUaccessPolicyWindow;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUkernelNodeAttrValue
extends Struct<CUkernelNodeAttrValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACCESSPOLICYWINDOW;
    public static final int COOPERATIVE;

    protected CUkernelNodeAttrValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUkernelNodeAttrValue create(long address, @Nullable ByteBuffer container) {
        return new CUkernelNodeAttrValue(address, container);
    }

    public CUkernelNodeAttrValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUkernelNodeAttrValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public CUaccessPolicyWindow accessPolicyWindow() {
        return CUkernelNodeAttrValue.naccessPolicyWindow(this.address());
    }

    public int cooperative() {
        return CUkernelNodeAttrValue.ncooperative(this.address());
    }

    public CUkernelNodeAttrValue accessPolicyWindow(CUaccessPolicyWindow value) {
        CUkernelNodeAttrValue.naccessPolicyWindow(this.address(), value);
        return this;
    }

    public CUkernelNodeAttrValue accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
        consumer.accept(this.accessPolicyWindow());
        return this;
    }

    public CUkernelNodeAttrValue cooperative(int value) {
        CUkernelNodeAttrValue.ncooperative(this.address(), value);
        return this;
    }

    public CUkernelNodeAttrValue set(CUkernelNodeAttrValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUkernelNodeAttrValue malloc() {
        return new CUkernelNodeAttrValue(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUkernelNodeAttrValue calloc() {
        return new CUkernelNodeAttrValue(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUkernelNodeAttrValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUkernelNodeAttrValue(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUkernelNodeAttrValue create(long address) {
        return new CUkernelNodeAttrValue(address, null);
    }

    public static @Nullable CUkernelNodeAttrValue createSafe(long address) {
        return address == 0L ? null : new CUkernelNodeAttrValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUkernelNodeAttrValue.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUkernelNodeAttrValue.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUkernelNodeAttrValue malloc(MemoryStack stack) {
        return new CUkernelNodeAttrValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUkernelNodeAttrValue calloc(MemoryStack stack) {
        return new CUkernelNodeAttrValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CUaccessPolicyWindow naccessPolicyWindow(long struct) {
        return CUaccessPolicyWindow.create(struct + (long)ACCESSPOLICYWINDOW);
    }

    public static int ncooperative(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COOPERATIVE));
    }

    public static void naccessPolicyWindow(long struct, CUaccessPolicyWindow value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACCESSPOLICYWINDOW), (long)CUaccessPolicyWindow.SIZEOF);
    }

    public static void ncooperative(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COOPERATIVE), (int)value);
    }

    static {
        Struct.Layout layout = CUkernelNodeAttrValue.__union((Struct.Member[])new Struct.Member[]{CUkernelNodeAttrValue.__member((int)CUaccessPolicyWindow.SIZEOF, (int)CUaccessPolicyWindow.ALIGNOF), CUkernelNodeAttrValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACCESSPOLICYWINDOW = layout.offsetof(0);
        COOPERATIVE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUkernelNodeAttrValue, Buffer>
    implements NativeResource {
        private static final CUkernelNodeAttrValue ELEMENT_FACTORY = CUkernelNodeAttrValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUkernelNodeAttrValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CUaccessPolicyWindow accessPolicyWindow() {
            return CUkernelNodeAttrValue.naccessPolicyWindow(this.address());
        }

        public int cooperative() {
            return CUkernelNodeAttrValue.ncooperative(this.address());
        }

        public Buffer accessPolicyWindow(CUaccessPolicyWindow value) {
            CUkernelNodeAttrValue.naccessPolicyWindow(this.address(), value);
            return this;
        }

        public Buffer accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
            consumer.accept(this.accessPolicyWindow());
            return this;
        }

        public Buffer cooperative(int value) {
            CUkernelNodeAttrValue.ncooperative(this.address(), value);
            return this;
        }
    }
}

