/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUDA_BATCH_MEM_OP_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_CHILD_GRAPH_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_CONDITIONAL_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_EVENT_RECORD_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_EVENT_WAIT_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2;
import org.lwjgl.cuda.CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2;
import org.lwjgl.cuda.CUDA_HOST_NODE_PARAMS_v2;
import org.lwjgl.cuda.CUDA_KERNEL_NODE_PARAMS_v3;
import org.lwjgl.cuda.CUDA_MEMCPY_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_MEMSET_NODE_PARAMS_v2;
import org.lwjgl.cuda.CUDA_MEM_ALLOC_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_MEM_FREE_NODE_PARAMS;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUgraphNodeParams
extends Struct<CUgraphNodeParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED0;
    public static final int PARAMS;
    public static final int PARAMS_RESERVED1;
    public static final int PARAMS_KERNEL;
    public static final int PARAMS_MEMCPY;
    public static final int PARAMS_MEMSET;
    public static final int PARAMS_HOST;
    public static final int PARAMS_GRAPH;
    public static final int PARAMS_EVENTWAIT;
    public static final int PARAMS_EVENTRECORD;
    public static final int PARAMS_EXTSEMSIGNAL;
    public static final int PARAMS_EXTSEMWAIT;
    public static final int PARAMS_ALLOC;
    public static final int PARAMS_FREE;
    public static final int PARAMS_MEMOP;
    public static final int PARAMS_CONDITIONAL;
    public static final int RESERVED2;

    protected CUgraphNodeParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUgraphNodeParams create(long address, @Nullable ByteBuffer container) {
        return new CUgraphNodeParams(address, container);
    }

    public CUgraphNodeParams(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUgraphNodeParams.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUgraphNodeType")
    public int type() {
        return CUgraphNodeParams.ntype(this.address());
    }

    @NativeType(value="long long[29]")
    public LongBuffer params_reserved1() {
        return CUgraphNodeParams.nparams_reserved1(this.address());
    }

    @NativeType(value="long long")
    public long params_reserved1(int index) {
        return CUgraphNodeParams.nparams_reserved1(this.address(), index);
    }

    public CUDA_KERNEL_NODE_PARAMS_v3 params_kernel() {
        return CUgraphNodeParams.nparams_kernel(this.address());
    }

    public CUDA_MEMCPY_NODE_PARAMS params_memcpy() {
        return CUgraphNodeParams.nparams_memcpy(this.address());
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 params_memset() {
        return CUgraphNodeParams.nparams_memset(this.address());
    }

    public CUDA_HOST_NODE_PARAMS_v2 params_host() {
        return CUgraphNodeParams.nparams_host(this.address());
    }

    public CUDA_CHILD_GRAPH_NODE_PARAMS params_graph() {
        return CUgraphNodeParams.nparams_graph(this.address());
    }

    public CUDA_EVENT_WAIT_NODE_PARAMS params_eventWait() {
        return CUgraphNodeParams.nparams_eventWait(this.address());
    }

    public CUDA_EVENT_RECORD_NODE_PARAMS params_eventRecord() {
        return CUgraphNodeParams.nparams_eventRecord(this.address());
    }

    public CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2 params_extSemSignal() {
        return CUgraphNodeParams.nparams_extSemSignal(this.address());
    }

    public CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2 params_extSemWait() {
        return CUgraphNodeParams.nparams_extSemWait(this.address());
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS params_alloc() {
        return CUgraphNodeParams.nparams_alloc(this.address());
    }

    public CUDA_MEM_FREE_NODE_PARAMS params_free() {
        return CUgraphNodeParams.nparams_free(this.address());
    }

    public CUDA_BATCH_MEM_OP_NODE_PARAMS params_memOp() {
        return CUgraphNodeParams.nparams_memOp(this.address());
    }

    public CUDA_CONDITIONAL_NODE_PARAMS params_conditional() {
        return CUgraphNodeParams.nparams_conditional(this.address());
    }

    public CUgraphNodeParams type(@NativeType(value="CUgraphNodeType") int value) {
        CUgraphNodeParams.ntype(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_reserved1(@NativeType(value="long long[29]") LongBuffer value) {
        CUgraphNodeParams.nparams_reserved1(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_reserved1(int index, @NativeType(value="long long") long value) {
        CUgraphNodeParams.nparams_reserved1(this.address(), index, value);
        return this;
    }

    public CUgraphNodeParams params_kernel(CUDA_KERNEL_NODE_PARAMS_v3 value) {
        CUgraphNodeParams.nparams_kernel(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_kernel(Consumer<CUDA_KERNEL_NODE_PARAMS_v3> consumer) {
        consumer.accept(this.params_kernel());
        return this;
    }

    public CUgraphNodeParams params_memcpy(CUDA_MEMCPY_NODE_PARAMS value) {
        CUgraphNodeParams.nparams_memcpy(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_memcpy(Consumer<CUDA_MEMCPY_NODE_PARAMS> consumer) {
        consumer.accept(this.params_memcpy());
        return this;
    }

    public CUgraphNodeParams params_memset(CUDA_MEMSET_NODE_PARAMS_v2 value) {
        CUgraphNodeParams.nparams_memset(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_memset(Consumer<CUDA_MEMSET_NODE_PARAMS_v2> consumer) {
        consumer.accept(this.params_memset());
        return this;
    }

    public CUgraphNodeParams params_host(CUDA_HOST_NODE_PARAMS_v2 value) {
        CUgraphNodeParams.nparams_host(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_host(Consumer<CUDA_HOST_NODE_PARAMS_v2> consumer) {
        consumer.accept(this.params_host());
        return this;
    }

    public CUgraphNodeParams params_graph(CUDA_CHILD_GRAPH_NODE_PARAMS value) {
        CUgraphNodeParams.nparams_graph(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_graph(Consumer<CUDA_CHILD_GRAPH_NODE_PARAMS> consumer) {
        consumer.accept(this.params_graph());
        return this;
    }

    public CUgraphNodeParams params_eventWait(CUDA_EVENT_WAIT_NODE_PARAMS value) {
        CUgraphNodeParams.nparams_eventWait(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_eventWait(Consumer<CUDA_EVENT_WAIT_NODE_PARAMS> consumer) {
        consumer.accept(this.params_eventWait());
        return this;
    }

    public CUgraphNodeParams params_eventRecord(CUDA_EVENT_RECORD_NODE_PARAMS value) {
        CUgraphNodeParams.nparams_eventRecord(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_eventRecord(Consumer<CUDA_EVENT_RECORD_NODE_PARAMS> consumer) {
        consumer.accept(this.params_eventRecord());
        return this;
    }

    public CUgraphNodeParams params_extSemSignal(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2 value) {
        CUgraphNodeParams.nparams_extSemSignal(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_extSemSignal(Consumer<CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2> consumer) {
        consumer.accept(this.params_extSemSignal());
        return this;
    }

    public CUgraphNodeParams params_extSemWait(CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2 value) {
        CUgraphNodeParams.nparams_extSemWait(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_extSemWait(Consumer<CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2> consumer) {
        consumer.accept(this.params_extSemWait());
        return this;
    }

    public CUgraphNodeParams params_alloc(CUDA_MEM_ALLOC_NODE_PARAMS value) {
        CUgraphNodeParams.nparams_alloc(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_alloc(Consumer<CUDA_MEM_ALLOC_NODE_PARAMS> consumer) {
        consumer.accept(this.params_alloc());
        return this;
    }

    public CUgraphNodeParams params_free(CUDA_MEM_FREE_NODE_PARAMS value) {
        CUgraphNodeParams.nparams_free(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_free(Consumer<CUDA_MEM_FREE_NODE_PARAMS> consumer) {
        consumer.accept(this.params_free());
        return this;
    }

    public CUgraphNodeParams params_memOp(CUDA_BATCH_MEM_OP_NODE_PARAMS value) {
        CUgraphNodeParams.nparams_memOp(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_memOp(Consumer<CUDA_BATCH_MEM_OP_NODE_PARAMS> consumer) {
        consumer.accept(this.params_memOp());
        return this;
    }

    public CUgraphNodeParams params_conditional(CUDA_CONDITIONAL_NODE_PARAMS value) {
        CUgraphNodeParams.nparams_conditional(this.address(), value);
        return this;
    }

    public CUgraphNodeParams params_conditional(Consumer<CUDA_CONDITIONAL_NODE_PARAMS> consumer) {
        consumer.accept(this.params_conditional());
        return this;
    }

    public CUgraphNodeParams set(CUgraphNodeParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUgraphNodeParams malloc() {
        return new CUgraphNodeParams(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUgraphNodeParams calloc() {
        return new CUgraphNodeParams(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUgraphNodeParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUgraphNodeParams(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUgraphNodeParams create(long address) {
        return new CUgraphNodeParams(address, null);
    }

    public static @Nullable CUgraphNodeParams createSafe(long address) {
        return address == 0L ? null : new CUgraphNodeParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUgraphNodeParams.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUgraphNodeParams.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUgraphNodeParams malloc(MemoryStack stack) {
        return new CUgraphNodeParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUgraphNodeParams calloc(MemoryStack stack) {
        return new CUgraphNodeParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static IntBuffer nreserved0(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED0), (int)3);
    }

    public static int nreserved0(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED0 + Checks.check((int)index, (int)3) * 4L));
    }

    public static LongBuffer nparams_reserved1(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)PARAMS_RESERVED1), (int)29);
    }

    public static long nparams_reserved1(long struct, int index) {
        return MemoryUtil.memGetLong((long)(struct + (long)PARAMS_RESERVED1 + Checks.check((int)index, (int)29) * 8L));
    }

    public static CUDA_KERNEL_NODE_PARAMS_v3 nparams_kernel(long struct) {
        return CUDA_KERNEL_NODE_PARAMS_v3.create(struct + (long)PARAMS_KERNEL);
    }

    public static CUDA_MEMCPY_NODE_PARAMS nparams_memcpy(long struct) {
        return CUDA_MEMCPY_NODE_PARAMS.create(struct + (long)PARAMS_MEMCPY);
    }

    public static CUDA_MEMSET_NODE_PARAMS_v2 nparams_memset(long struct) {
        return CUDA_MEMSET_NODE_PARAMS_v2.create(struct + (long)PARAMS_MEMSET);
    }

    public static CUDA_HOST_NODE_PARAMS_v2 nparams_host(long struct) {
        return CUDA_HOST_NODE_PARAMS_v2.create(struct + (long)PARAMS_HOST);
    }

    public static CUDA_CHILD_GRAPH_NODE_PARAMS nparams_graph(long struct) {
        return CUDA_CHILD_GRAPH_NODE_PARAMS.create(struct + (long)PARAMS_GRAPH);
    }

    public static CUDA_EVENT_WAIT_NODE_PARAMS nparams_eventWait(long struct) {
        return CUDA_EVENT_WAIT_NODE_PARAMS.create(struct + (long)PARAMS_EVENTWAIT);
    }

    public static CUDA_EVENT_RECORD_NODE_PARAMS nparams_eventRecord(long struct) {
        return CUDA_EVENT_RECORD_NODE_PARAMS.create(struct + (long)PARAMS_EVENTRECORD);
    }

    public static CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2 nparams_extSemSignal(long struct) {
        return CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2.create(struct + (long)PARAMS_EXTSEMSIGNAL);
    }

    public static CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2 nparams_extSemWait(long struct) {
        return CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2.create(struct + (long)PARAMS_EXTSEMWAIT);
    }

    public static CUDA_MEM_ALLOC_NODE_PARAMS nparams_alloc(long struct) {
        return CUDA_MEM_ALLOC_NODE_PARAMS.create(struct + (long)PARAMS_ALLOC);
    }

    public static CUDA_MEM_FREE_NODE_PARAMS nparams_free(long struct) {
        return CUDA_MEM_FREE_NODE_PARAMS.create(struct + (long)PARAMS_FREE);
    }

    public static CUDA_BATCH_MEM_OP_NODE_PARAMS nparams_memOp(long struct) {
        return CUDA_BATCH_MEM_OP_NODE_PARAMS.create(struct + (long)PARAMS_MEMOP);
    }

    public static CUDA_CONDITIONAL_NODE_PARAMS nparams_conditional(long struct) {
        return CUDA_CONDITIONAL_NODE_PARAMS.create(struct + (long)PARAMS_CONDITIONAL);
    }

    public static long nreserved2(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)RESERVED2));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nreserved0(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)RESERVED0), (long)(value.remaining() * 4));
    }

    public static void nreserved0(long struct, int index, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED0 + Checks.check((int)index, (int)3) * 4L), (int)value);
    }

    public static void nparams_reserved1(long struct, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)29);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((LongBuffer)value), (long)(struct + (long)PARAMS_RESERVED1), (long)(value.remaining() * 8));
    }

    public static void nparams_reserved1(long struct, int index, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)PARAMS_RESERVED1 + Checks.check((int)index, (int)29) * 8L), (long)value);
    }

    public static void nparams_kernel(long struct, CUDA_KERNEL_NODE_PARAMS_v3 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_KERNEL), (long)CUDA_KERNEL_NODE_PARAMS_v3.SIZEOF);
    }

    public static void nparams_memcpy(long struct, CUDA_MEMCPY_NODE_PARAMS value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_MEMCPY), (long)CUDA_MEMCPY_NODE_PARAMS.SIZEOF);
    }

    public static void nparams_memset(long struct, CUDA_MEMSET_NODE_PARAMS_v2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_MEMSET), (long)CUDA_MEMSET_NODE_PARAMS_v2.SIZEOF);
    }

    public static void nparams_host(long struct, CUDA_HOST_NODE_PARAMS_v2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_HOST), (long)CUDA_HOST_NODE_PARAMS_v2.SIZEOF);
    }

    public static void nparams_graph(long struct, CUDA_CHILD_GRAPH_NODE_PARAMS value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_GRAPH), (long)CUDA_CHILD_GRAPH_NODE_PARAMS.SIZEOF);
    }

    public static void nparams_eventWait(long struct, CUDA_EVENT_WAIT_NODE_PARAMS value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_EVENTWAIT), (long)CUDA_EVENT_WAIT_NODE_PARAMS.SIZEOF);
    }

    public static void nparams_eventRecord(long struct, CUDA_EVENT_RECORD_NODE_PARAMS value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_EVENTRECORD), (long)CUDA_EVENT_RECORD_NODE_PARAMS.SIZEOF);
    }

    public static void nparams_extSemSignal(long struct, CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_EXTSEMSIGNAL), (long)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2.SIZEOF);
    }

    public static void nparams_extSemWait(long struct, CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_EXTSEMWAIT), (long)CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2.SIZEOF);
    }

    public static void nparams_alloc(long struct, CUDA_MEM_ALLOC_NODE_PARAMS value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_ALLOC), (long)CUDA_MEM_ALLOC_NODE_PARAMS.SIZEOF);
    }

    public static void nparams_free(long struct, CUDA_MEM_FREE_NODE_PARAMS value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_FREE), (long)CUDA_MEM_FREE_NODE_PARAMS.SIZEOF);
    }

    public static void nparams_memOp(long struct, CUDA_BATCH_MEM_OP_NODE_PARAMS value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_MEMOP), (long)CUDA_BATCH_MEM_OP_NODE_PARAMS.SIZEOF);
    }

    public static void nparams_conditional(long struct, CUDA_CONDITIONAL_NODE_PARAMS value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMS_CONDITIONAL), (long)CUDA_CONDITIONAL_NODE_PARAMS.SIZEOF);
    }

    public static void nreserved2(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)RESERVED2), (long)value);
    }

    static {
        Struct.Layout layout = CUgraphNodeParams.__struct((Struct.Member[])new Struct.Member[]{CUgraphNodeParams.__member((int)4), CUgraphNodeParams.__array((int)4, (int)3), CUgraphNodeParams.__union((Struct.Member[])new Struct.Member[]{CUgraphNodeParams.__array((int)8, (int)29), CUgraphNodeParams.__member((int)CUDA_KERNEL_NODE_PARAMS_v3.SIZEOF, (int)CUDA_KERNEL_NODE_PARAMS_v3.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_MEMCPY_NODE_PARAMS.SIZEOF, (int)CUDA_MEMCPY_NODE_PARAMS.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_MEMSET_NODE_PARAMS_v2.SIZEOF, (int)CUDA_MEMSET_NODE_PARAMS_v2.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_HOST_NODE_PARAMS_v2.SIZEOF, (int)CUDA_HOST_NODE_PARAMS_v2.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_CHILD_GRAPH_NODE_PARAMS.SIZEOF, (int)CUDA_CHILD_GRAPH_NODE_PARAMS.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_EVENT_WAIT_NODE_PARAMS.SIZEOF, (int)CUDA_EVENT_WAIT_NODE_PARAMS.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_EVENT_RECORD_NODE_PARAMS.SIZEOF, (int)CUDA_EVENT_RECORD_NODE_PARAMS.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2.SIZEOF, (int)CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2.SIZEOF, (int)CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_MEM_ALLOC_NODE_PARAMS.SIZEOF, (int)CUDA_MEM_ALLOC_NODE_PARAMS.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_MEM_FREE_NODE_PARAMS.SIZEOF, (int)CUDA_MEM_FREE_NODE_PARAMS.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_BATCH_MEM_OP_NODE_PARAMS.SIZEOF, (int)CUDA_BATCH_MEM_OP_NODE_PARAMS.ALIGNOF), CUgraphNodeParams.__member((int)CUDA_CONDITIONAL_NODE_PARAMS.SIZEOF, (int)CUDA_CONDITIONAL_NODE_PARAMS.ALIGNOF)}), CUgraphNodeParams.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED0 = layout.offsetof(1);
        PARAMS = layout.offsetof(2);
        PARAMS_RESERVED1 = layout.offsetof(3);
        PARAMS_KERNEL = layout.offsetof(4);
        PARAMS_MEMCPY = layout.offsetof(5);
        PARAMS_MEMSET = layout.offsetof(6);
        PARAMS_HOST = layout.offsetof(7);
        PARAMS_GRAPH = layout.offsetof(8);
        PARAMS_EVENTWAIT = layout.offsetof(9);
        PARAMS_EVENTRECORD = layout.offsetof(10);
        PARAMS_EXTSEMSIGNAL = layout.offsetof(11);
        PARAMS_EXTSEMWAIT = layout.offsetof(12);
        PARAMS_ALLOC = layout.offsetof(13);
        PARAMS_FREE = layout.offsetof(14);
        PARAMS_MEMOP = layout.offsetof(15);
        PARAMS_CONDITIONAL = layout.offsetof(16);
        RESERVED2 = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<CUgraphNodeParams, Buffer>
    implements NativeResource {
        private static final CUgraphNodeParams ELEMENT_FACTORY = CUgraphNodeParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUgraphNodeParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUgraphNodeType")
        public int type() {
            return CUgraphNodeParams.ntype(this.address());
        }

        @NativeType(value="long long[29]")
        public LongBuffer params_reserved1() {
            return CUgraphNodeParams.nparams_reserved1(this.address());
        }

        @NativeType(value="long long")
        public long params_reserved1(int index) {
            return CUgraphNodeParams.nparams_reserved1(this.address(), index);
        }

        public CUDA_KERNEL_NODE_PARAMS_v3 params_kernel() {
            return CUgraphNodeParams.nparams_kernel(this.address());
        }

        public CUDA_MEMCPY_NODE_PARAMS params_memcpy() {
            return CUgraphNodeParams.nparams_memcpy(this.address());
        }

        public CUDA_MEMSET_NODE_PARAMS_v2 params_memset() {
            return CUgraphNodeParams.nparams_memset(this.address());
        }

        public CUDA_HOST_NODE_PARAMS_v2 params_host() {
            return CUgraphNodeParams.nparams_host(this.address());
        }

        public CUDA_CHILD_GRAPH_NODE_PARAMS params_graph() {
            return CUgraphNodeParams.nparams_graph(this.address());
        }

        public CUDA_EVENT_WAIT_NODE_PARAMS params_eventWait() {
            return CUgraphNodeParams.nparams_eventWait(this.address());
        }

        public CUDA_EVENT_RECORD_NODE_PARAMS params_eventRecord() {
            return CUgraphNodeParams.nparams_eventRecord(this.address());
        }

        public CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2 params_extSemSignal() {
            return CUgraphNodeParams.nparams_extSemSignal(this.address());
        }

        public CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2 params_extSemWait() {
            return CUgraphNodeParams.nparams_extSemWait(this.address());
        }

        public CUDA_MEM_ALLOC_NODE_PARAMS params_alloc() {
            return CUgraphNodeParams.nparams_alloc(this.address());
        }

        public CUDA_MEM_FREE_NODE_PARAMS params_free() {
            return CUgraphNodeParams.nparams_free(this.address());
        }

        public CUDA_BATCH_MEM_OP_NODE_PARAMS params_memOp() {
            return CUgraphNodeParams.nparams_memOp(this.address());
        }

        public CUDA_CONDITIONAL_NODE_PARAMS params_conditional() {
            return CUgraphNodeParams.nparams_conditional(this.address());
        }

        public Buffer type(@NativeType(value="CUgraphNodeType") int value) {
            CUgraphNodeParams.ntype(this.address(), value);
            return this;
        }

        public Buffer params_reserved1(@NativeType(value="long long[29]") LongBuffer value) {
            CUgraphNodeParams.nparams_reserved1(this.address(), value);
            return this;
        }

        public Buffer params_reserved1(int index, @NativeType(value="long long") long value) {
            CUgraphNodeParams.nparams_reserved1(this.address(), index, value);
            return this;
        }

        public Buffer params_kernel(CUDA_KERNEL_NODE_PARAMS_v3 value) {
            CUgraphNodeParams.nparams_kernel(this.address(), value);
            return this;
        }

        public Buffer params_kernel(Consumer<CUDA_KERNEL_NODE_PARAMS_v3> consumer) {
            consumer.accept(this.params_kernel());
            return this;
        }

        public Buffer params_memcpy(CUDA_MEMCPY_NODE_PARAMS value) {
            CUgraphNodeParams.nparams_memcpy(this.address(), value);
            return this;
        }

        public Buffer params_memcpy(Consumer<CUDA_MEMCPY_NODE_PARAMS> consumer) {
            consumer.accept(this.params_memcpy());
            return this;
        }

        public Buffer params_memset(CUDA_MEMSET_NODE_PARAMS_v2 value) {
            CUgraphNodeParams.nparams_memset(this.address(), value);
            return this;
        }

        public Buffer params_memset(Consumer<CUDA_MEMSET_NODE_PARAMS_v2> consumer) {
            consumer.accept(this.params_memset());
            return this;
        }

        public Buffer params_host(CUDA_HOST_NODE_PARAMS_v2 value) {
            CUgraphNodeParams.nparams_host(this.address(), value);
            return this;
        }

        public Buffer params_host(Consumer<CUDA_HOST_NODE_PARAMS_v2> consumer) {
            consumer.accept(this.params_host());
            return this;
        }

        public Buffer params_graph(CUDA_CHILD_GRAPH_NODE_PARAMS value) {
            CUgraphNodeParams.nparams_graph(this.address(), value);
            return this;
        }

        public Buffer params_graph(Consumer<CUDA_CHILD_GRAPH_NODE_PARAMS> consumer) {
            consumer.accept(this.params_graph());
            return this;
        }

        public Buffer params_eventWait(CUDA_EVENT_WAIT_NODE_PARAMS value) {
            CUgraphNodeParams.nparams_eventWait(this.address(), value);
            return this;
        }

        public Buffer params_eventWait(Consumer<CUDA_EVENT_WAIT_NODE_PARAMS> consumer) {
            consumer.accept(this.params_eventWait());
            return this;
        }

        public Buffer params_eventRecord(CUDA_EVENT_RECORD_NODE_PARAMS value) {
            CUgraphNodeParams.nparams_eventRecord(this.address(), value);
            return this;
        }

        public Buffer params_eventRecord(Consumer<CUDA_EVENT_RECORD_NODE_PARAMS> consumer) {
            consumer.accept(this.params_eventRecord());
            return this;
        }

        public Buffer params_extSemSignal(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2 value) {
            CUgraphNodeParams.nparams_extSemSignal(this.address(), value);
            return this;
        }

        public Buffer params_extSemSignal(Consumer<CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2> consumer) {
            consumer.accept(this.params_extSemSignal());
            return this;
        }

        public Buffer params_extSemWait(CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2 value) {
            CUgraphNodeParams.nparams_extSemWait(this.address(), value);
            return this;
        }

        public Buffer params_extSemWait(Consumer<CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2> consumer) {
            consumer.accept(this.params_extSemWait());
            return this;
        }

        public Buffer params_alloc(CUDA_MEM_ALLOC_NODE_PARAMS value) {
            CUgraphNodeParams.nparams_alloc(this.address(), value);
            return this;
        }

        public Buffer params_alloc(Consumer<CUDA_MEM_ALLOC_NODE_PARAMS> consumer) {
            consumer.accept(this.params_alloc());
            return this;
        }

        public Buffer params_free(CUDA_MEM_FREE_NODE_PARAMS value) {
            CUgraphNodeParams.nparams_free(this.address(), value);
            return this;
        }

        public Buffer params_free(Consumer<CUDA_MEM_FREE_NODE_PARAMS> consumer) {
            consumer.accept(this.params_free());
            return this;
        }

        public Buffer params_memOp(CUDA_BATCH_MEM_OP_NODE_PARAMS value) {
            CUgraphNodeParams.nparams_memOp(this.address(), value);
            return this;
        }

        public Buffer params_memOp(Consumer<CUDA_BATCH_MEM_OP_NODE_PARAMS> consumer) {
            consumer.accept(this.params_memOp());
            return this;
        }

        public Buffer params_conditional(CUDA_CONDITIONAL_NODE_PARAMS value) {
            CUgraphNodeParams.nparams_conditional(this.address(), value);
            return this;
        }

        public Buffer params_conditional(Consumer<CUDA_CONDITIONAL_NODE_PARAMS> consumer) {
            consumer.accept(this.params_conditional());
            return this;
        }
    }
}

