/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUctxCigParam;
import org.lwjgl.cuda.CUexecAffinityParam;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUctxCreateParams
extends Struct<CUctxCreateParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXECAFFINITYPARAMS;
    public static final int NUMEXECAFFINITYPARAMS;
    public static final int CIGPARAMS;

    protected CUctxCreateParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUctxCreateParams create(long address, @Nullable ByteBuffer container) {
        return new CUctxCreateParams(address, container);
    }

    public CUctxCreateParams(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUctxCreateParams.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUexecAffinityParam *")
    public @Nullable CUexecAffinityParam.Buffer execAffinityParams() {
        return CUctxCreateParams.nexecAffinityParams(this.address());
    }

    @NativeType(value="unsigned int")
    public int numExecAffinityParams() {
        return CUctxCreateParams.nnumExecAffinityParams(this.address());
    }

    @NativeType(value="CUctxCigParam *")
    public @Nullable CUctxCigParam cigParams() {
        return CUctxCreateParams.ncigParams(this.address());
    }

    public CUctxCreateParams execAffinityParams(@NativeType(value="CUexecAffinityParam *") @Nullable CUexecAffinityParam.Buffer value) {
        CUctxCreateParams.nexecAffinityParams(this.address(), value);
        return this;
    }

    public CUctxCreateParams numExecAffinityParams(@NativeType(value="unsigned int") int value) {
        CUctxCreateParams.nnumExecAffinityParams(this.address(), value);
        return this;
    }

    public CUctxCreateParams cigParams(@NativeType(value="CUctxCigParam *") @Nullable CUctxCigParam value) {
        CUctxCreateParams.ncigParams(this.address(), value);
        return this;
    }

    public CUctxCreateParams set(@Nullable CUexecAffinityParam.Buffer execAffinityParams, int numExecAffinityParams, @Nullable CUctxCigParam cigParams) {
        this.execAffinityParams(execAffinityParams);
        this.numExecAffinityParams(numExecAffinityParams);
        this.cigParams(cigParams);
        return this;
    }

    public CUctxCreateParams set(CUctxCreateParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUctxCreateParams malloc() {
        return new CUctxCreateParams(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUctxCreateParams calloc() {
        return new CUctxCreateParams(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUctxCreateParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUctxCreateParams(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUctxCreateParams create(long address) {
        return new CUctxCreateParams(address, null);
    }

    public static @Nullable CUctxCreateParams createSafe(long address) {
        return address == 0L ? null : new CUctxCreateParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUctxCreateParams.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUctxCreateParams.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUctxCreateParams malloc(MemoryStack stack) {
        return new CUctxCreateParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUctxCreateParams calloc(MemoryStack stack) {
        return new CUctxCreateParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable CUexecAffinityParam.Buffer nexecAffinityParams(long struct) {
        return CUexecAffinityParam.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)EXECAFFINITYPARAMS)), CUctxCreateParams.nnumExecAffinityParams(struct));
    }

    public static int nnumExecAffinityParams(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUMEXECAFFINITYPARAMS));
    }

    public static @Nullable CUctxCigParam ncigParams(long struct) {
        return CUctxCigParam.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)CIGPARAMS)));
    }

    public static void nexecAffinityParams(long struct, @Nullable CUexecAffinityParam.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)EXECAFFINITYPARAMS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        CUctxCreateParams.nnumExecAffinityParams(struct, value == null ? 0 : value.remaining());
    }

    public static void nnumExecAffinityParams(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUMEXECAFFINITYPARAMS), (int)value);
    }

    public static void ncigParams(long struct, @Nullable CUctxCigParam value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CIGPARAMS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = CUctxCreateParams.__struct((Struct.Member[])new Struct.Member[]{CUctxCreateParams.__member((int)POINTER_SIZE), CUctxCreateParams.__member((int)4), CUctxCreateParams.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXECAFFINITYPARAMS = layout.offsetof(0);
        NUMEXECAFFINITYPARAMS = layout.offsetof(1);
        CIGPARAMS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CUctxCreateParams, Buffer>
    implements NativeResource {
        private static final CUctxCreateParams ELEMENT_FACTORY = CUctxCreateParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUctxCreateParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUexecAffinityParam *")
        public @Nullable CUexecAffinityParam.Buffer execAffinityParams() {
            return CUctxCreateParams.nexecAffinityParams(this.address());
        }

        @NativeType(value="unsigned int")
        public int numExecAffinityParams() {
            return CUctxCreateParams.nnumExecAffinityParams(this.address());
        }

        @NativeType(value="CUctxCigParam *")
        public @Nullable CUctxCigParam cigParams() {
            return CUctxCreateParams.ncigParams(this.address());
        }

        public Buffer execAffinityParams(@NativeType(value="CUexecAffinityParam *") @Nullable CUexecAffinityParam.Buffer value) {
            CUctxCreateParams.nexecAffinityParams(this.address(), value);
            return this;
        }

        public Buffer numExecAffinityParams(@NativeType(value="unsigned int") int value) {
            CUctxCreateParams.nnumExecAffinityParams(this.address(), value);
            return this;
        }

        public Buffer cigParams(@NativeType(value="CUctxCigParam *") @Nullable CUctxCigParam value) {
            CUctxCreateParams.ncigParams(this.address(), value);
            return this;
        }
    }
}

