/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_GRAPH_INSTANTIATE_PARAMS
extends Struct<CUDA_GRAPH_INSTANTIATE_PARAMS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int HUPLOADSTREAM;
    public static final int HERRNODE_OUT;
    public static final int RESULT_OUT;

    protected CUDA_GRAPH_INSTANTIATE_PARAMS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_GRAPH_INSTANTIATE_PARAMS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_GRAPH_INSTANTIATE_PARAMS(address, container);
    }

    public CUDA_GRAPH_INSTANTIATE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_GRAPH_INSTANTIATE_PARAMS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cuuint64_t")
    public long flags() {
        return CUDA_GRAPH_INSTANTIATE_PARAMS.nflags(this.address());
    }

    @NativeType(value="CUstream")
    public long hUploadStream() {
        return CUDA_GRAPH_INSTANTIATE_PARAMS.nhUploadStream(this.address());
    }

    @NativeType(value="CUgraphNode")
    public long hErrNode_out() {
        return CUDA_GRAPH_INSTANTIATE_PARAMS.nhErrNode_out(this.address());
    }

    @NativeType(value="CUgraphInstantiateResult")
    public int result_out() {
        return CUDA_GRAPH_INSTANTIATE_PARAMS.nresult_out(this.address());
    }

    public static CUDA_GRAPH_INSTANTIATE_PARAMS malloc() {
        return new CUDA_GRAPH_INSTANTIATE_PARAMS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_GRAPH_INSTANTIATE_PARAMS calloc() {
        return new CUDA_GRAPH_INSTANTIATE_PARAMS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_GRAPH_INSTANTIATE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_GRAPH_INSTANTIATE_PARAMS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_GRAPH_INSTANTIATE_PARAMS create(long address) {
        return new CUDA_GRAPH_INSTANTIATE_PARAMS(address, null);
    }

    public static @Nullable CUDA_GRAPH_INSTANTIATE_PARAMS createSafe(long address) {
        return address == 0L ? null : new CUDA_GRAPH_INSTANTIATE_PARAMS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_GRAPH_INSTANTIATE_PARAMS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_GRAPH_INSTANTIATE_PARAMS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_GRAPH_INSTANTIATE_PARAMS malloc(MemoryStack stack) {
        return new CUDA_GRAPH_INSTANTIATE_PARAMS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_GRAPH_INSTANTIATE_PARAMS calloc(MemoryStack stack) {
        return new CUDA_GRAPH_INSTANTIATE_PARAMS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FLAGS));
    }

    public static long nhUploadStream(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HUPLOADSTREAM));
    }

    public static long nhErrNode_out(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HERRNODE_OUT));
    }

    public static int nresult_out(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESULT_OUT));
    }

    static {
        Struct.Layout layout = CUDA_GRAPH_INSTANTIATE_PARAMS.__struct((Struct.Member[])new Struct.Member[]{CUDA_GRAPH_INSTANTIATE_PARAMS.__member((int)8), CUDA_GRAPH_INSTANTIATE_PARAMS.__member((int)POINTER_SIZE), CUDA_GRAPH_INSTANTIATE_PARAMS.__member((int)POINTER_SIZE), CUDA_GRAPH_INSTANTIATE_PARAMS.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        HUPLOADSTREAM = layout.offsetof(1);
        HERRNODE_OUT = layout.offsetof(2);
        RESULT_OUT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUDA_GRAPH_INSTANTIATE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_GRAPH_INSTANTIATE_PARAMS ELEMENT_FACTORY = CUDA_GRAPH_INSTANTIATE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUDA_GRAPH_INSTANTIATE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cuuint64_t")
        public long flags() {
            return CUDA_GRAPH_INSTANTIATE_PARAMS.nflags(this.address());
        }

        @NativeType(value="CUstream")
        public long hUploadStream() {
            return CUDA_GRAPH_INSTANTIATE_PARAMS.nhUploadStream(this.address());
        }

        @NativeType(value="CUgraphNode")
        public long hErrNode_out() {
            return CUDA_GRAPH_INSTANTIATE_PARAMS.nhErrNode_out(this.address());
        }

        @NativeType(value="CUgraphInstantiateResult")
        public int result_out() {
            return CUDA_GRAPH_INSTANTIATE_PARAMS.nresult_out(this.address());
        }
    }
}

