/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiVectorKey")
public class AIVectorKey
extends Struct<AIVectorKey>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;
    public static final int MINTERPOLATION;

    protected AIVectorKey(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIVectorKey create(long address, @Nullable ByteBuffer container) {
        return new AIVectorKey(address, container);
    }

    public AIVectorKey(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIVectorKey.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIVectorKey.nmTime(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mValue() {
        return AIVectorKey.nmValue(this.address());
    }

    @NativeType(value="aiAnimInterpolation")
    public int mInterpolation() {
        return AIVectorKey.nmInterpolation(this.address());
    }

    public AIVectorKey mTime(double value) {
        AIVectorKey.nmTime(this.address(), value);
        return this;
    }

    public AIVectorKey mValue(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AIVectorKey.nmValue(this.address(), value);
        return this;
    }

    public AIVectorKey mValue(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mValue());
        return this;
    }

    public AIVectorKey mInterpolation(@NativeType(value="aiAnimInterpolation") int value) {
        AIVectorKey.nmInterpolation(this.address(), value);
        return this;
    }

    public AIVectorKey set(double mTime, AIVector3D mValue, int mInterpolation) {
        this.mTime(mTime);
        this.mValue(mValue);
        this.mInterpolation(mInterpolation);
        return this;
    }

    public AIVectorKey set(AIVectorKey src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIVectorKey malloc() {
        return new AIVectorKey(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIVectorKey calloc() {
        return new AIVectorKey(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIVectorKey create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIVectorKey(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIVectorKey create(long address) {
        return new AIVectorKey(address, null);
    }

    public static @Nullable AIVectorKey createSafe(long address) {
        return address == 0L ? null : new AIVectorKey(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIVectorKey.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIVectorKey.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIVectorKey mallocStack() {
        return AIVectorKey.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIVectorKey callocStack() {
        return AIVectorKey.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIVectorKey mallocStack(MemoryStack stack) {
        return AIVectorKey.malloc(stack);
    }

    @Deprecated
    public static AIVectorKey callocStack(MemoryStack stack) {
        return AIVectorKey.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIVectorKey.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIVectorKey.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVectorKey.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVectorKey.calloc(capacity, stack);
    }

    public static AIVectorKey malloc(MemoryStack stack) {
        return new AIVectorKey(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIVectorKey calloc(MemoryStack stack) {
        return new AIVectorKey(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nmTime(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)MTIME));
    }

    public static AIVector3D nmValue(long struct) {
        return AIVector3D.create(struct + (long)MVALUE);
    }

    public static int nmInterpolation(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MINTERPOLATION));
    }

    public static void nmTime(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)MTIME), (double)value);
    }

    public static void nmValue(long struct, AIVector3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MVALUE), (long)AIVector3D.SIZEOF);
    }

    public static void nmInterpolation(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MINTERPOLATION), (int)value);
    }

    static {
        Struct.Layout layout = AIVectorKey.__struct((Struct.Member[])new Struct.Member[]{AIVectorKey.__member((int)8), AIVectorKey.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AIVectorKey.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
        MINTERPOLATION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIVectorKey, Buffer>
    implements NativeResource {
        private static final AIVectorKey ELEMENT_FACTORY = AIVectorKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected AIVectorKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double mTime() {
            return AIVectorKey.nmTime(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mValue() {
            return AIVectorKey.nmValue(this.address());
        }

        @NativeType(value="aiAnimInterpolation")
        public int mInterpolation() {
            return AIVectorKey.nmInterpolation(this.address());
        }

        public Buffer mTime(double value) {
            AIVectorKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AIVectorKey.nmValue(this.address(), value);
            return this;
        }

        public Buffer mValue(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mValue());
            return this;
        }

        public Buffer mInterpolation(@NativeType(value="aiAnimInterpolation") int value) {
            AIVectorKey.nmInterpolation(this.address(), value);
            return this;
        }
    }
}

