/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiImporterDesc")
public class AIImporterDesc
extends Struct<AIImporterDesc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MAUTHOR;
    public static final int MMAINTAINER;
    public static final int MCOMMENTS;
    public static final int MFLAGS;
    public static final int MMINMAJOR;
    public static final int MMINMINOR;
    public static final int MMAXMAJOR;
    public static final int MMAXMINOR;
    public static final int MFILEEXTENSIONS;

    protected AIImporterDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIImporterDesc create(long address, @Nullable ByteBuffer container) {
        return new AIImporterDesc(address, container);
    }

    public AIImporterDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIImporterDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer mName() {
        return AIImporterDesc.nmName(this.address());
    }

    @NativeType(value="char const *")
    public String mNameString() {
        return AIImporterDesc.nmNameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer mAuthor() {
        return AIImporterDesc.nmAuthor(this.address());
    }

    @NativeType(value="char const *")
    public String mAuthorString() {
        return AIImporterDesc.nmAuthorString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer mMaintainer() {
        return AIImporterDesc.nmMaintainer(this.address());
    }

    @NativeType(value="char const *")
    public String mMaintainerString() {
        return AIImporterDesc.nmMaintainerString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer mComments() {
        return AIImporterDesc.nmComments(this.address());
    }

    @NativeType(value="char const *")
    public String mCommentsString() {
        return AIImporterDesc.nmCommentsString(this.address());
    }

    @NativeType(value="unsigned int")
    public int mFlags() {
        return AIImporterDesc.nmFlags(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMinMajor() {
        return AIImporterDesc.nmMinMajor(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMinMinor() {
        return AIImporterDesc.nmMinMinor(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMaxMajor() {
        return AIImporterDesc.nmMaxMajor(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMaxMinor() {
        return AIImporterDesc.nmMaxMinor(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer mFileExtensions() {
        return AIImporterDesc.nmFileExtensions(this.address());
    }

    @NativeType(value="char const *")
    public String mFileExtensionsString() {
        return AIImporterDesc.nmFileExtensionsString(this.address());
    }

    public AIImporterDesc mName(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmName(this.address(), value);
        return this;
    }

    public AIImporterDesc mAuthor(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmAuthor(this.address(), value);
        return this;
    }

    public AIImporterDesc mMaintainer(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmMaintainer(this.address(), value);
        return this;
    }

    public AIImporterDesc mComments(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmComments(this.address(), value);
        return this;
    }

    public AIImporterDesc mFlags(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmFlags(this.address(), value);
        return this;
    }

    public AIImporterDesc mMinMajor(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmMinMajor(this.address(), value);
        return this;
    }

    public AIImporterDesc mMinMinor(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmMinMinor(this.address(), value);
        return this;
    }

    public AIImporterDesc mMaxMajor(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmMaxMajor(this.address(), value);
        return this;
    }

    public AIImporterDesc mMaxMinor(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmMaxMinor(this.address(), value);
        return this;
    }

    public AIImporterDesc mFileExtensions(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmFileExtensions(this.address(), value);
        return this;
    }

    public AIImporterDesc set(ByteBuffer mName, ByteBuffer mAuthor, ByteBuffer mMaintainer, ByteBuffer mComments, int mFlags, int mMinMajor, int mMinMinor, int mMaxMajor, int mMaxMinor, ByteBuffer mFileExtensions) {
        this.mName(mName);
        this.mAuthor(mAuthor);
        this.mMaintainer(mMaintainer);
        this.mComments(mComments);
        this.mFlags(mFlags);
        this.mMinMajor(mMinMajor);
        this.mMinMinor(mMinMinor);
        this.mMaxMajor(mMaxMajor);
        this.mMaxMinor(mMaxMinor);
        this.mFileExtensions(mFileExtensions);
        return this;
    }

    public AIImporterDesc set(AIImporterDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIImporterDesc malloc() {
        return new AIImporterDesc(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIImporterDesc calloc() {
        return new AIImporterDesc(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIImporterDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIImporterDesc(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIImporterDesc create(long address) {
        return new AIImporterDesc(address, null);
    }

    public static @Nullable AIImporterDesc createSafe(long address) {
        return address == 0L ? null : new AIImporterDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIImporterDesc.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIImporterDesc.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIImporterDesc mallocStack() {
        return AIImporterDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIImporterDesc callocStack() {
        return AIImporterDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIImporterDesc mallocStack(MemoryStack stack) {
        return AIImporterDesc.malloc(stack);
    }

    @Deprecated
    public static AIImporterDesc callocStack(MemoryStack stack) {
        return AIImporterDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIImporterDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIImporterDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIImporterDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIImporterDesc.calloc(capacity, stack);
    }

    public static AIImporterDesc malloc(MemoryStack stack) {
        return new AIImporterDesc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIImporterDesc calloc(MemoryStack stack) {
        return new AIImporterDesc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nmName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)MNAME)));
    }

    public static String nmNameString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)MNAME)));
    }

    public static ByteBuffer nmAuthor(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)MAUTHOR)));
    }

    public static String nmAuthorString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)MAUTHOR)));
    }

    public static ByteBuffer nmMaintainer(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)MMAINTAINER)));
    }

    public static String nmMaintainerString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)MMAINTAINER)));
    }

    public static ByteBuffer nmComments(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)MCOMMENTS)));
    }

    public static String nmCommentsString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)MCOMMENTS)));
    }

    public static int nmFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MFLAGS));
    }

    public static int nmMinMajor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MMINMAJOR));
    }

    public static int nmMinMinor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MMINMINOR));
    }

    public static int nmMaxMajor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MMAXMAJOR));
    }

    public static int nmMaxMinor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MMAXMINOR));
    }

    public static ByteBuffer nmFileExtensions(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)MFILEEXTENSIONS)));
    }

    public static String nmFileExtensionsString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)MFILEEXTENSIONS)));
    }

    public static void nmName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nmAuthor(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MAUTHOR), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nmMaintainer(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MMAINTAINER), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nmComments(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MCOMMENTS), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nmFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MFLAGS), (int)value);
    }

    public static void nmMinMajor(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MMINMAJOR), (int)value);
    }

    public static void nmMinMinor(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MMINMINOR), (int)value);
    }

    public static void nmMaxMajor(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MMAXMAJOR), (int)value);
    }

    public static void nmMaxMinor(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MMAXMINOR), (int)value);
    }

    public static void nmFileExtensions(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MFILEEXTENSIONS), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MNAME)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MAUTHOR)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MMAINTAINER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MCOMMENTS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MFILEEXTENSIONS)));
    }

    static {
        Struct.Layout layout = AIImporterDesc.__struct((Struct.Member[])new Struct.Member[]{AIImporterDesc.__member((int)POINTER_SIZE), AIImporterDesc.__member((int)POINTER_SIZE), AIImporterDesc.__member((int)POINTER_SIZE), AIImporterDesc.__member((int)POINTER_SIZE), AIImporterDesc.__member((int)4), AIImporterDesc.__member((int)4), AIImporterDesc.__member((int)4), AIImporterDesc.__member((int)4), AIImporterDesc.__member((int)4), AIImporterDesc.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MAUTHOR = layout.offsetof(1);
        MMAINTAINER = layout.offsetof(2);
        MCOMMENTS = layout.offsetof(3);
        MFLAGS = layout.offsetof(4);
        MMINMAJOR = layout.offsetof(5);
        MMINMINOR = layout.offsetof(6);
        MMAXMAJOR = layout.offsetof(7);
        MMAXMINOR = layout.offsetof(8);
        MFILEEXTENSIONS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<AIImporterDesc, Buffer>
    implements NativeResource {
        private static final AIImporterDesc ELEMENT_FACTORY = AIImporterDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected AIImporterDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer mName() {
            return AIImporterDesc.nmName(this.address());
        }

        @NativeType(value="char const *")
        public String mNameString() {
            return AIImporterDesc.nmNameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer mAuthor() {
            return AIImporterDesc.nmAuthor(this.address());
        }

        @NativeType(value="char const *")
        public String mAuthorString() {
            return AIImporterDesc.nmAuthorString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer mMaintainer() {
            return AIImporterDesc.nmMaintainer(this.address());
        }

        @NativeType(value="char const *")
        public String mMaintainerString() {
            return AIImporterDesc.nmMaintainerString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer mComments() {
            return AIImporterDesc.nmComments(this.address());
        }

        @NativeType(value="char const *")
        public String mCommentsString() {
            return AIImporterDesc.nmCommentsString(this.address());
        }

        @NativeType(value="unsigned int")
        public int mFlags() {
            return AIImporterDesc.nmFlags(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMinMajor() {
            return AIImporterDesc.nmMinMajor(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMinMinor() {
            return AIImporterDesc.nmMinMinor(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMaxMajor() {
            return AIImporterDesc.nmMaxMajor(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMaxMinor() {
            return AIImporterDesc.nmMaxMinor(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer mFileExtensions() {
            return AIImporterDesc.nmFileExtensions(this.address());
        }

        @NativeType(value="char const *")
        public String mFileExtensionsString() {
            return AIImporterDesc.nmFileExtensionsString(this.address());
        }

        public Buffer mName(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmName(this.address(), value);
            return this;
        }

        public Buffer mAuthor(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmAuthor(this.address(), value);
            return this;
        }

        public Buffer mMaintainer(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmMaintainer(this.address(), value);
            return this;
        }

        public Buffer mComments(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmComments(this.address(), value);
            return this;
        }

        public Buffer mFlags(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmFlags(this.address(), value);
            return this;
        }

        public Buffer mMinMajor(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmMinMajor(this.address(), value);
            return this;
        }

        public Buffer mMinMinor(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmMinMinor(this.address(), value);
            return this;
        }

        public Buffer mMaxMajor(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmMaxMajor(this.address(), value);
            return this;
        }

        public Buffer mMaxMinor(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmMaxMinor(this.address(), value);
            return this;
        }

        public Buffer mFileExtensions(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmFileExtensions(this.address(), value);
            return this;
        }
    }
}

