/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AINode;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVertexWeight;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiBone")
public class AIBone
extends Struct<AIBone>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MNUMWEIGHTS;
    public static final int MARMATURE;
    public static final int MNODE;
    public static final int MWEIGHTS;
    public static final int MOFFSETMATRIX;

    protected AIBone(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIBone create(long address, @Nullable ByteBuffer container) {
        return new AIBone(address, container);
    }

    public AIBone(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIBone.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIBone.nmName(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumWeights() {
        return AIBone.nmNumWeights(this.address());
    }

    @NativeType(value="struct aiNode *")
    public AINode mArmature() {
        return AIBone.nmArmature(this.address());
    }

    @NativeType(value="struct aiNode *")
    public AINode mNode() {
        return AIBone.nmNode(this.address());
    }

    @NativeType(value="struct aiVertexWeight *")
    public AIVertexWeight.Buffer mWeights() {
        return AIBone.nmWeights(this.address());
    }

    @NativeType(value="struct aiMatrix4x4")
    public AIMatrix4x4 mOffsetMatrix() {
        return AIBone.nmOffsetMatrix(this.address());
    }

    public AIBone mName(@NativeType(value="struct aiString") AIString value) {
        AIBone.nmName(this.address(), value);
        return this;
    }

    public AIBone mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIBone mArmature(@NativeType(value="struct aiNode *") AINode value) {
        AIBone.nmArmature(this.address(), value);
        return this;
    }

    public AIBone mNode(@NativeType(value="struct aiNode *") AINode value) {
        AIBone.nmNode(this.address(), value);
        return this;
    }

    public AIBone mWeights(@NativeType(value="struct aiVertexWeight *") AIVertexWeight.Buffer value) {
        AIBone.nmWeights(this.address(), value);
        return this;
    }

    public AIBone mOffsetMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
        AIBone.nmOffsetMatrix(this.address(), value);
        return this;
    }

    public AIBone mOffsetMatrix(Consumer<AIMatrix4x4> consumer) {
        consumer.accept(this.mOffsetMatrix());
        return this;
    }

    public AIBone set(AIString mName, AINode mArmature, AINode mNode, AIVertexWeight.Buffer mWeights, AIMatrix4x4 mOffsetMatrix) {
        this.mName(mName);
        this.mArmature(mArmature);
        this.mNode(mNode);
        this.mWeights(mWeights);
        this.mOffsetMatrix(mOffsetMatrix);
        return this;
    }

    public AIBone set(AIBone src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIBone malloc() {
        return new AIBone(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIBone calloc() {
        return new AIBone(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIBone create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIBone(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIBone create(long address) {
        return new AIBone(address, null);
    }

    public static @Nullable AIBone createSafe(long address) {
        return address == 0L ? null : new AIBone(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIBone.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIBone.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIBone mallocStack() {
        return AIBone.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIBone callocStack() {
        return AIBone.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIBone mallocStack(MemoryStack stack) {
        return AIBone.malloc(stack);
    }

    @Deprecated
    public static AIBone callocStack(MemoryStack stack) {
        return AIBone.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIBone.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIBone.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIBone.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIBone.calloc(capacity, stack);
    }

    public static AIBone malloc(MemoryStack stack) {
        return new AIBone(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIBone calloc(MemoryStack stack) {
        return new AIBone(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumWeights(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MNUMWEIGHTS));
    }

    public static AINode nmArmature(long struct) {
        return AINode.create(MemoryUtil.memGetAddress((long)(struct + (long)MARMATURE)));
    }

    public static AINode nmNode(long struct) {
        return AINode.create(MemoryUtil.memGetAddress((long)(struct + (long)MNODE)));
    }

    public static AIVertexWeight.Buffer nmWeights(long struct) {
        return AIVertexWeight.create(MemoryUtil.memGetAddress((long)(struct + (long)MWEIGHTS)), AIBone.nmNumWeights(struct));
    }

    public static AIMatrix4x4 nmOffsetMatrix(long struct) {
        return AIMatrix4x4.create(struct + (long)MOFFSETMATRIX);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (long)AIString.SIZEOF);
    }

    public static void nmNumWeights(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MNUMWEIGHTS), (int)value);
    }

    public static void nmArmature(long struct, AINode value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MARMATURE), (long)value.address());
    }

    public static void nmNode(long struct, AINode value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MNODE), (long)value.address());
    }

    public static void nmWeights(long struct, AIVertexWeight.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MWEIGHTS), (long)value.address());
        AIBone.nmNumWeights(struct, value.remaining());
    }

    public static void nmOffsetMatrix(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MOFFSETMATRIX), (long)AIMatrix4x4.SIZEOF);
    }

    public static void validate(long struct) {
        long mArmature = MemoryUtil.memGetAddress((long)(struct + (long)MARMATURE));
        Checks.check((long)mArmature);
        AINode.validate(mArmature);
        long mNode = MemoryUtil.memGetAddress((long)(struct + (long)MNODE));
        Checks.check((long)mNode);
        AINode.validate(mNode);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MWEIGHTS)));
    }

    static {
        Struct.Layout layout = AIBone.__struct((Struct.Member[])new Struct.Member[]{AIBone.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AIBone.__member((int)4), AIBone.__member((int)POINTER_SIZE), AIBone.__member((int)POINTER_SIZE), AIBone.__member((int)POINTER_SIZE), AIBone.__member((int)AIMatrix4x4.SIZEOF, (int)AIMatrix4x4.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MNUMWEIGHTS = layout.offsetof(1);
        MARMATURE = layout.offsetof(2);
        MNODE = layout.offsetof(3);
        MWEIGHTS = layout.offsetof(4);
        MOFFSETMATRIX = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<AIBone, Buffer>
    implements NativeResource {
        private static final AIBone ELEMENT_FACTORY = AIBone.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected AIBone getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIBone.nmName(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumWeights() {
            return AIBone.nmNumWeights(this.address());
        }

        @NativeType(value="struct aiNode *")
        public AINode mArmature() {
            return AIBone.nmArmature(this.address());
        }

        @NativeType(value="struct aiNode *")
        public AINode mNode() {
            return AIBone.nmNode(this.address());
        }

        @NativeType(value="struct aiVertexWeight *")
        public AIVertexWeight.Buffer mWeights() {
            return AIBone.nmWeights(this.address());
        }

        @NativeType(value="struct aiMatrix4x4")
        public AIMatrix4x4 mOffsetMatrix() {
            return AIBone.nmOffsetMatrix(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIBone.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mArmature(@NativeType(value="struct aiNode *") AINode value) {
            AIBone.nmArmature(this.address(), value);
            return this;
        }

        public Buffer mNode(@NativeType(value="struct aiNode *") AINode value) {
            AIBone.nmNode(this.address(), value);
            return this;
        }

        public Buffer mWeights(@NativeType(value="struct aiVertexWeight *") AIVertexWeight.Buffer value) {
            AIBone.nmWeights(this.address(), value);
            return this;
        }

        public Buffer mOffsetMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
            AIBone.nmOffsetMatrix(this.address(), value);
            return this;
        }

        public Buffer mOffsetMatrix(Consumer<AIMatrix4x4> consumer) {
            consumer.accept(this.mOffsetMatrix());
            return this;
        }
    }
}

