/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiAABB")
public class AIAABB
extends Struct<AIAABB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MMIN;
    public static final int MMAX;

    protected AIAABB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIAABB create(long address, @Nullable ByteBuffer container) {
        return new AIAABB(address, container);
    }

    public AIAABB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIAABB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mMin() {
        return AIAABB.nmMin(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mMax() {
        return AIAABB.nmMax(this.address());
    }

    public AIAABB mMin(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AIAABB.nmMin(this.address(), value);
        return this;
    }

    public AIAABB mMin(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mMin());
        return this;
    }

    public AIAABB mMax(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AIAABB.nmMax(this.address(), value);
        return this;
    }

    public AIAABB mMax(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mMax());
        return this;
    }

    public AIAABB set(AIVector3D mMin, AIVector3D mMax) {
        this.mMin(mMin);
        this.mMax(mMax);
        return this;
    }

    public AIAABB set(AIAABB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIAABB malloc() {
        return new AIAABB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIAABB calloc() {
        return new AIAABB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIAABB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIAABB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIAABB create(long address) {
        return new AIAABB(address, null);
    }

    public static @Nullable AIAABB createSafe(long address) {
        return address == 0L ? null : new AIAABB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIAABB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIAABB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIAABB mallocStack() {
        return AIAABB.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAABB callocStack() {
        return AIAABB.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAABB mallocStack(MemoryStack stack) {
        return AIAABB.malloc(stack);
    }

    @Deprecated
    public static AIAABB callocStack(MemoryStack stack) {
        return AIAABB.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIAABB.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIAABB.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIAABB.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIAABB.calloc(capacity, stack);
    }

    public static AIAABB malloc(MemoryStack stack) {
        return new AIAABB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIAABB calloc(MemoryStack stack) {
        return new AIAABB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIVector3D nmMin(long struct) {
        return AIVector3D.create(struct + (long)MMIN);
    }

    public static AIVector3D nmMax(long struct) {
        return AIVector3D.create(struct + (long)MMAX);
    }

    public static void nmMin(long struct, AIVector3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MMIN), (long)AIVector3D.SIZEOF);
    }

    public static void nmMax(long struct, AIVector3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MMAX), (long)AIVector3D.SIZEOF);
    }

    static {
        Struct.Layout layout = AIAABB.__struct((Struct.Member[])new Struct.Member[]{AIAABB.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AIAABB.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MMIN = layout.offsetof(0);
        MMAX = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIAABB, Buffer>
    implements NativeResource {
        private static final AIAABB ELEMENT_FACTORY = AIAABB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected AIAABB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mMin() {
            return AIAABB.nmMin(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mMax() {
            return AIAABB.nmMax(this.address());
        }

        public Buffer mMin(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AIAABB.nmMin(this.address(), value);
            return this;
        }

        public Buffer mMin(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mMin());
            return this;
        }

        public Buffer mMax(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AIAABB.nmMax(this.address(), value);
            return this;
        }

        public Buffer mMax(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mMax());
            return this;
        }
    }
}

