/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.loggly;

import ch.qos.logback.ext.loggly.AbstractLogglyAppender;
import ch.qos.logback.ext.loggly.LogglyBatchAppenderMBean;
import ch.qos.logback.ext.loggly.io.DiscardingRollingOutputStream;
import ch.qos.logback.ext.loggly.io.IoUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class LogglyBatchAppender<E>
extends AbstractLogglyAppender<E>
implements LogglyBatchAppenderMBean {
    public static final String ENDPOINT_URL_PATH = "bulk/";
    private boolean debug = false;
    private int flushIntervalInSeconds = 3;
    private DiscardingRollingOutputStream outputStream;
    protected final AtomicLong sendDurationInNanos = new AtomicLong();
    protected final AtomicLong sentBytes = new AtomicLong();
    protected final AtomicInteger sendSuccessCount = new AtomicInteger();
    protected final AtomicInteger sendExceptionCount = new AtomicInteger();
    private ScheduledExecutorService scheduledExecutor;
    private boolean jmxMonitoring = true;
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private ObjectName registeredObjectName;
    private int maxNumberOfBuckets = 8;
    private int maxBucketSizeInKilobytes = 1024;
    private Charset charset = Charset.forName("UTF-8");
    private int connReadTimeoutSeconds = 1;

    protected void append(E e) {
        if (!this.isStarted()) {
            return;
        }
        String string = this.layout.doLayout(e);
        if (!string.endsWith("\n")) {
            string = string + "\n";
        }
        try {
            this.outputStream.write(string.getBytes(this.charset));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void start() {
        this.outputStream = new DiscardingRollingOutputStream(this.maxBucketSizeInKilobytes * 1024, this.maxNumberOfBuckets){

            @Override
            protected void onBucketDiscard(ByteArrayOutputStream byteArrayOutputStream) {
                if (LogglyBatchAppender.this.isDebug()) {
                    LogglyBatchAppender.this.addInfo("Discard bucket - " + LogglyBatchAppender.this.getDebugInfo());
                }
                String string = new Timestamp(System.currentTimeMillis()) + " - OutputStream is full, discard previous logs" + LINE_SEPARATOR;
                try {
                    ((ByteArrayOutputStream)this.getFilledBuckets().peekLast()).write(string.getBytes(LogglyBatchAppender.this.charset));
                    LogglyBatchAppender.this.addWarn(string);
                }
                catch (IOException iOException) {
                    LogglyBatchAppender.this.addWarn("Exception appending warning message '" + string + "'", iOException);
                }
            }

            @Override
            protected void onBucketRoll(ByteArrayOutputStream byteArrayOutputStream) {
                if (LogglyBatchAppender.this.isDebug()) {
                    LogglyBatchAppender.this.addInfo("Roll bucket - " + LogglyBatchAppender.this.getDebugInfo());
                }
            }
        };
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("logback-loggly-appender");
                thread.setDaemon(true);
                return thread;
            }
        };
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduledExecutor.scheduleWithFixedDelay(new LogglyExporter(), this.flushIntervalInSeconds, this.flushIntervalInSeconds, TimeUnit.SECONDS);
        if (this.jmxMonitoring) {
            String string = "ch.qos.logback:type=LogglyBatchAppender,name=LogglyBatchAppender@" + System.identityHashCode(this);
            try {
                this.registeredObjectName = this.mbeanServer.registerMBean(this, new ObjectName(string)).getObjectName();
            }
            catch (Exception exception) {
                this.addWarn("Exception registering mbean '" + string + "'", exception);
            }
        }
        super.start();
    }

    @Override
    public void stop() {
        this.scheduledExecutor.shutdown();
        this.processLogEntries();
        if (this.registeredObjectName != null) {
            try {
                this.mbeanServer.unregisterMBean(this.registeredObjectName);
            }
            catch (Exception exception) {
                this.addWarn("Exception unRegistering mbean " + this.registeredObjectName, exception);
            }
        }
        try {
            this.scheduledExecutor.awaitTermination(2 * this.flushIntervalInSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.addWarn("Exception waiting for termination of LogglyAppender scheduler", interruptedException);
        }
        this.outputStream.close();
        super.stop();
    }

    @Override
    public void processLogEntries() {
        ByteArrayOutputStream byteArrayOutputStream;
        if (this.isDebug()) {
            this.addInfo("Process log entries - " + this.getDebugInfo());
        }
        this.outputStream.rollCurrentBucketIfNotEmpty();
        BlockingDeque<ByteArrayOutputStream> blockingDeque = this.outputStream.getFilledBuckets();
        while ((byteArrayOutputStream = blockingDeque.poll()) != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                this.processLogEntries(byteArrayInputStream);
            }
            catch (Exception exception) {
                this.addWarn("Internal error", exception);
            }
            this.outputStream.recycleBucket(byteArrayOutputStream);
        }
    }

    protected HttpURLConnection getHttpConnection(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = this.proxy == null ? (HttpURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection(this.proxy);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestProperty("Content-Type", this.layout.getContentType() + "; charset=" + this.charset.name());
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setReadTimeout(this.getHttpReadTimeoutInMillis());
        return httpURLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLogEntries(InputStream inputStream) throws IOException {
        long l = System.nanoTime();
        try {
            HttpURLConnection httpURLConnection = this.getHttpConnection(new URL(this.endpointUrl));
            httpURLConnection.setReadTimeout(this.connReadTimeoutSeconds * 1000);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
            long l2 = IoUtils.copy(inputStream, bufferedOutputStream);
            this.sentBytes.addAndGet(l2);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            int n = httpURLConnection.getResponseCode();
            String string = super.readResponseBody(httpURLConnection.getInputStream());
            switch (n) {
                case 200: 
                case 202: {
                    this.sendSuccessCount.incrementAndGet();
                    break;
                }
                default: {
                    this.sendExceptionCount.incrementAndGet();
                    this.addError("LogglyAppender server-side exception: " + n + ": " + string);
                }
            }
            try {
                httpURLConnection.getInputStream().close();
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            this.sendExceptionCount.incrementAndGet();
            this.addError("LogglyAppender client-side exception", exception);
        }
        finally {
            this.sendDurationInNanos.addAndGet(System.nanoTime() - l);
        }
    }

    public int getFlushIntervalInSeconds() {
        return this.flushIntervalInSeconds;
    }

    public void setFlushIntervalInSeconds(int n) {
        this.flushIntervalInSeconds = n;
    }

    @Override
    public long getSentBytes() {
        return this.sentBytes.get();
    }

    @Override
    public long getSendDurationInNanos() {
        return this.sendDurationInNanos.get();
    }

    @Override
    public int getSendSuccessCount() {
        return this.sendSuccessCount.get();
    }

    @Override
    public int getSendExceptionCount() {
        return this.sendExceptionCount.get();
    }

    @Override
    public int getDiscardedBucketsCount() {
        return this.outputStream.getDiscardedBucketCount();
    }

    @Override
    public long getCurrentLogEntriesBufferSizeInBytes() {
        return this.outputStream.getCurrentOutputStreamSize();
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setJmxMonitoring(boolean bl) {
        this.jmxMonitoring = bl;
    }

    public void setMbeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    public void setMaxNumberOfBuckets(int n) {
        this.maxNumberOfBuckets = n;
    }

    public void setMaxBucketSizeInKilobytes(int n) {
        this.maxBucketSizeInKilobytes = n;
    }

    public void setConnReadTimeoutSeconds(int n) {
        this.connReadTimeoutSeconds = n;
    }

    private String getDebugInfo() {
        return "{sendDurationInMillis=" + TimeUnit.MILLISECONDS.convert(this.sendDurationInNanos.get(), TimeUnit.NANOSECONDS) + ", sendSuccessCount=" + this.sendSuccessCount + ", sendExceptionCount=" + this.sendExceptionCount + ", sentBytes=" + this.sentBytes + ", discardedBucketsCount=" + this.getDiscardedBucketsCount() + ", currentLogEntriesBufferSizeInBytes=" + this.getCurrentLogEntriesBufferSizeInBytes() + '}';
    }

    @Override
    protected String getEndpointPrefix() {
        return ENDPOINT_URL_PATH;
    }

    public class LogglyExporter
    implements Runnable {
        @Override
        public void run() {
            try {
                LogglyBatchAppender.this.processLogEntries();
            }
            catch (Exception exception) {
                LogglyBatchAppender.this.addWarn("Exception processing log entries", exception);
            }
        }
    }
}

