/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.loggly;

import ch.qos.logback.ext.loggly.AbstractLogglyAppender;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class LogglyAppender<E>
extends AbstractLogglyAppender<E> {
    public static final String ENDPOINT_URL_PATH = "inputs/";

    protected void append(E e) {
        String string = this.layout.doLayout(e);
        this.postToLoggly(string);
    }

    private void postToLoggly(String string) {
        try {
            assert (this.endpointUrl != null);
            URL uRL = new URL(this.endpointUrl);
            HttpURLConnection httpURLConnection = this.proxy == null ? (HttpURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection(this.proxy);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Type", this.layout.getContentType());
            httpURLConnection.connect();
            this.sendAndClose(string, httpURLConnection.getOutputStream());
            httpURLConnection.disconnect();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                String string2 = this.readResponseBody(httpURLConnection.getInputStream());
                this.addError("Loggly post failed (HTTP " + n + ").  Response body:\n" + string2);
            }
        }
        catch (IOException iOException) {
            this.addError("IOException while attempting to communicate with Loggly", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndClose(String string, OutputStream outputStream) throws IOException {
        try {
            outputStream.write(string.getBytes("UTF-8"));
        }
        finally {
            outputStream.close();
        }
    }

    @Override
    protected String getEndpointPrefix() {
        return ENDPOINT_URL_PATH;
    }
}

