/*
 * Decompiled with CFR 0.152.
 */
package org.log4mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.BSONObject;
import org.bson.Document;
import org.log4mongo.BsonAppender;

public class MongoDbAppender
extends BsonAppender {
    private static final String DEFAULT_MONGO_DB_HOSTNAME = "localhost";
    private static final String DEFAULT_MONGO_DB_PORT = "27017";
    private static final String DEFAULT_MONGO_DB_DATABASE_NAME = "log4mongo";
    private static final String DEFAULT_MONGO_DB_COLLECTION_NAME = "logevents";
    private WriteConcern concern;
    private String hostname = "localhost";
    private String port = "27017";
    private String databaseName = "log4mongo";
    private String collectionName = "logevents";
    private String userName = null;
    private String password = null;
    private String writeConcern = null;
    private MongoClient mongo = null;
    private MongoCollection collection = null;
    private boolean initialized = false;

    @Override
    public boolean requiresLayout() {
        return false;
    }

    public void activateOptions() {
        try {
            if (this.mongo != null) {
                this.close();
            }
            MongoCredential credentials = null;
            if (this.userName != null && this.userName.trim().length() > 0) {
                credentials = MongoCredential.createCredential((String)this.userName, (String)this.databaseName, (char[])this.password.toCharArray());
                this.password = null;
            }
            this.mongo = this.getMongo(this.getServerAddresses(this.hostname, this.port), credentials != null ? Arrays.asList(credentials) : null);
            MongoDatabase database = this.getDatabase(this.mongo, this.databaseName);
            this.setCollection(database.getCollection(this.collectionName));
            this.initialized = true;
        }
        catch (Exception e) {
            this.errorHandler.error("Unexpected exception while initialising MongoDbAppender.", e, 0);
        }
    }

    protected MongoDatabase getDatabase(MongoClient mongo, String databaseName) {
        return mongo.getDatabase(databaseName);
    }

    protected MongoClient getMongo(List<ServerAddress> addresses) {
        if (addresses.size() < 2) {
            return new MongoClient(addresses.get(0));
        }
        return new MongoClient(addresses);
    }

    private MongoClient getMongo(List<ServerAddress> addresses, List<MongoCredential> credentials) {
        if (credentials == null) {
            return this.getMongo(addresses);
        }
        if (addresses.size() < 2) {
            return new MongoClient(addresses.get(0), credentials);
        }
        return new MongoClient(addresses, credentials);
    }

    public void setCollection(MongoCollection collection) {
        assert (collection != null) : "collection must not be null";
        this.collection = collection;
    }

    public void close() {
        if (this.mongo != null) {
            this.collection = null;
            this.mongo.close();
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        assert (hostname != null) : "hostname must not be null";
        assert (hostname.trim().length() > 0) : "hostname must not be empty or blank";
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        assert (port != null) : "port must not be null";
        assert (port.trim().length() > 0) : "port must not be empty or blank";
        this.port = port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        assert (databaseName != null) : "database must not be null";
        assert (databaseName.trim().length() > 0) : "database must not be empty or blank";
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        assert (collectionName != null) : "collection must not be null";
        assert (collectionName.trim().length() > 0) : "collection must not be empty or blank";
        this.collectionName = collectionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
        this.concern = WriteConcern.valueOf((String)writeConcern);
    }

    public WriteConcern getConcern() {
        if (this.concern == null) {
            this.concern = this.getCollection().getWriteConcern();
        }
        return this.concern;
    }

    @Override
    public void append(BSONObject bson) {
        if (this.initialized && bson != null) {
            try {
                this.getCollection().insertOne((Object)new Document(bson.toMap()));
            }
            catch (MongoException e) {
                this.errorHandler.error("Failed to insert document to MongoDB", (Exception)((Object)e), 1);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected MongoCollection getCollection() {
        if (this.concern == null) {
            return this.collection;
        }
        return this.collection.withWriteConcern(this.concern);
    }

    private List<ServerAddress> getServerAddresses(String hostname, String port) {
        ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
        String[] hosts = hostname.split(" ");
        String[] ports = port.split(" ");
        if (ports.length != 1 && ports.length != hosts.length) {
            this.errorHandler.error("MongoDB appender port property must contain one port or a port per host", null, 6);
        } else {
            List<Integer> portNums = this.getPortNumbers(ports);
            if (portNums.size() != 1 && portNums.size() != hosts.length) {
                this.errorHandler.error("MongoDB appender port property must contain one port or a valid port per host", null, 6);
            } else {
                boolean onePort = portNums.size() == 1;
                int i = 0;
                for (String host : hosts) {
                    int portNum = onePort ? portNums.get(0).intValue() : portNums.get(i).intValue();
                    addresses.add(new ServerAddress(host.trim(), portNum));
                    ++i;
                }
            }
        }
        return addresses;
    }

    private List<Integer> getPortNumbers(String[] ports) {
        ArrayList<Integer> portNumbers = new ArrayList<Integer>();
        for (String port : ports) {
            try {
                Integer portNum = Integer.valueOf(port.trim());
                if (portNum < 0) {
                    this.errorHandler.error("MongoDB appender port property can't contain a negative integer", null, 6);
                    continue;
                }
                portNumbers.add(portNum);
            }
            catch (NumberFormatException e) {
                this.errorHandler.error("MongoDB appender can't parse a port property value into an integer", (Exception)e, 6);
            }
        }
        return portNumbers;
    }
}

