/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import org.hamcrest.Matcher;
import org.loadui.testfx.GuiTest;

public class MouseMotion {
    private final MouseButton[] buttons;
    private GuiTest controller;

    MouseMotion(GuiTest controller, MouseButton ... buttons) {
        this.controller = controller;
        this.buttons = buttons;
    }

    public GuiTest to(double x, double y) {
        this.controller.move(x, y);
        return this.controller.release(this.buttons);
    }

    public GuiTest to(String query) {
        this.controller.move(query);
        return this.controller.release(this.buttons);
    }

    public GuiTest to(Node node) {
        this.controller.move(node);
        return this.controller.release(this.buttons);
    }

    public GuiTest to(Matcher<Node> matcher) {
        this.controller.move(matcher);
        return this.controller.release(this.buttons);
    }

    public GuiTest to(Point2D point) {
        this.controller.move(point);
        return this.controller.release(this.buttons);
    }

    public GuiTest to(GuiTest.OffsetTarget node) {
        this.controller.move(node);
        return this.controller.release(this.buttons);
    }

    public MouseMotion via(double x, double y) {
        this.controller.move(x, y);
        return this;
    }

    public MouseMotion via(String query) {
        this.controller.move(query);
        return this;
    }

    public MouseMotion via(Node node) {
        this.controller.move(node);
        return this;
    }

    public MouseMotion via(Matcher<Node> matcher) {
        this.controller.move(matcher);
        return this;
    }

    public MouseMotion by(double x, double y) {
        this.controller.moveBy(x, y);
        return this;
    }

    public MouseMotion sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public GuiTest drop() {
        return this.controller.release(this.buttons);
    }
}

