/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import com.google.common.collect.ImmutableMap;
import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import org.loadui.testfx.ScreenController;
import org.loadui.testfx.utils.FXTestUtils;
import org.loadui.testfx.utils.UserInputDetector;

public class FXScreenController
implements ScreenController {
    private static final Map<MouseButton, Integer> BUTTONS = ImmutableMap.of((Object)MouseButton.PRIMARY, (Object)16, (Object)MouseButton.MIDDLE, (Object)8, (Object)MouseButton.SECONDARY, (Object)4);
    private final Robot robot;
    private long moveTime = 175L;

    public FXScreenController() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Point2D getMouse() {
        Point awtPoint = MouseInfo.getPointerInfo().getLocation();
        return new Point2D(awtPoint.getX(), awtPoint.getY());
    }

    @Override
    public void position(double x, double y) {
        this.robot.mouseMove((int)x, (int)y);
    }

    @Override
    public void move(double x, double y) {
        double totalTime;
        Point position = MouseInfo.getPointerInfo().getLocation();
        double distanceX = x - position.getX();
        double distanceY = y - position.getY();
        double distance = Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
        if (distance < (totalTime = (double)this.moveTime)) {
            totalTime = Math.max(1.0, distance);
        }
        double speedX = distanceX / totalTime;
        double speedY = distanceY / totalTime;
        int time = 0;
        while ((double)time < totalTime) {
            int newX = position.x + (int)(speedX * (double)time);
            int newY = position.y + (int)(speedY * (double)time);
            this.robot.mouseMove(newX, newY);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                return;
            }
            Point currentCursorLocation = MouseInfo.getPointerInfo().getLocation();
            Point expectedCursorLocation = new Point(newX, newY);
            UserInputDetector.instance.assertPointsAreEqual(currentCursorLocation, expectedCursorLocation);
            ++time;
        }
        this.robot.mouseMove((int)x, (int)y);
        FXTestUtils.awaitEvents();
    }

    @Override
    public void press(MouseButton button) {
        if (button == null) {
            return;
        }
        this.robot.mousePress(BUTTONS.get(button));
        FXTestUtils.awaitEvents();
    }

    @Override
    public void release(MouseButton button) {
        if (button == null) {
            return;
        }
        this.robot.mouseRelease(BUTTONS.get(button));
        FXTestUtils.awaitEvents();
    }

    @Override
    public void press(KeyCode key) {
        this.robot.keyPress(key.impl_getCode());
        FXTestUtils.awaitEvents();
    }

    @Override
    public void release(KeyCode key) {
        this.robot.keyRelease(key.impl_getCode());
        FXTestUtils.awaitEvents();
    }

    @Override
    public void pressNoWait(KeyCode key) {
        this.robot.keyPress(key.impl_getCode());
    }

    @Override
    public void releaseNoWait(KeyCode key) {
        this.robot.keyRelease(key.impl_getCode());
    }

    @Override
    public void scroll(int amount) {
        this.robot.mouseWheel(amount);
        FXTestUtils.awaitEvents();
    }
}

