/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.scalar;

import java.io.InputStream;
import java.util.Iterator;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.NumberEnvelope;

public final class LengthOf
extends NumberEnvelope {
    private static final long serialVersionUID = -7351954368806143451L;

    public <T> LengthOf(Iterable<T> items) {
        this(() -> {
            Iterator iterator = items.iterator();
            int size = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
            return size;
        });
    }

    public LengthOf(Text text) {
        this(() -> text.asString().length());
    }

    public LengthOf(Input input) {
        this(input, 16384);
    }

    public LengthOf(Input input, int max) {
        this(() -> {
            if (max == 0) {
                throw new IllegalArgumentException("Cannot use a buffer limited to zero size");
            }
            try (InputStream stream = input.stream();){
                int len;
                byte[] buf = new byte[max];
                long length = 0L;
                do {
                    if ((len = stream.read(buf)) <= 0) continue;
                    length += (long)len;
                } while (len >= 0);
                Double d = length;
                return d;
            }
        });
    }

    private LengthOf(Scalar<Double> dnm) {
        super(dnm);
    }
}

