/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.cactoos.Bytes;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.llorllale.cactoos.shaded.org.cactoos.bytes.BytesOf;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.IoChecked;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.Unchecked;

public final class InputOf
implements Input {
    private final Input origin;

    public InputOf(File file) {
        this(() -> new FileInputStream(new Unchecked<File>(() -> file).value()));
    }

    public InputOf(Path path) {
        this(() -> new FileInputStream(path.toFile()));
    }

    public InputOf(URI uri) {
        this(uri::toURL);
    }

    public InputOf(URL url) {
        this(() -> url);
    }

    public InputOf(Scalar<URL> scalar) {
        this(() -> ((URL)new IoChecked(scalar).value()).openStream());
    }

    public InputOf(Reader rdr) {
        this(new BytesOf(rdr));
    }

    public InputOf(Reader rdr, Charset charset) {
        this(new BytesOf(rdr, charset));
    }

    public InputOf(Reader rdr, CharSequence charset) {
        this(new BytesOf(rdr, charset));
    }

    public InputOf(Reader rdr, int max) {
        this(new BytesOf(rdr, max));
    }

    public InputOf(Reader rdr, Charset charset, int max) {
        this(new BytesOf(rdr, charset, max));
    }

    public InputOf(Reader rdr, CharSequence charset, int max) {
        this(new BytesOf(rdr, charset, max));
    }

    public InputOf(char ... chars) {
        this(new BytesOf(chars));
    }

    public InputOf(char[] chars, Charset charset) {
        this(new BytesOf(chars, charset));
    }

    public InputOf(char[] chars, CharSequence charset) {
        this(new BytesOf(chars, charset));
    }

    public InputOf(CharSequence source) {
        this(new BytesOf(source));
    }

    public InputOf(CharSequence source, Charset charset) {
        this(new BytesOf(source, charset));
    }

    public InputOf(CharSequence source, CharSequence charset) {
        this(new BytesOf(source, charset));
    }

    public InputOf(Text text) {
        this(new BytesOf(text));
    }

    public InputOf(Text text, Charset charset) {
        this(new BytesOf(text, charset));
    }

    public InputOf(Text text, CharSequence charset) {
        this(new BytesOf(text, charset));
    }

    public InputOf(Throwable error) {
        this(new BytesOf(error));
    }

    public InputOf(Throwable error, Charset charset) {
        this(new BytesOf(error, charset));
    }

    public InputOf(Throwable error, CharSequence charset) {
        this(new BytesOf(error, charset));
    }

    public InputOf(byte[] bytes) {
        this(new BytesOf(bytes));
    }

    public InputOf(Bytes src) {
        this(() -> new IoChecked<InputStream>(() -> new ByteArrayInputStream(src.asBytes())).value());
    }

    public InputOf(InputStream stream) {
        this(() -> stream);
    }

    private InputOf(Input input) {
        this.origin = input;
    }

    @Override
    public InputStream stream() throws Exception {
        return this.origin.stream();
    }
}

