/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.shaded.org.cactoos.func;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.cactoos.Func;
import org.cactoos.Proc;

public final class Async<X, Y>
implements Func<X, Future<Y>>,
Proc<X> {
    private final Func<X, Y> func;
    private final ExecutorService executor;

    public Async(Func<X, Y> fnc) {
        this(fnc, Executors.defaultThreadFactory());
    }

    public Async(Func<X, Y> fnc, ThreadFactory fct) {
        this(fnc, Executors.newSingleThreadExecutor(fct));
    }

    public Async(Func<X, Y> fnc, ExecutorService exec) {
        this.func = fnc;
        this.executor = exec;
    }

    @Override
    public Future<Y> apply(X input) {
        return this.executor.submit(() -> this.func.apply(input));
    }

    @Override
    public void exec(X input) {
        this.apply((Object)input);
    }
}

