/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import org.cactoos.Scalar;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;

public final class Throws<T>
extends TypeSafeDiagnosingMatcher<Scalar<T>> {
    private final Matcher<String> msg;
    private final Class<? extends Throwable> type;

    public Throws(Class<? extends Throwable> type) {
        this((Matcher<String>)new IsAnything(), type);
    }

    public Throws(String msg, Class<? extends Throwable> type) {
        this((Matcher<String>)new IsEqual((Object)msg), type);
    }

    public Throws(Matcher<String> msg, Class<? extends Throwable> type) {
        this.msg = msg;
        this.type = type;
    }

    public void describeTo(Description dsc) {
        dsc.appendText("Exception has type '").appendText(this.type.getName()).appendText("' and message matches ").appendDescriptionOf(this.msg);
    }

    protected boolean matchesSafely(Scalar<T> obj, Description dsc) {
        boolean matches;
        try {
            obj.value();
            matches = false;
            dsc.appendText("The exception wasn't thrown.");
        }
        catch (Throwable cause) {
            if (this.type.isAssignableFrom(cause.getClass()) && this.msg.matches((Object)cause.getMessage())) {
                matches = true;
            }
            dsc.appendText("Exception has type '").appendText(cause.getClass().getName()).appendText("' and message '").appendText(cause.getMessage()).appendText("'");
            matches = false;
        }
        return matches;
    }
}

