/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.cactoos.Func;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.llorllale.cactoos.shaded.org.cactoos.iterable.Mapped;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.SumOf;
import org.llorllale.cactoos.shaded.org.cactoos.scalar.Ternary;

public final class RunsInThreads<T>
extends TypeSafeDiagnosingMatcher<Func<T, Boolean>> {
    private final T input;
    private final int total;

    public RunsInThreads() {
        this(null);
    }

    public RunsInThreads(T object) {
        this(object, Runtime.getRuntime().availableProcessors() << 4);
    }

    public RunsInThreads(T object, int threads) {
        this.input = object;
        this.total = threads;
    }

    public boolean matchesSafely(Func<T, Boolean> func, Description desc) {
        ExecutorService service = Executors.newFixedThreadPool(this.total);
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(this.total);
        Callable<Boolean> task = () -> {
            latch.await();
            return (Boolean)func.apply(this.input);
        };
        for (int thread = 0; thread < this.total; ++thread) {
            futures.add(service.submit(task));
        }
        latch.countDown();
        int matching = new SumOf(new Mapped<Integer>(f -> (Integer)new Ternary<Integer>((boolean)((Boolean)f.get()), Integer.valueOf(1), Integer.valueOf(0)).value(), futures)).intValue();
        service.shutdown();
        if (matching != this.total) {
            desc.appendText("ran successfuly in ").appendValue((Object)matching).appendText(" threads");
        }
        return matching == this.total;
    }

    public void describeTo(Description description) {
        description.appendText("runs in ").appendValue((Object)this.total).appendText(" threads successfuly");
    }
}

