/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import java.util.concurrent.TimeoutException;
import org.cactoos.func.Timed;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class MatchesBefore<T>
extends TypeSafeDiagnosingMatcher<T> {
    private static final String TIME_UNIT = "milliseconds";
    private final long millisec;
    private final Matcher<T> matcher;

    public MatchesBefore(long mllsc, Matcher<T> mtchr) {
        this.millisec = mllsc;
        this.matcher = mtchr;
    }

    public void describeTo(Description desc) {
        desc.appendDescriptionOf(this.matcher).appendText(" runs in less than ").appendValue((Object)this.millisec).appendText(" ").appendText(TIME_UNIT);
    }

    protected boolean matchesSafely(T item, Description desc) {
        boolean result = false;
        Timed func = new Timed(arg_0 -> this.matcher.matches(arg_0), this.millisec);
        try {
            result = (Boolean)func.apply(item);
            this.matcher.describeMismatch(item, desc);
        }
        catch (TimeoutException texc) {
            desc.appendText("Timeout after ").appendValue((Object)this.millisec).appendText(" ").appendText(TIME_UNIT);
        }
        catch (Exception ex) {
            desc.appendText("Thrown ").appendValue((Object)ex);
        }
        return result;
    }
}

