/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.cactoos.matchers;

import org.cactoos.Scalar;
import org.cactoos.Text;
import org.cactoos.text.FormattedText;
import org.cactoos.text.UncheckedText;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class Throws<T>
extends TypeSafeDiagnosingMatcher<Scalar<T>> {
    private final String msg;
    private final Class<? extends Exception> type;

    public Throws(String msg, Class<? extends Exception> type) {
        this.msg = msg;
        this.type = type;
    }

    public void describeTo(Description dsc) {
        Throws.describe(dsc, this.type, this.msg);
    }

    protected boolean matchesSafely(Scalar<T> obj, Description dsc) {
        boolean matches;
        try {
            obj.value();
            matches = false;
            dsc.appendText("The exception wasn't thrown.");
        }
        catch (Exception cause) {
            Throws.describe(dsc, cause.getClass(), cause.getMessage());
            matches = this.type.isAssignableFrom(cause.getClass()) && this.msg.equals(cause.getMessage());
        }
        return matches;
    }

    private static void describe(Description dsc, Class<?> type, String msg) {
        dsc.appendText(new UncheckedText((Text)new FormattedText("Exception has type '%s' and message '%s'", new Object[]{type.getName(), msg})).asString());
    }
}

