/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import de.undercouch.bson4jackson.BsonFactory;
import de.undercouch.bson4jackson.BsonGenerator;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.io.ByteOrderUtil;
import de.undercouch.bson4jackson.types.Timestamp;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.bson.BsonTimestamp;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.jackson.BsonModule;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\u0001H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/litote/kmongo/jackson/KMongoBsonFactory;", "Lde/undercouch/bson4jackson/BsonFactory;", "()V", "_createParser", "Lde/undercouch/bson4jackson/BsonParser;", "inputStream", "Ljava/io/InputStream;", "ctxt", "Lcom/fasterxml/jackson/core/io/IOContext;", "copy", "createGenerator", "Lde/undercouch/bson4jackson/BsonGenerator;", "outputStream", "Ljava/io/OutputStream;", "enc", "Lcom/fasterxml/jackson/core/JsonEncoding;", "KMongoBsonGenerator", "KMongoBsonParser", "kmongo-jackson-mapping"})
public final class KMongoBsonFactory
extends BsonFactory {
    @NotNull
    public BsonGenerator createGenerator(@NotNull OutputStream outputStream, @NotNull JsonEncoding enc) {
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Intrinsics.checkParameterIsNotNull((Object)enc, (String)"enc");
        OutputStream out = outputStream;
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8 && this._outputDecorator != null) {
            OutputStream outputStream2 = this._outputDecorator.decorate(ctxt, out);
            Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"_outputDecorator.decorate(ctxt, out)");
            out = outputStream2;
        }
        KMongoBsonGenerator g = new KMongoBsonGenerator(this._generatorFeatures, this._bsonGeneratorFeatures, out);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g.setCodec(codec);
        }
        if (this._characterEscapes != null) {
            g.setCharacterEscapes(this._characterEscapes);
        }
        return g;
    }

    @NotNull
    protected BsonParser _createParser(@NotNull InputStream inputStream, @NotNull IOContext ctxt) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
        KMongoBsonParser p = new KMongoBsonParser(ctxt, this._parserFeatures, this._bsonParserFeatures, inputStream);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            p.setCodec(codec);
        }
        return p;
    }

    @NotNull
    public BsonFactory copy() {
        return new KMongoBsonFactory();
    }

    public KMongoBsonFactory() {
        this.enable(BsonParser.Feature.HONOR_DOCUMENT_LENGTH);
        this.enable(BsonGenerator.Feature.WRITE_BIGDECIMALS_AS_DECIMAL128);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonGenerator;", "Lde/undercouch/bson4jackson/BsonGenerator;", "jsonFeatures", "", "bsonFeatures", "out", "Ljava/io/OutputStream;", "(IILjava/io/OutputStream;)V", "canWriteObjectId", "", "writeBinary", "", "binary", "Lorg/bson/types/Binary;", "writeBsonTimestamp", "timestamp", "Lorg/bson/BsonTimestamp;", "writeMaxKey", "writeMinKey", "writeObjectId", "objectId", "", "writeObjectRef", "id", "kmongo-jackson-mapping"})
    public static final class KMongoBsonGenerator
    extends BsonGenerator {
        public boolean canWriteObjectId() {
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeObjectId(@NotNull Object objectId) {
            Intrinsics.checkParameterIsNotNull((Object)objectId, (String)"objectId");
            if (!(objectId instanceof ObjectId)) {
                if (objectId instanceof String) {
                    this.writeFieldName("_id");
                    this.writeString((String)objectId);
                    return;
                }
                String string = objectId + " has to be " + Reflection.getOrCreateKotlinClass(ObjectId.class);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write object id");
            this._buffer.putByte(this._typeMarker, (byte)7);
            byte[] byArray = ((ObjectId)objectId).toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"objectId.toByteArray()");
            byte[] $this$forEach$iv = byArray;
            boolean $i$f$forEach = false;
            byte[] byArray2 = $this$forEach$iv;
            int n = byArray2.length;
            int n2 = 0;
            while (true) {
                byte element$iv;
                if (n2 >= n) {
                    this.flushBuffer();
                    return;
                }
                byte it = element$iv = byArray2[n2];
                boolean bl = false;
                this._buffer.putByte(it);
                ++n2;
            }
        }

        public void writeObjectRef(@Nullable Object id) {
            if (id instanceof String) {
                this.writeString((String)id);
            } else {
                super.writeObjectRef(id);
            }
        }

        public final void writeBinary(@NotNull Binary binary) {
            Intrinsics.checkParameterIsNotNull((Object)binary, (String)"binary");
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write binary");
            byte[] bytes = binary.getData();
            this._buffer.putByte(this._typeMarker, (byte)5);
            this._buffer.putInt(bytes.length);
            this._buffer.putByte(binary.getType());
            byte[] byArray = binary.getData();
            this._buffer.putBytes(Arrays.copyOf(byArray, byArray.length));
            this.flushBuffer();
        }

        public final void writeBsonTimestamp(@NotNull BsonTimestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write timestamp");
            this._buffer.putByte(this._typeMarker, (byte)17);
            this._buffer.putInt(timestamp.getInc());
            this._buffer.putInt(timestamp.getTime());
            this.flushBuffer();
        }

        public final void writeMinKey() {
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write min key");
            this._buffer.putByte(this._typeMarker, (byte)-1);
            this.flushBuffer();
        }

        public final void writeMaxKey() {
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write max key");
            this._buffer.putByte(this._typeMarker, (byte)127);
            this.flushBuffer();
        }

        public KMongoBsonGenerator(int jsonFeatures, int bsonFeatures, @NotNull OutputStream out) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super(jsonFeatures, bsonFeatures, out);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonParser;", "Lde/undercouch/bson4jackson/BsonParser;", "ctxt", "Lcom/fasterxml/jackson/core/io/IOContext;", "jsonFeatures", "", "bsonFeatures", "inputStream", "Ljava/io/InputStream;", "(Lcom/fasterxml/jackson/core/io/IOContext;IILjava/io/InputStream;)V", "convertToBSONTimestamp", "", "ts", "Lde/undercouch/bson4jackson/types/Timestamp;", "convertToNativeObjectId", "Lorg/bson/types/ObjectId;", "id", "Lde/undercouch/bson4jackson/types/ObjectId;", "getEmbeddedObject", "readObjectId", "kmongo-jackson-mapping"})
    private static final class KMongoBsonParser
    extends BsonParser {
        @NotNull
        public Object getEmbeddedObject() {
            Object embedded = super.getEmbeddedObject();
            if (embedded instanceof de.undercouch.bson4jackson.types.ObjectId) {
                return this.convertToNativeObjectId((de.undercouch.bson4jackson.types.ObjectId)embedded);
            }
            if (embedded instanceof Timestamp) {
                return this.convertToBSONTimestamp((Timestamp)embedded);
            }
            Object object = embedded;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"embedded");
            return object;
        }

        private final Object convertToBSONTimestamp(Timestamp ts) {
            return new BsonTimestamp(ts.getTime(), ts.getInc());
        }

        private final ObjectId convertToNativeObjectId(de.undercouch.bson4jackson.types.ObjectId id) {
            ObjectId objectId = ObjectId.createFromLegacyFormat((int)id.getTime(), (int)id.getMachine(), (int)id.getInc());
            Intrinsics.checkExpressionValueIsNotNull((Object)objectId, (String)"org.bson.types.ObjectId.\u2026time, id.machine, id.inc)");
            return objectId;
        }

        @NotNull
        protected de.undercouch.bson4jackson.types.ObjectId readObjectId() {
            int time = ByteOrderUtil.flip((int)this._in.readInt());
            int machine = ByteOrderUtil.flip((int)this._in.readInt());
            int inc = ByteOrderUtil.flip((int)this._in.readInt());
            return new BsonModule.KMongoObjectId(time, machine, inc);
        }

        public KMongoBsonParser(@NotNull IOContext ctxt, int jsonFeatures, int bsonFeatures, @NotNull InputStream inputStream) {
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
            super(ctxt, jsonFeatures, bsonFeatures, inputStream);
        }
    }
}

