/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.fields;

import java.util.List;
import org.litesoft.fields.Accessor;
import org.litesoft.fields.FieldAccessors;
import org.litesoft.fields.Indentable;
import org.litesoft.fields.StringBuilderUtils;

public class ToStringBuilder {
    private static final int INDENT_SIZE = 2;
    private final StringBuilder sb = new StringBuilder();
    private final String prefix;
    private int indent;

    public ToStringBuilder(String prefix) {
        this.prefix = prefix == null ? "" : prefix.trim();
        this.indent = this.prefix.isEmpty() ? 0 : 2;
    }

    public ToStringBuilder() {
        this(null);
    }

    public ToStringBuilder indent() {
        this.indent += 2;
        return this;
    }

    public ToStringBuilder outdent() {
        if (this.indent > 0) {
            this.indent -= 2;
        }
        return this;
    }

    public ToStringBuilder add(String name, Object value) {
        if (!this.sb.isEmpty()) {
            this.sb.append("\n");
        }
        StringBuilderUtils.addIndentation(this.sb, this.indent);
        this.sb.append(name).append(":");
        if (value instanceof Indentable) {
            this.indent();
            ((Indentable)value).addFieldsTo(this);
            this.outdent();
        } else {
            StringBuilderUtils.addQuotedTo(this.sb.append(' '), value);
        }
        return this;
    }

    public <T> ToStringBuilder add(T instance, Accessor<T, ?> fa) {
        return fa == null ? this : this.add(fa.getName(), fa.getValue(instance));
    }

    public <T> ToStringBuilder addAll(T instance, FieldAccessors<T> fas) {
        return instance == null || fas == null ? this : this.addAll(instance, fas.getAll());
    }

    public <T> ToStringBuilder addAll(T instance, List<Accessor<T, ?>> fas) {
        if (instance != null && fas != null) {
            for (Accessor<T, ?> fa : fas) {
                this.add(instance, fa);
            }
        }
        return this;
    }

    public String toString() {
        return this.indent <= 0 ? this.sb.toString() : this.prefix.trim() + ":\n" + this.sb;
    }
}

