/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.fields;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.litesoft.fields.Accessor;
import org.litesoft.fields.FieldAccessors;
import org.litesoft.fields.FieldError;
import org.litesoft.fields.MutableAccessor;
import org.litesoft.utils.TemplatedMessage;
import org.litesoft.utils.TemplatedMessageException;

public class FieldMappers<TargetT, SourceT> {
    private final Class<TargetT> targetT;
    private final Class<SourceT> sourceT;
    final LinkedHashMap<String, Mapper<TargetT, SourceT>> mappers = new LinkedHashMap();

    public static <TargetT, SourceT> FieldMappers<TargetT, SourceT> of(Class<TargetT> targetT, Class<SourceT> sourceT) {
        return new FieldMappers<TargetT, SourceT>(targetT, sourceT);
    }

    public void map(TargetT target, SourceT source) {
        this.map(target, source, null);
    }

    public void map(TargetT target, SourceT source, Map<String, FieldError> fieldErrors) {
        FieldMappers.assertType(target, this.targetT, "target instance");
        FieldMappers.assertType(source, this.sourceT, "source instance");
        for (Map.Entry<String, Mapper<TargetT, SourceT>> entry : this.mappers.entrySet()) {
            TemplatedMessage templatedMessage;
            Throwable rte;
            Mapper<TargetT, SourceT> mapper = entry.getValue();
            try {
                mapper.map(source, target);
                continue;
            }
            catch (TemplatedMessageException e) {
                rte = e;
                templatedMessage = e.getTemplatedMessage();
            }
            catch (RuntimeException e) {
                rte = e;
                templatedMessage = new TemplatedMessage(e.getMessage(), new String[0]);
            }
            if (fieldErrors == null) {
                throw rte;
            }
            String fieldName = entry.getKey();
            fieldErrors.put(fieldName, new FieldError(fieldName, templatedMessage));
        }
    }

    public FieldMappers<TargetT, SourceT> add(String name, FieldAccessors<TargetT> targetFields, FieldAccessors<SourceT> sourceFields) {
        return this.add(name, targetFields, name, sourceFields);
    }

    public <R> FieldMappers<TargetT, SourceT> add(String targetName, FieldAccessors<TargetT> targetFields, String sourceName, FieldAccessors<SourceT> sourceFields) {
        Accessor<SourceT, R> getter = this.extractAccessor(sourceName, sourceFields);
        return this.add(targetName, targetFields, getter);
    }

    public <R> FieldMappers<TargetT, SourceT> add(String name, FieldAccessors<TargetT> targetFields, Function<SourceT, R> getter) {
        MutableAccessor<TargetT, R> setter = this.extractMutableAccessor(name, targetFields);
        return this.add(setter, getter);
    }

    public <R, S> FieldMappers<TargetT, SourceT> add(String targetName, FieldAccessors<TargetT> targetFields, String sourceName, FieldAccessors<SourceT> sourceFields, Function<S, R> transformer) {
        Accessor<SourceT, R> getter = this.extractAccessor(sourceName, sourceFields);
        return this.add(targetName, targetFields, getter, transformer);
    }

    public <R, S> FieldMappers<TargetT, SourceT> add(String name, FieldAccessors<TargetT> targetFields, Function<SourceT, S> getter, Function<S, R> transformer) {
        MutableAccessor<TargetT, R> setter = this.extractMutableAccessor(name, targetFields);
        return this.add(setter, getter, transformer);
    }

    public <R> FieldMappers<TargetT, SourceT> add(MutableAccessor<TargetT, R> setter, Function<SourceT, R> getter) {
        return this.add(setter.getName(), setter, getter);
    }

    public <R, S> FieldMappers<TargetT, SourceT> add(MutableAccessor<TargetT, R> setter, Function<SourceT, S> getter, Function<S, R> transformer) {
        return this.add(setter.getName(), setter, getter, transformer);
    }

    public <R, S> FieldMappers<TargetT, SourceT> add(String fieldName, BiConsumer<TargetT, R> setter, Function<SourceT, S> getter, Function<S, R> transformer) {
        return this.add(fieldName, setter, (SourceT sourceT) -> transformer.apply(getter.apply(sourceT)));
    }

    public <R> FieldMappers<TargetT, SourceT> add(String fieldName, BiConsumer<TargetT, R> setter, Function<SourceT, R> getter) {
        return this.add(fieldName, new MapperImpl<TargetT, SourceT, R>(setter, getter));
    }

    public FieldMappers<TargetT, SourceT> add(String fieldName, Mapper<TargetT, SourceT> mapper) {
        Mapper<TargetT, SourceT> prev = this.mappers.put(fieldName, FieldMappers.assertNotNull(mapper, "mapper"));
        if (prev != null) {
            throw new Error("Attempt to register a duplicate field of: " + fieldName);
        }
        return this;
    }

    private FieldMappers(Class<TargetT> targetT, Class<SourceT> sourceT) {
        this.targetT = FieldMappers.assertNotNull(targetT, "targetClass");
        this.sourceT = FieldMappers.assertNotNull(sourceT, "sourceClass");
    }

    private <R> Accessor<SourceT, R> extractAccessor(String name, FieldAccessors<SourceT> accessors) {
        Accessor accessor = FieldMappers.assertNotNull(accessors, "accessors").getAccessor(name);
        if (accessor == null) {
            FieldMappers.nullError("No Accessor registered on " + this.sourceT.getSimpleName() + " for field: " + name);
        }
        return accessor;
    }

    private <R> MutableAccessor<TargetT, R> extractMutableAccessor(String name, FieldAccessors<TargetT> accessors) {
        MutableAccessor accessor = FieldMappers.assertNotNull(accessors, "accessors").getMutableAccessor(name);
        if (accessor == null) {
            FieldMappers.nullError("No MutableAccessor registered on " + this.targetT.getSimpleName() + " for field: " + name);
        }
        return accessor;
    }

    private static void nullError(String paramName) {
        throw new IllegalStateException(paramName + " not allowed to be null");
    }

    private static <T> T assertNotNull(T object, String paramName) {
        if (object == null) {
            FieldMappers.nullError(paramName);
        }
        return object;
    }

    private static void assertType(Object object, Class<?> expectedType, String paramName) {
        if (object == null) {
            FieldMappers.nullError(paramName);
        }
        if (!expectedType.isInstance(object)) {
            throw new IllegalStateException(paramName + " not of type: " + expectedType.getSimpleName());
        }
    }

    public static interface Mapper<TargetT, SourceT> {
        public void map(SourceT var1, TargetT var2);
    }

    private record MapperImpl<TargetT, SourceT, R>(BiConsumer<TargetT, R> setter, Function<SourceT, R> getter) implements Mapper<TargetT, SourceT>
    {
        @Override
        public void map(SourceT source, TargetT target) {
            this.setter.accept(target, this.getter.apply(source));
        }
    }
}

