/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import java.nio.charset.StandardCharsets;
import org.litesoft.annotations.NotNull;
import org.litesoft.bitstream.AbstractBitBufferStreamSequentialSink;
import org.litesoft.bitstream.BitBuffer;
import org.litesoft.bitstream.BitConstants;

public class StringSequentialSink
extends AbstractBitBufferStreamSequentialSink<String> {
    public StringSequentialSink(int expectedBits) {
        super(new SBS(expectedBits));
    }

    public static StringSequentialSink ofBytes(int utf8BytesLength) {
        return new StringSequentialSink(utf8BytesLength * 8);
    }

    @Override
    @NotNull
    public String getValue() {
        return (String)this.sinkBitStream.getValue();
    }

    static class SBS
    extends AbstractBitBufferStreamSequentialSink.SinkBitStream<String>
    implements BitConstants {
        private final byte[] utf8Bytes;
        private int byteOffset;

        SBS(int expectedBits) {
            super(8);
            if (expectedBits < 0 || 0 != (expectedBits & 7)) {
                throw new IllegalStateException("expectedBits not negative or not divisible by 8, was: " + expectedBits);
            }
            int byteCount = expectedBits >> 3;
            this.utf8Bytes = new byte[byteCount];
        }

        @Override
        public String getValue() {
            if (this.byteOffset < this.utf8Bytes.length) {
                throw new IllegalStateException("Stream error value not fully populated");
            }
            return new String(this.utf8Bytes, StandardCharsets.UTF_8);
        }

        @Override
        public int bitsCurrentlyNeeded(BitBuffer buffer) {
            return this.utf8Bytes.length <= this.byteOffset ? 0 : 8 - buffer.availableBits();
        }

        @Override
        public void addBits(int bits) {
            this.utf8Bytes[this.byteOffset++] = (byte)bits;
        }
    }
}

