/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.bitstream.AbstractBitStreamSequentialSource;
import org.litesoft.bitstream.BitStreamProvider;
import org.litesoft.bitstream.BitStreamSequentialSource;
import org.litesoft.bitstream.Nbits;

public class OnesComplimentLongBitsProvider
implements BitStreamProvider {
    private final boolean wasNegative;
    private long value;
    private int remainingSignificantBits;

    public OnesComplimentLongBitsProvider(long value) {
        boolean bl = this.wasNegative = value < 0L;
        if (this.wasNegative) {
            value = value == Long.MIN_VALUE ? 0L : -value;
        }
        this.value = value;
        long mask = 1L;
        for (int i = 1; i < 64; ++i) {
            if (0L != (value & mask)) {
                this.remainingSignificantBits = i;
            }
            mask += mask;
        }
    }

    @Override
    public int availableBits() {
        return this.remainingSignificantBits;
    }

    public boolean wasNegative() {
        return this.wasNegative;
    }

    public int getSignBit() {
        return this.wasNegative ? 1 : 0;
    }

    public boolean isValueNonZero() {
        return 0L != this.value;
    }

    @Override
    public int removeNbits(int n) {
        int mask = Nbits.removeNbits(63, this, n);
        long bits = this.value & (long)mask;
        this.value >>= n;
        this.remainingSignificantBits = Math.max(0, this.remainingSignificantBits - n);
        return (int)bits;
    }

    public BitStreamSequentialSource asSequentialSource() {
        return new OurSequentialSource(this);
    }

    private static class OurSequentialSource
    extends AbstractBitStreamSequentialSource {
        private final OnesComplimentLongBitsProvider provider;
        private int availableBits;
        private boolean signBitConsumed = false;

        public OurSequentialSource(OnesComplimentLongBitsProvider provider) {
            this.provider = provider;
            this.availableBits = 1 + provider.availableBits();
        }

        @Override
        protected String toStringName() {
            return this.provider.getClass().getSimpleName();
        }

        @Override
        public int availableBits() {
            return this.availableBits;
        }

        @Override
        public int removeNbits(int n) {
            Nbits.removeNbits(this.availableBits(), this.provider, n);
            this.availableBits -= n;
            if (this.signBitConsumed) {
                return this.provider.removeNbits(n);
            }
            this.signBitConsumed = true;
            int signBit = this.provider.getSignBit();
            if (n == 1) {
                return signBit;
            }
            int otherBits = this.provider.removeNbits(--n);
            return (signBit << n) + otherBits;
        }
    }
}

