/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.annotations.NotNull;
import org.litesoft.annotations.PackageFriendlyForTesting;
import org.litesoft.bitstream.AbstractBitBufferStreamSequentialSink;
import org.litesoft.bitstream.BitBuffer;
import org.litesoft.bitstream.BitConstants;

public class IntLengthSequentialSink
extends AbstractBitBufferStreamSequentialSink<Integer> {
    @PackageFriendlyForTesting
    static final String LENGTH_WENT_NEGATIVE = "Stream error length went negative";

    public IntLengthSequentialSink() {
        super(new SBS());
    }

    @Override
    @NotNull
    public Integer getValue() {
        return (Integer)this.sinkBitStream.getValue();
    }

    static class SBS
    extends AbstractBitBufferStreamSequentialSink.SinkBitStream<Integer>
    implements BitConstants {
        private int value;
        private boolean full;

        SBS() {
            super(6);
        }

        @Override
        public Integer getValue() {
            if (this.full) {
                return this.value;
            }
            throw new IllegalStateException("Stream error value not fully populated");
        }

        @Override
        public int bitsCurrentlyNeeded(BitBuffer buffer) {
            return this.full ? 0 : 6 - buffer.availableBits();
        }

        @Override
        public void addBits(int bits) {
            int b5 = bits & MASKS[5];
            this.value = (this.value << 5) + b5;
            boolean bl = this.full = 0 == bits - b5;
            if (this.value < 0) {
                throw new IllegalStateException(IntLengthSequentialSink.LENGTH_WENT_NEGATIVE);
            }
        }
    }
}

