/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.annotations.PackageFriendlyForTesting;
import org.litesoft.bitstream.AbstractBitStreamSequentialSource;
import org.litesoft.bitstream.BitStreamSequentialSource;

public class BitStreamSequentialSourceComposite
extends AbstractBitStreamSequentialSource {
    @PackageFriendlyForTesting
    final BitStreamSequentialSource s1;
    @PackageFriendlyForTesting
    final BitStreamSequentialSource s2;

    public BitStreamSequentialSourceComposite(BitStreamSequentialSource s1, BitStreamSequentialSource s2) {
        this.s1 = s1;
        this.s2 = s2;
    }

    @Override
    public int availableBits() {
        return this.s1.availableBits() + this.s2.availableBits();
    }

    @Override
    public int removeNbits(int n) {
        int a1 = this.s1.availableBits();
        if (n <= a1) {
            return this.s1.removeNbits(n);
        }
        if (a1 == 0 || n > 8) {
            return this.s2.removeNbits(n);
        }
        int from_s2 = n - a1;
        int bits1 = this.s1.removeNbits(a1);
        int bits2 = this.s2.removeNbits(from_s2);
        return (bits1 << from_s2) + bits2;
    }
}

