/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.bitstream.BitStreamBuilderProvider;
import org.litesoft.bitstream.Nbits;

public class BitBuffer
implements BitStreamBuilderProvider<BitBuffer> {
    private int bits = 0;
    private int bitCount = 0;

    @Override
    public int availableBits() {
        return this.bitCount;
    }

    @Override
    public BitBuffer addNbits(int n, int bits) {
        bits = Nbits.addNbits(this.bitCount, 31, this, n, bits);
        this.bitCount += n;
        this.bits = (this.bits << n) + bits;
        return this;
    }

    @Override
    public int removeNbits(int n) {
        int mask = Nbits.removeNbits(this.bitCount, this, n);
        int shift = this.bitCount - n;
        if (shift != 0) {
            mask <<= shift;
        }
        int valueToReturn = this.bits & mask;
        this.bits -= valueToReturn;
        this.bitCount -= n;
        if (shift != 0) {
            valueToReturn >>= shift;
        }
        return valueToReturn;
    }

    public String toString() {
        return Integer.toHexString(this.bits);
    }
}

