/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.bitstream.AbstractBitStreamSequentialSource;
import org.litesoft.bitstream.BitBuffer;
import org.litesoft.bitstream.Nbits;

public abstract class AbstractBitBufferStreamSequentialSource
extends AbstractBitStreamSequentialSource {
    protected final BitBuffer buffer = new BitBuffer();
    public final AbstractBitStreamSequentialSource.SourceBitStream sourceBitStream;

    protected AbstractBitBufferStreamSequentialSource(AbstractBitStreamSequentialSource.SourceBitStream sourceBitStream) {
        this.sourceBitStream = sourceBitStream;
    }

    @Override
    public final int availableBits() {
        return this.buffer.availableBits() + this.sourceBitStream.availableBits();
    }

    @Override
    public final int removeNbits(int n) {
        if (n <= 8) {
            while (this.buffer.availableBits() < n && this.sourceBitStream.hasAvailableBits()) {
                this.buffer.addNbits(this.sourceBitStream.getBitSize(), this.sourceBitStream.removeBits());
            }
        }
        Nbits.removeNbits(this.buffer.availableBits(), this, n);
        return this.buffer.removeNbits(n);
    }
}

