/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.litesoft.annotations.DefaultingOnInsignificant;
import org.litesoft.annotations.Immutable;
import org.litesoft.annotations.NotNull;
import org.litesoft.annotations.Nullable;
import org.litesoft.annotations.Significant;
import org.litesoft.annotations.SignificantOrNull;
import org.litesoft.annotations.Verified;

public interface Validation {
    public static final String NO_ERRORS = "No Errors";
    public static final String INDENT_PADDING = "    ";
    public static final Validation OK = new Validation(){

        @Override
        public boolean hasErrors() {
            return false;
        }

        @Override
        public List<String> getHostErrors() {
            return Collections.emptyList();
        }

        @Override
        public Map<String, List<String>> getFieldErrors() {
            return Collections.emptyMap();
        }

        @Override
        public Validation addHostError(String pError) {
            return (pError = Significant.ConstrainTo.valueOrNull(pError)) == null ? this : this.addHostErrorTo(this.getHostErrors(), this.getFieldErrors(), pError);
        }

        @Override
        public Validation addFieldError(String pFieldRef, String pError) {
            return (pError = Significant.ConstrainTo.valueOrNull(pError)) == null ? this : this.addFieldErrorTo(this.getHostErrors(), this.getFieldErrors(), pFieldRef, pError);
        }

        @Override
        public String format(Class<?> pHost, Object pHostId) {
            return this.toString();
        }

        public String toString() {
            return Validation.NO_ERRORS;
        }

        private Validation addHostErrorTo(@NotNull @Immutable @Verified List<String> pExistingHostErrors, @NotNull @Immutable @Verified Map<String, List<String>> pExistingFieldErrors, @Significant @Verified String pError) {
            return new WithErrors(this.addErrorTo(pExistingHostErrors, pError), pExistingFieldErrors);
        }

        private Validation addFieldErrorTo(@NotNull @Verified List<String> pExistingHostErrors, @NotNull @Verified Map<String, List<String>> pExistingFieldErrors, @DefaultingOnInsignificant String pFieldRef, @Significant @Verified String pError) {
            pFieldRef = Significant.ConstrainTo.valueOr(pFieldRef, ".!N/A!.");
            HashMap<String, List<String>> zNewFieldErrors = new HashMap<String, List<String>>(pExistingFieldErrors);
            zNewFieldErrors.put(pFieldRef, this.addErrorTo((List)zNewFieldErrors.get(pFieldRef), pError));
            return new WithErrors(pExistingHostErrors, Collections.unmodifiableMap(zNewFieldErrors));
        }

        @NotNull
        @Immutable
        private List<String> addErrorTo(@Nullable @Immutable List<String> pExistingErrors, @Significant @Verified String pError) {
            ArrayList<String> zErrors = new ArrayList<String>();
            if (pExistingErrors != null) {
                zErrors.addAll(pExistingErrors);
            }
            zErrors.add(pError);
            return Collections.unmodifiableList(zErrors);
        }

        class WithErrors
        implements Validation {
            private final List<String> mHostErrors;
            private final Map<String, List<String>> mErrorsByFieldRef;

            private WithErrors(@NotNull @Immutable @Verified List<String> pHostErrors, Map<String, List<String>> pErrorsByFieldRef) {
                this.mHostErrors = pHostErrors;
                this.mErrorsByFieldRef = pErrorsByFieldRef;
            }

            @Override
            public Validation addHostError(String pError) {
                return (pError = Significant.ConstrainTo.valueOrNull(pError)) == null ? this : this.addHostErrorTo(this.mHostErrors, this.mErrorsByFieldRef, pError);
            }

            @Override
            public Validation addFieldError(String pFieldRef, String pError) {
                return (pError = Significant.ConstrainTo.valueOrNull(pError)) == null ? this : this.addFieldErrorTo(this.mHostErrors, this.mErrorsByFieldRef, pFieldRef, pError);
            }

            @Override
            public boolean hasErrors() {
                return true;
            }

            @Override
            public List<String> getHostErrors() {
                return Collections.unmodifiableList(this.mHostErrors);
            }

            @Override
            public Map<String, List<String>> getFieldErrors() {
                return Collections.unmodifiableMap(this.mErrorsByFieldRef);
            }

            @Override
            public String format(Class<?> pHost, Object pHostId) {
                String zStringHostId;
                Object zHostRef = NotNull.AssertArgument.namedValue("Host", pHost).getSimpleName();
                if (pHostId != null && (zStringHostId = Significant.ConstrainTo.valueOrNull(pHostId.toString())) != null) {
                    zHostRef = (String)zHostRef + "(" + zStringHostId + ")";
                }
                return this.format("Errors with " + (String)zHostRef);
            }

            public String toString() {
                return this.format("Errors found");
            }

            private String format(String pHostLeadin) {
                StringBuilder sb = new StringBuilder().append(pHostLeadin).append(':');
                this.addHostErrors(sb);
                this.addFieldErrors(sb);
                return sb.toString();
            }

            private void addHostErrors(StringBuilder pSB) {
                if (!this.mHostErrors.isEmpty()) {
                    this.addErrors(pSB, this.mHostErrors, 1, "Host Error", "s");
                }
            }

            private void addFieldErrors(StringBuilder pSB) {
                if (!this.mErrorsByFieldRef.isEmpty()) {
                    ArrayList<String> zFieldRefs = new ArrayList<String>(this.mErrorsByFieldRef.keySet());
                    if (zFieldRefs.size() == 1) {
                        String zKey = (String)zFieldRefs.get(0);
                        String zSingularLabel = "Field '" + zKey + "' Error";
                        List<String> zErrors = this.mErrorsByFieldRef.get(zKey);
                        this.addErrors(pSB, this.mErrorsByFieldRef.get(zKey), 1, zSingularLabel, "s");
                        return;
                    }
                    Collections.sort(zFieldRefs);
                    this.newLineIndented(pSB, 1).append("Field Errors:");
                    for (String zFieldRef : zFieldRefs) {
                        this.addErrors(pSB, this.mErrorsByFieldRef.get(zFieldRef), 2, zFieldRef, "");
                    }
                }
            }

            private StringBuilder newLineIndented(StringBuilder pSB, int pIndents) {
                pSB.append('\n').append(Validation.INDENT_PADDING);
                while (--pIndents > 0) {
                    pSB.append(Validation.INDENT_PADDING);
                }
                return pSB;
            }

            private void addErrors(StringBuilder pSB, List<String> pErrors, int pIndents, String pSingularLabel, String pPluralSuffix) {
                this.newLineIndented(pSB, pIndents++).append(pSingularLabel);
                if (pErrors.size() == 1) {
                    pSB.append(": ").append(pErrors.get(0));
                    return;
                }
                pSB.append(pPluralSuffix).append(":");
                for (String zError : pErrors) {
                    this.newLineIndented(pSB, pIndents).append(zError);
                }
            }
        }
    };

    public boolean hasErrors();

    @NotNull
    @Immutable
    public List<String> getHostErrors();

    @NotNull
    @Immutable
    public Map<String, List<String>> getFieldErrors();

    @NotNull
    public Validation addHostError(@SignificantOrNull String var1);

    @NotNull
    public Validation addFieldError(@DefaultingOnInsignificant String var1, @SignificantOrNull String var2);

    @Significant
    public String format(@NotNull Class<?> var1, @Nullable Object var2);
}

