/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import org.litesoft.annotations.NotChecked;
import org.litesoft.annotations.NotNull;
import org.litesoft.annotations.expectations.Expectation;
import org.litesoft.annotations.expectations.IllegalArgument;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE})
public @interface NotNullAndContainsNoNulls {
    public static final String EXPECTATION = "Not Null And Contains No Nulls";

    public static class AssertArgument {
        public static <Entry, T extends Collection<Entry>> T namedValue(String pName, T pToCheck) throws IllegalArgumentException {
            return Assert.namedValueExpectation(pName, pToCheck, IllegalArgument.INSTANCE);
        }
    }

    public static class Assert {
        public static <Entry, T extends Collection<Entry>> T namedValueExpectation(String pName, T pToCheck, Expectation pExpectation) {
            boolean zAcceptable = Check.value(pToCheck);
            if (!zAcceptable) {
                pExpectation.unmet(pName, null, NotNullAndContainsNoNulls.EXPECTATION);
            }
            return pToCheck;
        }
    }

    public static class Check {
        public static <Entry, T extends Collection<Entry>> boolean value(T pToCheck) {
            return null != pToCheck && Check.anyNulls(pToCheck);
        }

        static <Entry, T extends Collection<Entry>> boolean anyNulls(@NotNull @NotChecked T pToCheck) {
            for (Entry zEntry : pToCheck) {
                if (zEntry != null) continue;
                return false;
            }
            return true;
        }
    }

    public static class Validate {
        public static <Entry, T extends Collection<Entry>> boolean value(String pName, T pToCheck, Expectation pExpectation) {
            boolean zAcceptable = Check.value(pToCheck);
            if (!zAcceptable) {
                pExpectation.unmet(pName, pToCheck, NotNullAndContainsNoNulls.EXPECTATION);
            }
            return zAcceptable;
        }
    }
}

