/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.litesoft.annotations.expectations.Expectation;
import org.litesoft.annotations.expectations.IllegalArgument;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE})
public @interface NotNull {
    public static final String EXPECTATION = "Not Null";

    public static class Count {
        public static int of(Object ... pObjects) {
            int count = 0;
            if (pObjects != null) {
                for (Object o : pObjects) {
                    if (o == null) continue;
                    ++count;
                }
            }
            return count;
        }
    }

    public static class AssertArgument {
        public static <T> T namedValue(String pName, T pToCheck) throws IllegalArgumentException {
            return Assert.namedValueExpectation(pName, pToCheck, IllegalArgument.INSTANCE);
        }
    }

    public static class Assert {
        public static <T> T namedValueExpectation(String pName, T pToCheck, Expectation pExpectation) {
            if (pToCheck == null) {
                pExpectation.unmet(pName, null, NotNull.EXPECTATION);
            }
            return pToCheck;
        }

        public static <T> T errorOn(String pName, T pToCheck) {
            if (pToCheck != null) {
                return pToCheck;
            }
            throw new Error("No '" + pName + "' provided -- coding error");
        }
    }

    public static class ConstrainTo {
        public static String valueOr(String pToCheck, String pValueIfNull) {
            return pToCheck != null ? pToCheck : pValueIfNull;
        }

        public static <T> T valueOr(T pToCheck, T pValueIfNull) {
            return pToCheck != null ? pToCheck : pValueIfNull;
        }
    }

    public static class Check {
        public static boolean value(Object pToCheck) {
            return null != pToCheck;
        }
    }

    public static class Validate {
        public static boolean value(String pName, Object pToCheck, Expectation pExpectation) {
            boolean zAcceptable = Check.value(pToCheck);
            if (!zAcceptable) {
                pExpectation.unmet(pName, pToCheck, NotNull.EXPECTATION);
            }
            return zAcceptable;
        }
    }
}

