/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import liquibase.Liquibase;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.LiquibaseException;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseDbclHistoryMojo
extends AbstractLiquibaseMojo {
    @PropertyElement
    protected String driverPropertiesFile;
    @PropertyElement
    protected File outputFile;
    @PropertyElement
    protected String format;

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        CommandScope liquibaseCommand = new CommandScope(new String[]{"dbclHistory"});
        liquibaseCommand.addArgumentValue("format", (Object)this.format);
        liquibaseCommand.addArgumentValue("verbose", (Object)this.verbose);
        liquibaseCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG, (Object)this.username);
        liquibaseCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG, (Object)this.password);
        liquibaseCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)this.url);
        liquibaseCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.DEFAULT_SCHEMA_NAME_ARG, (Object)this.defaultSchemaName);
        liquibaseCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.DEFAULT_CATALOG_NAME_ARG, (Object)this.defaultCatalogName);
        liquibaseCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.DRIVER_ARG, (Object)this.driver);
        liquibaseCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.DRIVER_PROPERTIES_FILE_ARG, (Object)this.driverPropertiesFile);
        if (this.outputFile != null) {
            try {
                liquibaseCommand.setOutput(Files.newOutputStream(this.outputFile.toPath(), new OpenOption[0]));
            }
            catch (IOException e) {
                throw new CommandExecutionException((Throwable)e);
            }
        }
        liquibaseCommand.execute();
    }
}

