/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.logging.LogFactory;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.ui.UIFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.liquibase.maven.plugins.MavenResourceAccessor;
import org.liquibase.maven.plugins.MavenUtils;

public abstract class AbstractLiquibaseMojo
extends AbstractMojo {
    private static final String DEFAULT_FIELD_SUFFIX = "Default";
    protected String driver;
    protected String url;
    protected WagonManager wagonManager;
    private String server;
    protected String username;
    protected String password;
    protected boolean emptyPassword;
    protected String defaultCatalogName;
    protected String defaultSchemaName;
    protected String databaseClass;
    protected boolean promptOnNonLocalDatabase;
    protected boolean includeArtifact;
    protected boolean includeTestOutputDirectory;
    protected boolean verbose;
    protected String logging;
    protected String propertyFile;
    protected boolean propertyFileWillOverride;
    protected boolean clearCheckSums;
    protected Properties systemProperties;
    protected MavenProject project;
    private Liquibase liquibase;
    private Properties expressionVars;
    protected boolean skip;
    private Map expressionVariables;
    protected String outputFileEncoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String shouldRunProperty;
        AuthenticationInfo info;
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        if (this.server != null && (info = this.wagonManager.getAuthenticationInfo(this.server)) != null) {
            this.username = info.getUserName();
            this.password = info.getPassword();
        }
        if ((shouldRunProperty = System.getProperty("liquibase.should.run")) != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            this.getLog().info((CharSequence)"Liquibase did not run because 'liquibase.should.run' system property was set to false");
            return;
        }
        if (this.skip) {
            this.getLog().warn((CharSequence)"Liquibase skipped due to maven configuration");
            return;
        }
        this.processSystemProperties();
        ClassLoader artifactClassLoader = this.getMavenArtifactClassLoader();
        this.configureFieldsAndValues(this.getFileOpener(artifactClassLoader));
        try {
            LogFactory.setLoggingLevel((String)this.logging);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Failed to set logging level: " + e.getMessage(), (Exception)e);
        }
        this.displayMojoSettings();
        this.checkRequiredParametersAreSpecified();
        Database database = null;
        try {
            String dbPassword = this.emptyPassword || this.password == null ? "" : this.password;
            database = CommandLineUtils.createDatabaseObject((ClassLoader)artifactClassLoader, (String)this.url, (String)this.username, (String)dbPassword, (String)this.driver, (String)this.defaultCatalogName, (String)this.defaultSchemaName, (String)this.databaseClass, null);
            this.liquibase = this.createLiquibase(this.getFileOpener(artifactClassLoader), database);
            this.getLog().debug((CharSequence)("expressionVars = " + String.valueOf(this.expressionVars)));
            if (this.expressionVars != null) {
                for (Map.Entry<Object, Object> entry : this.expressionVars.entrySet()) {
                    this.liquibase.setChangeLogParameter(entry.getKey().toString(), entry.getValue());
                }
            }
            this.getLog().debug((CharSequence)("expressionVariables = " + String.valueOf(this.expressionVariables)));
            if (this.expressionVariables != null) {
                for (Map.Entry<Object, Object> entry : this.expressionVariables.entrySet()) {
                    if (entry.getValue() == null) continue;
                    this.liquibase.setChangeLogParameter(entry.getKey().toString(), entry.getValue());
                }
            }
            if (this.clearCheckSums) {
                this.getLog().info((CharSequence)"Clearing the Liquibase Checksums on the database");
                this.liquibase.clearCheckSums();
            }
            this.getLog().info((CharSequence)("Executing on Database: " + this.url));
            if (this.isPromptOnNonLocalDatabase() && !this.liquibase.isSafeToRunUpdate() && UIFactory.getInstance().getFacade().promptForNonLocalDatabase(this.liquibase.getDatabase())) {
                throw new LiquibaseException("User decided not to run against non-local database");
            }
            this.performLiquibaseTask(this.liquibase);
        }
        catch (LiquibaseException e) {
            this.cleanup(database);
            throw new MojoExecutionException("Error setting up or running Liquibase: " + e.getMessage(), (Exception)((Object)e));
        }
        this.cleanup(database);
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"");
    }

    protected Liquibase getLiquibase() {
        return this.liquibase;
    }

    protected abstract void performLiquibaseTask(Liquibase var1) throws LiquibaseException;

    protected boolean isPromptOnNonLocalDatabase() {
        return this.promptOnNonLocalDatabase;
    }

    private void displayMojoSettings() {
        if (this.verbose) {
            this.getLog().info((CharSequence)"Settings----------------------------");
            this.printSettings("    ");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    protected Liquibase createLiquibase(ResourceAccessor fo, Database db) throws MojoExecutionException {
        try {
            return new Liquibase("", fo, db);
        }
        catch (LiquibaseException ex) {
            throw new MojoExecutionException("Error creating liquibase: " + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void configureFieldsAndValues(ResourceAccessor fo) throws MojoExecutionException, MojoFailureException {
        if (this.propertyFile != null) {
            this.getLog().info((CharSequence)"Parsing Liquibase Properties File");
            this.getLog().info((CharSequence)("  File: " + this.propertyFile));
            try {
                InputStream is = fo.getResourceAsStream(this.propertyFile);
                if (is == null) {
                    throw new MojoFailureException("Failed to resolve the properties file.");
                }
                this.parsePropertiesFile(is);
                this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to resolve properties file", (Exception)e);
            }
        }
    }

    protected ClassLoader getMavenArtifactClassLoader() throws MojoExecutionException {
        try {
            return MavenUtils.getArtifactClassloader(this.project, this.includeArtifact, this.includeTestOutputDirectory, ((Object)((Object)this)).getClass(), this.getLog(), this.verbose);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to create artifact classloader", (Exception)e);
        }
    }

    protected ClassLoader getClassLoaderIncludingProjectClasspath() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURL();
            }
            return new URLClassLoader(urls, this.getMavenArtifactClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create project classloader", e);
        }
    }

    protected ResourceAccessor getFileOpener(ClassLoader cl) {
        MavenResourceAccessor mFO = new MavenResourceAccessor(cl);
        FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor(this.project.getBasedir().getAbsolutePath());
        return new CompositeResourceAccessor(new ResourceAccessor[]{mFO, fsFO});
    }

    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        if (this.driver == null) {
            throw new MojoFailureException("The driver has not been specified either as a parameter or in a properties file.");
        }
        if (this.url == null) {
            throw new MojoFailureException("The database URL has not been specified either as a parameter or in a properties file.");
        }
        if (this.password != null && this.emptyPassword) {
            throw new MojoFailureException("A password cannot be present and the empty password property both be specified.");
        }
    }

    protected void printSettings(String indent) {
        if (indent == null) {
            indent = "";
        }
        this.getLog().info((CharSequence)(indent + "driver: " + this.driver));
        this.getLog().info((CharSequence)(indent + "url: " + this.url));
        this.getLog().info((CharSequence)(indent + "username: " + this.username));
        this.getLog().info((CharSequence)(indent + "password: " + "*****"));
        this.getLog().info((CharSequence)(indent + "use empty password: " + this.emptyPassword));
        this.getLog().info((CharSequence)(indent + "properties file: " + this.propertyFile));
        this.getLog().info((CharSequence)(indent + "properties file will override? " + this.propertyFileWillOverride));
        this.getLog().info((CharSequence)(indent + "prompt on non-local database? " + this.promptOnNonLocalDatabase));
        this.getLog().info((CharSequence)(indent + "clear checksums? " + this.clearCheckSums));
    }

    protected void cleanup(Database db) {
        if (this.getLiquibase() != null) {
            try {
                this.getLiquibase().forceReleaseLocks();
            }
            catch (LiquibaseException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        if (db != null) {
            try {
                db.rollback();
                db.close();
            }
            catch (DatabaseException e) {
                this.getLog().error((CharSequence)"Failed to close open connection to database.", (Throwable)e);
            }
        }
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws MojoExecutionException {
        if (propertiesInputStream == null) {
            throw new MojoExecutionException("Properties file InputStream is null.");
        }
        Properties props = new Properties();
        try {
            props.load(propertiesInputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load the properties Liquibase file", (Exception)e);
        }
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
                Field field = MavenUtils.getDeclaredField(((Object)((Object)this)).getClass(), key);
                if (this.propertyFileWillOverride) {
                    this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                    this.setFieldValue(field, props.get(key).toString());
                    continue;
                }
                if (this.isCurrentFieldValueSpecified(field)) continue;
                this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                this.setFieldValue(field, props.get(key).toString());
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("  '" + key + "' in properties file is not being used by this " + "task."));
            }
        }
    }

    private boolean isCurrentFieldValueSpecified(Field f) throws IllegalAccessException {
        Object currentValue = f.get((Object)this);
        if (currentValue == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(f);
        if (defaultValue == null) {
            return currentValue != null;
        }
        return !defaultValue.equals(f.get((Object)this));
    }

    private Object getDefaultValue(Field field) throws IllegalAccessException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields()));
        allFields.addAll(Arrays.asList(AbstractLiquibaseMojo.class.getDeclaredFields()));
        for (Field f : allFields) {
            if (!f.getName().equals(field.getName() + DEFAULT_FIELD_SUFFIX)) continue;
            f.setAccessible(true);
            return f.get((Object)this);
        }
        return null;
    }

    private void setFieldValue(Field field, String value) throws IllegalAccessException {
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set((Object)this, Boolean.valueOf(value));
        } else {
            field.set((Object)this, value);
        }
    }

    private void processSystemProperties() {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        for (String string : this.systemProperties.keySet()) {
            String value = this.systemProperties.getProperty(string);
            System.setProperty(string, value);
        }
    }
}

