/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import org.apache.maven.plugin.MojoExecutionException;
import org.liquibase.maven.plugins.LiquibaseRollback;

public class LiquibaseRollbackSQL
extends LiquibaseRollback {
    protected File migrationSqlOutputFile;
    private Writer outputWriter;

    protected boolean isPromptOnNonLocalDatabase() {
        return false;
    }

    protected Liquibase createLiquibase(ResourceAccessor fo, Database db) throws MojoExecutionException {
        Liquibase liquibase = super.createLiquibase(fo, db);
        try {
            if (!this.migrationSqlOutputFile.exists()) {
                this.migrationSqlOutputFile.getParentFile().mkdirs();
                if (!this.migrationSqlOutputFile.createNewFile()) {
                    throw new MojoExecutionException("Cannot create the migration SQL file; " + this.migrationSqlOutputFile.getAbsolutePath());
                }
            }
            this.outputWriter = new FileWriter(this.migrationSqlOutputFile);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to create SQL output writer", (Exception)e);
        }
        this.getLog().info((CharSequence)("Output SQL Migration File: " + this.migrationSqlOutputFile.getAbsolutePath()));
        return liquibase;
    }

    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "migrationSQLOutputFile: " + this.migrationSqlOutputFile));
    }

    protected void cleanup(Database db) {
        super.cleanup(db);
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        switch (this.type) {
            case COUNT: {
                liquibase.rollback(this.rollbackCount, this.contexts, this.outputWriter);
                break;
            }
            case DATE: {
                DateFormat format = DateFormat.getDateInstance();
                try {
                    liquibase.rollback(format.parse(this.rollbackDate), this.contexts, this.outputWriter);
                    break;
                }
                catch (ParseException e) {
                    String message = "Error parsing rollbackDate: " + e.getMessage();
                    if (format instanceof SimpleDateFormat) {
                        message = message + "\nDate must match pattern: " + ((SimpleDateFormat)format).toPattern();
                    }
                    throw new LiquibaseException(message, (Throwable)e);
                }
            }
            case TAG: {
                liquibase.rollback(this.rollbackTag, this.contexts, this.outputWriter);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected rollback type, " + (Object)((Object)this.type));
            }
        }
    }
}

