/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.DirectoryPathHandler;
import liquibase.resource.Resource;
import liquibase.util.LiquibaseLauncherSettings;

public class ParameterUtil {
    public static String getParameter(LiquibaseLauncherSettings.LiquibaseLauncherSetting param, String cmd, String[] args, boolean verifyDefaultsFile) throws IOException {
        String parameter = LiquibaseLauncherSettings.getSetting((LiquibaseLauncherSettings.LiquibaseLauncherSetting)param);
        if (parameter != null) {
            return parameter;
        }
        for (String arg : args) {
            String[] cp;
            if (!arg.matches("--.*" + cmd + "=.*") || (cp = arg.split("=")).length != 2) continue;
            return cp[1];
        }
        if (verifyDefaultsFile) {
            return ParameterUtil.getParameterFromPropertiesFile(cmd, args);
        }
        return null;
    }

    private static String getParameterFromPropertiesFile(String cmd, String[] args) throws IOException {
        Resource resource;
        String propertiesFile = ParameterUtil.getParameter(LiquibaseLauncherSettings.LiquibaseLauncherSetting.LIQUIBASE_DEFAULTS_FILE, "defaults.*[fF]ile", args, false);
        if (propertiesFile == null) {
            propertiesFile = (String)LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDefaultValue();
        }
        if ((resource = new DirectoryPathHandler().getResource(propertiesFile)).exists()) {
            try (InputStream defaultsStream = resource.openInputStream();){
                String string = ParameterUtil.getPropertyFromInputStream(cmd, defaultsStream);
                return string;
            }
        }
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFile);
        return ParameterUtil.getPropertyFromInputStream(cmd, inputStream);
    }

    private static String getPropertyFromInputStream(String cmd, InputStream defaultsStream) throws IOException {
        if (defaultsStream != null) {
            Properties properties = new Properties();
            properties.load(defaultsStream);
            Optional<Map.Entry> property = properties.entrySet().stream().filter(entry -> entry.getKey().toString().matches(cmd)).findFirst();
            if (property.isPresent()) {
                return property.get().getValue().toString();
            }
        }
        return null;
    }
}

