/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class GPGUtil {
    public static void sign(String filename, String gpgExecutable) throws IOException {
        File file = new File(filename).getAbsoluteFile();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (gpgExecutable == null) {
            gpgExecutable = "gpg";
        }
        if (StringUtils.trimToNull((String)System.getenv("GPG_PASSWORD")) == null) {
            throw new IOException("GPG_PASSWORD not set");
        }
        builder.command(gpgExecutable, "--batch", "--pinentry-mode", "loopback", "--passphrase-fd", "0", "-ab", file.getName());
        builder.directory(file.getParentFile());
        Process process = builder.start();
        try (OutputStream outputStream = process.getOutputStream();){
            outputStream.write(System.getenv("GPG_PASSWORD").getBytes());
        }
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
        Executors.newSingleThreadExecutor().submit(streamGobbler);
        int exitCode = 0;
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        assert (exitCode == 0);
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

