/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ArchiveUtil {
    public static void unzipCli(File file, File liquibaseHome, Logger log, UnzipFilter filter, UnzipTransform transformer) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                File outFile;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || filter != null && !filter.include(entry)) continue;
                String outputFileName = entry.getName();
                if (transformer != null) {
                    outputFileName = transformer.transform(outputFileName);
                }
                boolean newFile = !(outFile = new File(liquibaseHome, outputFileName)).exists();
                outFile.getParentFile().mkdirs();
                try (InputStream in = zipFile.getInputStream(entry);
                     OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                if (newFile) {
                    log.info("Created " + outFile.getAbsolutePath());
                    continue;
                }
                log.info("Replaced " + outFile.getAbsolutePath());
                if (entry.getName().equals("liquibase")) continue;
                outFile.setExecutable(true);
            }
        }
    }

    public static boolean filenameMatches(String name, String artifactPattern) {
        String regexpPattern = artifactPattern.replace(".", "\\.").replace("+", "\\+").replace("*", ".*");
        return name.matches(regexpPattern);
    }

    public static interface UnzipTransform {
        public String transform(String var1);
    }

    public static interface UnzipFilter {
        public boolean include(ZipEntry var1);
    }
}

