/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.util.regex.Pattern;
import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="set-pull-request-comment", requiresProject=false)
public class SetPullRequestCommentMojo
extends AbstractGitHubMojo {
    private static final Logger log = LoggerFactory.getLogger(SetPullRequestCommentMojo.class);
    @Parameter(defaultValue="${mojo.version}")
    private String mojoVersion;
    @Parameter(property="liquibase.sdk.pr.newComment", required=true)
    protected String newComment;
    @Parameter(property="liquibase.sdk.pr.definition", required=true)
    protected String pullRequestDefinition;
    @Parameter(property="liquibase.sdk.pr.replaceCommentPattern")
    protected String replaceCommentPattern;

    public void execute() throws MojoExecutionException {
        try {
            String repo = this.getRepo();
            GitHubClient github = this.createGitHubClient();
            Pattern replaceComment = null;
            if (this.replaceCommentPattern != null) {
                replaceComment = Pattern.compile(this.replaceCommentPattern);
            }
            github.setPullRequestComment(repo, this.newComment, this.pullRequestDefinition, replaceComment, this.mojoVersion);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

