/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.io.File;
import java.io.IOException;
import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import liquibase.sdk.util.ArchiveUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install-snapshot-cli", requiresProject=false)
public class InstallSnapshotCliMojo
extends AbstractGitHubMojo {
    @Parameter(property="liquibase.sdk.branchSearch", defaultValue="master")
    protected String branchSearch;
    @Parameter(property="liquibase.sdk.skipFailedBuilds", defaultValue="false")
    protected Boolean skipFailedBuilds;
    @Parameter(property="liquibase.sdk.liquibaseHome", required=true)
    protected String liquibaseHome;
    @Parameter(property="liquibase.sdk.allowInstall", defaultValue="false")
    protected boolean allowInstall;
    @Parameter(property="liquibase.sdk.workflowId")
    protected String workflowId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File liquibaseHomeDir = new File(this.liquibaseHome);
        if (liquibaseHomeDir.exists()) {
            if (!liquibaseHomeDir.isDirectory()) {
                throw new MojoFailureException("LiquibaseHome " + this.liquibaseHome + " is not a directory");
            }
            if (!new File(liquibaseHomeDir, "liquibase.bat").exists()) {
                throw new MojoFailureException("LiquibaseHome " + this.liquibaseHome + " is not a liquibase home");
            }
        } else if (this.allowInstall) {
            this.log.info("LiquibaseHome " + this.liquibaseHome + " does not exist. Installing new version");
            liquibaseHomeDir.mkdirs();
        } else {
            throw new MojoFailureException("LiquibaseHome " + this.liquibaseHome + " does not exist. To install to a new directory, set allowInstall=true");
        }
        for (String repo : this.getRepos()) {
            this.log.info("Looking for " + this.branchSearch + " from a run in " + repo);
            try {
                GitHubClient github = new GitHubClient(this.githubToken, this.log);
                String matchingLabel = github.findMatchingBranch(repo, this.branchSearch);
                if (matchingLabel == null) {
                    throw new MojoFailureException("Could not find matching branch(es): " + this.branchSearch + " in " + repo);
                }
                this.log.info("Found matching branch: " + matchingLabel);
                if (repo.endsWith("/liquibase")) {
                    String headBranchFilename = matchingLabel.replaceFirst(".*:", "").replaceAll("[^a-zA-Z0-9\\-_]", "_");
                    File file = this.downloadArtifact(github, repo, matchingLabel, "liquibase-zip-" + headBranchFilename);
                    ArchiveUtil.unzipCli(file, liquibaseHomeDir, this.log, path -> {
                        if (path.getName().equals("internal/lib/liquibase-commercial.jar")) {
                            return !this.repo.contains("liquibase-pro");
                        }
                        return true;
                    }, null);
                    continue;
                }
                if (repo.equals("liquibase/liquibase-pro")) {
                    File file = this.downloadArtifact(github, repo, matchingLabel, "liquibase-commercial-modules");
                    ArchiveUtil.unzipCli(file, liquibaseHomeDir, this.log, path -> path.getName().endsWith("liquibase-commercial-0-SNAPSHOT.jar"), path -> {
                        if (path.equals("liquibase-commercial-0-SNAPSHOT.jar")) {
                            return "internal/lib/liquibase-commercial.jar";
                        }
                        return path;
                    });
                    continue;
                }
                throw new MojoExecutionException("Unknown repo: " + repo);
            }
            catch (MojoExecutionException | MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private File downloadArtifact(GitHubClient github, String repo, String matchingLabel, String artifactName) throws IOException, MojoFailureException {
        File file = github.downloadArtifact(repo, matchingLabel, artifactName, GitHubClient.getWorkflowId(repo, this.workflowId), this.skipFailedBuilds);
        if (file == null) {
            throw new MojoFailureException("Cannot find " + artifactName + ".zip");
        }
        file.deleteOnExit();
        return file;
    }
}

